/*
 * 1map API
 * 1map API Documentation (<b>Premium</b> and <b>Enterprise</b> Users).  # How it works:  First you will login to the API with the <b><i>API's Login Service</i></b>.  After a successful call to the <b><i>API's Login Service</i></b> you will receive a Token. This Token is needed for all secure calls to the 1map server (To all API calls where there is a lock icon next to it). A Token is only valid per session. The Session and your Token will expire after 2 hours of inactivity or the moment you do a call to the <b><i>API's Logout Service</i></b>.  Please note that all date/time fields are returned in SAST (South Africa Standard Time) time zone and in the <a href=\"https://en.wikipedia.org/wiki/ISO_8601\" target=\"_blank\">ISO 8601</a> format (YYYY-MM-DD[T]HH:mm:ss.SSS[Z]).  Please feel free to contact us at [Support](mailto:support@1map.co.za), should you require any additional API Services not listed below.  See a full working Javascript example and download source code [here](../api/jsmap)  --- 
 *
 * OpenAPI spec version: 1.0.0
 * Contact: support@1map.co.za
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package io.swagger.client.model;

import java.util.Objects;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.client.model.Polygon;
import java.io.IOException;
import org.joda.time.DateTime;

/**
 * Info regarding the selected 1map Erf
 */
@ApiModel(description = "Info regarding the selected 1map Erf")

public class Erf {
  @SerializedName("ervenId")
  private Long ervenId = null;

  @SerializedName("source")
  private String source = null;

  @SerializedName("latitude")
  private Double latitude = null;

  @SerializedName("longitude")
  private Double longitude = null;

  @SerializedName("suburb")
  private String suburb = null;

  @SerializedName("city")
  private String city = null;

  @SerializedName("postalCode")
  private String postalCode = null;

  @SerializedName("provinceCode")
  private String provinceCode = null;

  @SerializedName("municipalCode")
  private String municipalCode = null;

  @SerializedName("vdNumber")
  private String vdNumber = null;

  @SerializedName("allotmentNo")
  private String allotmentNo = null;

  @SerializedName("standNo")
  private String standNo = null;

  @SerializedName("portionNo")
  private String portionNo = null;

  @SerializedName("lisKey")
  private String lisKey = null;

  @SerializedName("erfArea")
  private Double erfArea = null;

  @SerializedName("sgOfficeNo")
  private Integer sgOfficeNo = null;

  @SerializedName("sgOffice")
  private String sgOffice = null;

  @SerializedName("erfLabel")
  private String erfLabel = null;

  @SerializedName("modifiedDate")
  private DateTime modifiedDate = null;

  @SerializedName("feature")
  private Polygon feature = null;

  public Erf ervenId(Long ervenId) {
    this.ervenId = ervenId;
    return this;
  }

   /**
   * The 1map Erven Primary Key
   * @return ervenId
  **/
  @ApiModelProperty(value = "The 1map Erven Primary Key")
  public Long getErvenId() {
    return ervenId;
  }

  public void setErvenId(Long ervenId) {
    this.ervenId = ervenId;
  }

  public Erf source(String source) {
    this.source = source;
    return this;
  }

   /**
   * Source showing where the Erf originated from
   * @return source
  **/
  @ApiModelProperty(value = "Source showing where the Erf originated from")
  public String getSource() {
    return source;
  }

  public void setSource(String source) {
    this.source = source;
  }

  public Erf latitude(Double latitude) {
    this.latitude = latitude;
    return this;
  }

   /**
   * Latitude for the Erf Centroid
   * @return latitude
  **/
  @ApiModelProperty(value = "Latitude for the Erf Centroid")
  public Double getLatitude() {
    return latitude;
  }

  public void setLatitude(Double latitude) {
    this.latitude = latitude;
  }

  public Erf longitude(Double longitude) {
    this.longitude = longitude;
    return this;
  }

   /**
   * Longitude for the Erf Centroid
   * @return longitude
  **/
  @ApiModelProperty(value = "Longitude for the Erf Centroid")
  public Double getLongitude() {
    return longitude;
  }

  public void setLongitude(Double longitude) {
    this.longitude = longitude;
  }

  public Erf suburb(String suburb) {
    this.suburb = suburb;
    return this;
  }

   /**
   * Suburb the erf belongs to
   * @return suburb
  **/
  @ApiModelProperty(value = "Suburb the erf belongs to")
  public String getSuburb() {
    return suburb;
  }

  public void setSuburb(String suburb) {
    this.suburb = suburb;
  }

  public Erf city(String city) {
    this.city = city;
    return this;
  }

   /**
   * Town/City the erf belongs to
   * @return city
  **/
  @ApiModelProperty(value = "Town/City the erf belongs to")
  public String getCity() {
    return city;
  }

  public void setCity(String city) {
    this.city = city;
  }

  public Erf postalCode(String postalCode) {
    this.postalCode = postalCode;
    return this;
  }

   /**
   * Postal Code the erf belongs to
   * @return postalCode
  **/
  @ApiModelProperty(value = "Postal Code the erf belongs to")
  public String getPostalCode() {
    return postalCode;
  }

  public void setPostalCode(String postalCode) {
    this.postalCode = postalCode;
  }

  public Erf provinceCode(String provinceCode) {
    this.provinceCode = provinceCode;
    return this;
  }

   /**
   * Province Code the erf belongs to
   * @return provinceCode
  **/
  @ApiModelProperty(value = "Province Code the erf belongs to")
  public String getProvinceCode() {
    return provinceCode;
  }

  public void setProvinceCode(String provinceCode) {
    this.provinceCode = provinceCode;
  }

  public Erf municipalCode(String municipalCode) {
    this.municipalCode = municipalCode;
    return this;
  }

   /**
   * Municipality the erf belongs to
   * @return municipalCode
  **/
  @ApiModelProperty(value = "Municipality the erf belongs to")
  public String getMunicipalCode() {
    return municipalCode;
  }

  public void setMunicipalCode(String municipalCode) {
    this.municipalCode = municipalCode;
  }

  public Erf vdNumber(String vdNumber) {
    this.vdNumber = vdNumber;
    return this;
  }

   /**
   * VD Number
   * @return vdNumber
  **/
  @ApiModelProperty(value = "VD Number")
  public String getVdNumber() {
    return vdNumber;
  }

  public void setVdNumber(String vdNumber) {
    this.vdNumber = vdNumber;
  }

  public Erf allotmentNo(String allotmentNo) {
    this.allotmentNo = allotmentNo;
    return this;
  }

   /**
   * SG Allotment Number
   * @return allotmentNo
  **/
  @ApiModelProperty(value = "SG Allotment Number")
  public String getAllotmentNo() {
    return allotmentNo;
  }

  public void setAllotmentNo(String allotmentNo) {
    this.allotmentNo = allotmentNo;
  }

  public Erf standNo(String standNo) {
    this.standNo = standNo;
    return this;
  }

   /**
   * SG Stand Number
   * @return standNo
  **/
  @ApiModelProperty(value = "SG Stand Number")
  public String getStandNo() {
    return standNo;
  }

  public void setStandNo(String standNo) {
    this.standNo = standNo;
  }

  public Erf portionNo(String portionNo) {
    this.portionNo = portionNo;
    return this;
  }

   /**
   * SG Portion Number
   * @return portionNo
  **/
  @ApiModelProperty(value = "SG Portion Number")
  public String getPortionNo() {
    return portionNo;
  }

  public void setPortionNo(String portionNo) {
    this.portionNo = portionNo;
  }

  public Erf lisKey(String lisKey) {
    this.lisKey = lisKey;
    return this;
  }

   /**
   * LIS Key
   * @return lisKey
  **/
  @ApiModelProperty(value = "LIS Key")
  public String getLisKey() {
    return lisKey;
  }

  public void setLisKey(String lisKey) {
    this.lisKey = lisKey;
  }

  public Erf erfArea(Double erfArea) {
    this.erfArea = erfArea;
    return this;
  }

   /**
   * Area of the erf in square meters
   * @return erfArea
  **/
  @ApiModelProperty(value = "Area of the erf in square meters")
  public Double getErfArea() {
    return erfArea;
  }

  public void setErfArea(Double erfArea) {
    this.erfArea = erfArea;
  }

  public Erf sgOfficeNo(Integer sgOfficeNo) {
    this.sgOfficeNo = sgOfficeNo;
    return this;
  }

   /**
   * SG Office Number - For use with SG Diagrams
   * @return sgOfficeNo
  **/
  @ApiModelProperty(value = "SG Office Number - For use with SG Diagrams")
  public Integer getSgOfficeNo() {
    return sgOfficeNo;
  }

  public void setSgOfficeNo(Integer sgOfficeNo) {
    this.sgOfficeNo = sgOfficeNo;
  }

  public Erf sgOffice(String sgOffice) {
    this.sgOffice = sgOffice;
    return this;
  }

   /**
   * SG Office Name - For use with SG Diagrams
   * @return sgOffice
  **/
  @ApiModelProperty(value = "SG Office Name - For use with SG Diagrams")
  public String getSgOffice() {
    return sgOffice;
  }

  public void setSgOffice(String sgOffice) {
    this.sgOffice = sgOffice;
  }

  public Erf erfLabel(String erfLabel) {
    this.erfLabel = erfLabel;
    return this;
  }

   /**
   * Label (formated in html) for use with popups
   * @return erfLabel
  **/
  @ApiModelProperty(value = "Label (formated in html) for use with popups")
  public String getErfLabel() {
    return erfLabel;
  }

  public void setErfLabel(String erfLabel) {
    this.erfLabel = erfLabel;
  }

  public Erf modifiedDate(DateTime modifiedDate) {
    this.modifiedDate = modifiedDate;
    return this;
  }

   /**
   * Date last modified
   * @return modifiedDate
  **/
  @ApiModelProperty(value = "Date last modified")
  public DateTime getModifiedDate() {
    return modifiedDate;
  }

  public void setModifiedDate(DateTime modifiedDate) {
    this.modifiedDate = modifiedDate;
  }

  public Erf feature(Polygon feature) {
    this.feature = feature;
    return this;
  }

   /**
   * Parcel/Erf Geometry
   * @return feature
  **/
  @ApiModelProperty(value = "Parcel/Erf Geometry")
  public Polygon getFeature() {
    return feature;
  }

  public void setFeature(Polygon feature) {
    this.feature = feature;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Erf erf = (Erf) o;
    return Objects.equals(this.ervenId, erf.ervenId) &&
        Objects.equals(this.source, erf.source) &&
        Objects.equals(this.latitude, erf.latitude) &&
        Objects.equals(this.longitude, erf.longitude) &&
        Objects.equals(this.suburb, erf.suburb) &&
        Objects.equals(this.city, erf.city) &&
        Objects.equals(this.postalCode, erf.postalCode) &&
        Objects.equals(this.provinceCode, erf.provinceCode) &&
        Objects.equals(this.municipalCode, erf.municipalCode) &&
        Objects.equals(this.vdNumber, erf.vdNumber) &&
        Objects.equals(this.allotmentNo, erf.allotmentNo) &&
        Objects.equals(this.standNo, erf.standNo) &&
        Objects.equals(this.portionNo, erf.portionNo) &&
        Objects.equals(this.lisKey, erf.lisKey) &&
        Objects.equals(this.erfArea, erf.erfArea) &&
        Objects.equals(this.sgOfficeNo, erf.sgOfficeNo) &&
        Objects.equals(this.sgOffice, erf.sgOffice) &&
        Objects.equals(this.erfLabel, erf.erfLabel) &&
        Objects.equals(this.modifiedDate, erf.modifiedDate) &&
        Objects.equals(this.feature, erf.feature);
  }

  @Override
  public int hashCode() {
    return Objects.hash(ervenId, source, latitude, longitude, suburb, city, postalCode, provinceCode, municipalCode, vdNumber, allotmentNo, standNo, portionNo, lisKey, erfArea, sgOfficeNo, sgOffice, erfLabel, modifiedDate, feature);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Erf {\n");
    
    sb.append("    ervenId: ").append(toIndentedString(ervenId)).append("\n");
    sb.append("    source: ").append(toIndentedString(source)).append("\n");
    sb.append("    latitude: ").append(toIndentedString(latitude)).append("\n");
    sb.append("    longitude: ").append(toIndentedString(longitude)).append("\n");
    sb.append("    suburb: ").append(toIndentedString(suburb)).append("\n");
    sb.append("    city: ").append(toIndentedString(city)).append("\n");
    sb.append("    postalCode: ").append(toIndentedString(postalCode)).append("\n");
    sb.append("    provinceCode: ").append(toIndentedString(provinceCode)).append("\n");
    sb.append("    municipalCode: ").append(toIndentedString(municipalCode)).append("\n");
    sb.append("    vdNumber: ").append(toIndentedString(vdNumber)).append("\n");
    sb.append("    allotmentNo: ").append(toIndentedString(allotmentNo)).append("\n");
    sb.append("    standNo: ").append(toIndentedString(standNo)).append("\n");
    sb.append("    portionNo: ").append(toIndentedString(portionNo)).append("\n");
    sb.append("    lisKey: ").append(toIndentedString(lisKey)).append("\n");
    sb.append("    erfArea: ").append(toIndentedString(erfArea)).append("\n");
    sb.append("    sgOfficeNo: ").append(toIndentedString(sgOfficeNo)).append("\n");
    sb.append("    sgOffice: ").append(toIndentedString(sgOffice)).append("\n");
    sb.append("    erfLabel: ").append(toIndentedString(erfLabel)).append("\n");
    sb.append("    modifiedDate: ").append(toIndentedString(modifiedDate)).append("\n");
    sb.append("    feature: ").append(toIndentedString(feature)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
  
}

