/*
 * 1map API
 * 1map API Documentation (<b>Premium</b> and <b>Enterprise</b> Users).  # How it works:  First you will login to the API with the <b><i>API's Login Service</i></b>.  After a successful call to the <b><i>API's Login Service</i></b> you will receive a Token. This Token is needed for all secure calls to the 1map server (To all API calls where there is a lock icon next to it). A Token is only valid per session. The Session and your Token will expire after 2 hours of inactivity or the moment you do a call to the <b><i>API's Logout Service</i></b>.  Please note that all date/time fields are returned in SAST (South Africa Standard Time) time zone and in the <a href=\"https://en.wikipedia.org/wiki/ISO_8601\" target=\"_blank\">ISO 8601</a> format (YYYY-MM-DD[T]HH:mm:ss.SSS[Z]).  Please feel free to contact us at [Support](mailto:support@1map.co.za), should you require any additional API Services not listed below.  See a full working Javascript example and download source code [here](../api/jsmap)  --- 
 *
 * OpenAPI spec version: 1.0.0
 * Contact: support@1map.co.za
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package io.swagger.client.model;

import java.util.Objects;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.client.model.Index;
import java.io.IOException;

/**
 * Info regarding the selected Edit Template
 */
@ApiModel(description = "Info regarding the selected Edit Template")

public class EditTemplate {
  @SerializedName("editTemplateId")
  private Long editTemplateId = null;

  @SerializedName("editTemplateCaption")
  private String editTemplateCaption = null;

  @SerializedName("editTemplateDescription")
  private String editTemplateDescription = null;

  @SerializedName("editTemplateDefault")
  private Boolean editTemplateDefault = null;

  @SerializedName("editTemplateIndex")
  private Index editTemplateIndex = null;

  public EditTemplate editTemplateId(Long editTemplateId) {
    this.editTemplateId = editTemplateId;
    return this;
  }

   /**
   * Edit Template unique 1map id number - Primary Key
   * @return editTemplateId
  **/
  @ApiModelProperty(value = "Edit Template unique 1map id number - Primary Key")
  public Long getEditTemplateId() {
    return editTemplateId;
  }

  public void setEditTemplateId(Long editTemplateId) {
    this.editTemplateId = editTemplateId;
  }

  public EditTemplate editTemplateCaption(String editTemplateCaption) {
    this.editTemplateCaption = editTemplateCaption;
    return this;
  }

   /**
   * Edit Template Caption
   * @return editTemplateCaption
  **/
  @ApiModelProperty(value = "Edit Template Caption")
  public String getEditTemplateCaption() {
    return editTemplateCaption;
  }

  public void setEditTemplateCaption(String editTemplateCaption) {
    this.editTemplateCaption = editTemplateCaption;
  }

  public EditTemplate editTemplateDescription(String editTemplateDescription) {
    this.editTemplateDescription = editTemplateDescription;
    return this;
  }

   /**
   * Edit Template&#39;s description
   * @return editTemplateDescription
  **/
  @ApiModelProperty(value = "Edit Template's description")
  public String getEditTemplateDescription() {
    return editTemplateDescription;
  }

  public void setEditTemplateDescription(String editTemplateDescription) {
    this.editTemplateDescription = editTemplateDescription;
  }

  public EditTemplate editTemplateDefault(Boolean editTemplateDefault) {
    this.editTemplateDefault = editTemplateDefault;
    return this;
  }

   /**
   * Specify whether this Edit Template is the default
   * @return editTemplateDefault
  **/
  @ApiModelProperty(value = "Specify whether this Edit Template is the default")
  public Boolean getEditTemplateDefault() {
    return editTemplateDefault;
  }

  public void setEditTemplateDefault(Boolean editTemplateDefault) {
    this.editTemplateDefault = editTemplateDefault;
  }

  public EditTemplate editTemplateIndex(Index editTemplateIndex) {
    this.editTemplateIndex = editTemplateIndex;
    return this;
  }

   /**
   * Edit Template&#39;s Sort Order Index
   * @return editTemplateIndex
  **/
  @ApiModelProperty(value = "Edit Template's Sort Order Index")
  public Index getEditTemplateIndex() {
    return editTemplateIndex;
  }

  public void setEditTemplateIndex(Index editTemplateIndex) {
    this.editTemplateIndex = editTemplateIndex;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    EditTemplate editTemplate = (EditTemplate) o;
    return Objects.equals(this.editTemplateId, editTemplate.editTemplateId) &&
        Objects.equals(this.editTemplateCaption, editTemplate.editTemplateCaption) &&
        Objects.equals(this.editTemplateDescription, editTemplate.editTemplateDescription) &&
        Objects.equals(this.editTemplateDefault, editTemplate.editTemplateDefault) &&
        Objects.equals(this.editTemplateIndex, editTemplate.editTemplateIndex);
  }

  @Override
  public int hashCode() {
    return Objects.hash(editTemplateId, editTemplateCaption, editTemplateDescription, editTemplateDefault, editTemplateIndex);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class EditTemplate {\n");
    
    sb.append("    editTemplateId: ").append(toIndentedString(editTemplateId)).append("\n");
    sb.append("    editTemplateCaption: ").append(toIndentedString(editTemplateCaption)).append("\n");
    sb.append("    editTemplateDescription: ").append(toIndentedString(editTemplateDescription)).append("\n");
    sb.append("    editTemplateDefault: ").append(toIndentedString(editTemplateDefault)).append("\n");
    sb.append("    editTemplateIndex: ").append(toIndentedString(editTemplateIndex)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
  
}

