/*
 * 1map API
 * 1map API Documentation (<b>Premium</b> and <b>Enterprise</b> Users).  # How it works:  First you will login to the API with the <b><i>API's Login Service</i></b>.  After a successful call to the <b><i>API's Login Service</i></b> you will receive a Token. This Token is needed for all secure calls to the 1map server (To all API calls where there is a lock icon next to it). A Token is only valid per session. The Session and your Token will expire after 2 hours of inactivity or the moment you do a call to the <b><i>API's Logout Service</i></b>.  Please note that all date/time fields are returned in SAST (South Africa Standard Time) time zone and in the <a href=\"https://en.wikipedia.org/wiki/ISO_8601\" target=\"_blank\">ISO 8601</a> format (YYYY-MM-DD[T]HH:mm:ss.SSS[Z]).  Please feel free to contact us at [Support](mailto:support@1map.co.za), should you require any additional API Services not listed below.  See a full working Javascript example and download source code [here](../api/jsmap)  --- 
 *
 * OpenAPI spec version: 1.0.0
 * Contact: support@1map.co.za
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package io.swagger.client.model;

import java.util.Objects;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;

/**
 * Info regarding the selected contact
 */
@ApiModel(description = "Info regarding the selected contact")

public class Contact {
  @SerializedName("name")
  private String name = null;

  @SerializedName("number")
  private String number = null;

  @SerializedName("email")
  private String email = null;

  @SerializedName("fax")
  private String fax = null;

  @SerializedName("company")
  private String company = null;

  public Contact name(String name) {
    this.name = name;
    return this;
  }

   /**
   * Contact Name
   * @return name
  **/
  @ApiModelProperty(value = "Contact Name")
  public String getName() {
    return name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public Contact number(String number) {
    this.number = number;
    return this;
  }

   /**
   * Contact telephone / cellphone number
   * @return number
  **/
  @ApiModelProperty(value = "Contact telephone / cellphone number")
  public String getNumber() {
    return number;
  }

  public void setNumber(String number) {
    this.number = number;
  }

  public Contact email(String email) {
    this.email = email;
    return this;
  }

   /**
   * Contact email address
   * @return email
  **/
  @ApiModelProperty(value = "Contact email address")
  public String getEmail() {
    return email;
  }

  public void setEmail(String email) {
    this.email = email;
  }

  public Contact fax(String fax) {
    this.fax = fax;
    return this;
  }

   /**
   * Contact fax number
   * @return fax
  **/
  @ApiModelProperty(value = "Contact fax number")
  public String getFax() {
    return fax;
  }

  public void setFax(String fax) {
    this.fax = fax;
  }

  public Contact company(String company) {
    this.company = company;
    return this;
  }

   /**
   * Contact company name
   * @return company
  **/
  @ApiModelProperty(value = "Contact company name")
  public String getCompany() {
    return company;
  }

  public void setCompany(String company) {
    this.company = company;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Contact contact = (Contact) o;
    return Objects.equals(this.name, contact.name) &&
        Objects.equals(this.number, contact.number) &&
        Objects.equals(this.email, contact.email) &&
        Objects.equals(this.fax, contact.fax) &&
        Objects.equals(this.company, contact.company);
  }

  @Override
  public int hashCode() {
    return Objects.hash(name, number, email, fax, company);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Contact {\n");
    
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    number: ").append(toIndentedString(number)).append("\n");
    sb.append("    email: ").append(toIndentedString(email)).append("\n");
    sb.append("    fax: ").append(toIndentedString(fax)).append("\n");
    sb.append("    company: ").append(toIndentedString(company)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
  
}

