/*
 * 1map API
 * 1map API Documentation (<b>Premium</b> and <b>Enterprise</b> Users).  # How it works:  First you will login to the API with the <b><i>API's Login Service</i></b>.  After a successful call to the <b><i>API's Login Service</i></b> you will receive a Token. This Token is needed for all secure calls to the 1map server (To all API calls where there is a lock icon next to it). A Token is only valid per session. The Session and your Token will expire after 2 hours of inactivity or the moment you do a call to the <b><i>API's Logout Service</i></b>.  Please note that all date/time fields are returned in SAST (South Africa Standard Time) time zone and in the <a href=\"https://en.wikipedia.org/wiki/ISO_8601\" target=\"_blank\">ISO 8601</a> format (YYYY-MM-DD[T]HH:mm:ss.SSS[Z]).  Please feel free to contact us at [Support](mailto:support@1map.co.za), should you require any additional API Services not listed below.  See a full working Javascript example and download source code [here](../api/jsmap)  --- 
 *
 * OpenAPI spec version: 1.0.0
 * Contact: support@1map.co.za
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package io.swagger.client.model;

import java.util.Objects;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import org.joda.time.DateTime;

/**
 * Info regarding the selected billing
 */
@ApiModel(description = "Info regarding the selected billing")

public class Billing {
  @SerializedName("type")
  private String type = null;

  @SerializedName("cycle")
  private String cycle = null;

  @SerializedName("address")
  private String address = null;

  @SerializedName("start")
  private DateTime start = null;

  @SerializedName("end")
  private DateTime end = null;

  public Billing type(String type) {
    this.type = type;
    return this;
  }

   /**
   * Billing type - Paygate, Debit Order, EFT, Free
   * @return type
  **/
  @ApiModelProperty(value = "Billing type - Paygate, Debit Order, EFT, Free")
  public String getType() {
    return type;
  }

  public void setType(String type) {
    this.type = type;
  }

  public Billing cycle(String cycle) {
    this.cycle = cycle;
    return this;
  }

   /**
   * Billing cycle - Daily, Monthly, 3 Monthly, 6 Monthly, Annualy
   * @return cycle
  **/
  @ApiModelProperty(value = "Billing cycle - Daily, Monthly, 3 Monthly, 6 Monthly, Annualy")
  public String getCycle() {
    return cycle;
  }

  public void setCycle(String cycle) {
    this.cycle = cycle;
  }

  public Billing address(String address) {
    this.address = address;
    return this;
  }

   /**
   * Billing address
   * @return address
  **/
  @ApiModelProperty(value = "Billing address")
  public String getAddress() {
    return address;
  }

  public void setAddress(String address) {
    this.address = address;
  }

  public Billing start(DateTime start) {
    this.start = start;
    return this;
  }

   /**
   * Billing start date
   * @return start
  **/
  @ApiModelProperty(value = "Billing start date")
  public DateTime getStart() {
    return start;
  }

  public void setStart(DateTime start) {
    this.start = start;
  }

  public Billing end(DateTime end) {
    this.end = end;
    return this;
  }

   /**
   * Billing expiry date
   * @return end
  **/
  @ApiModelProperty(value = "Billing expiry date")
  public DateTime getEnd() {
    return end;
  }

  public void setEnd(DateTime end) {
    this.end = end;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Billing billing = (Billing) o;
    return Objects.equals(this.type, billing.type) &&
        Objects.equals(this.cycle, billing.cycle) &&
        Objects.equals(this.address, billing.address) &&
        Objects.equals(this.start, billing.start) &&
        Objects.equals(this.end, billing.end);
  }

  @Override
  public int hashCode() {
    return Objects.hash(type, cycle, address, start, end);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Billing {\n");
    
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    cycle: ").append(toIndentedString(cycle)).append("\n");
    sb.append("    address: ").append(toIndentedString(address)).append("\n");
    sb.append("    start: ").append(toIndentedString(start)).append("\n");
    sb.append("    end: ").append(toIndentedString(end)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
  
}

