/*
 * 1map API
 * 1map API Documentation (<b>Premium</b> and <b>Enterprise</b> Users).  # How it works:  First you will login to the API with the <b><i>API's Login Service</i></b>.  After a successful call to the <b><i>API's Login Service</i></b> you will receive a Token. This Token is needed for all secure calls to the 1map server (To all API calls where there is a lock icon next to it). A Token is only valid per session. The Session and your Token will expire after 2 hours of inactivity or the moment you do a call to the <b><i>API's Logout Service</i></b>.  Please note that all date/time fields are returned in SAST (South Africa Standard Time) time zone and in the <a href=\"https://en.wikipedia.org/wiki/ISO_8601\" target=\"_blank\">ISO 8601</a> format (YYYY-MM-DD[T]HH:mm:ss.SSS[Z]).  Please feel free to contact us at [Support](mailto:support@1map.co.za), should you require any additional API Services not listed below.  See a full working Javascript example and download source code [here](../api/jsmap)  --- 
 *
 * OpenAPI spec version: 1.0.0
 * Contact: support@1map.co.za
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package io.swagger.client.model;

import java.util.Objects;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.client.model.BoundingBox;
import io.swagger.client.model.CRSDef;
import io.swagger.client.model.FeatureWithAttachments;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/**
 * List of all Attributes from the result
 */
@ApiModel(description = "List of all Attributes from the result")

public class AttributesCollection {
  /**
   * Always FeatureCollection
   */
  @JsonAdapter(TypeEnum.Adapter.class)
  public enum TypeEnum {
    FEATURECOLLECTION("FeatureCollection");

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static TypeEnum fromValue(String text) {
      for (TypeEnum b : TypeEnum.values()) {
        if (String.valueOf(b.value).equals(text)) {
          return b;
        }
      }
      return null;
    }

    public static class Adapter extends TypeAdapter<TypeEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final TypeEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public TypeEnum read(final JsonReader jsonReader) throws IOException {
        String value = jsonReader.nextString();
        return TypeEnum.fromValue(String.valueOf(value));
      }
    }
  }

  @SerializedName("type")
  private TypeEnum type = null;

  @SerializedName("totalFeatures")
  private Long totalFeatures = null;

  @SerializedName("features")
  private List<FeatureWithAttachments> features = null;

  @SerializedName("crs")
  private CRSDef crs = null;

  @SerializedName("bbox")
  private BoundingBox bbox = null;

  public AttributesCollection type(TypeEnum type) {
    this.type = type;
    return this;
  }

   /**
   * Always FeatureCollection
   * @return type
  **/
  @ApiModelProperty(example = "FeatureCollection", value = "Always FeatureCollection")
  public TypeEnum getType() {
    return type;
  }

  public void setType(TypeEnum type) {
    this.type = type;
  }

  public AttributesCollection totalFeatures(Long totalFeatures) {
    this.totalFeatures = totalFeatures;
    return this;
  }

   /**
   * Number of Attributes (Records)
   * @return totalFeatures
  **/
  @ApiModelProperty(example = "1", value = "Number of Attributes (Records)")
  public Long getTotalFeatures() {
    return totalFeatures;
  }

  public void setTotalFeatures(Long totalFeatures) {
    this.totalFeatures = totalFeatures;
  }

  public AttributesCollection features(List<FeatureWithAttachments> features) {
    this.features = features;
    return this;
  }

  public AttributesCollection addFeaturesItem(FeatureWithAttachments featuresItem) {
    if (this.features == null) {
      this.features = new ArrayList<FeatureWithAttachments>();
    }
    this.features.add(featuresItem);
    return this;
  }

   /**
   * Get features
   * @return features
  **/
  @ApiModelProperty(value = "")
  public List<FeatureWithAttachments> getFeatures() {
    return features;
  }

  public void setFeatures(List<FeatureWithAttachments> features) {
    this.features = features;
  }

  public AttributesCollection crs(CRSDef crs) {
    this.crs = crs;
    return this;
  }

   /**
   * The CRS/Projection used
   * @return crs
  **/
  @ApiModelProperty(value = "The CRS/Projection used")
  public CRSDef getCrs() {
    return crs;
  }

  public void setCrs(CRSDef crs) {
    this.crs = crs;
  }

  public AttributesCollection bbox(BoundingBox bbox) {
    this.bbox = bbox;
    return this;
  }

   /**
   * The Bounding Box/Area of all features/records
   * @return bbox
  **/
  @ApiModelProperty(value = "The Bounding Box/Area of all features/records")
  public BoundingBox getBbox() {
    return bbox;
  }

  public void setBbox(BoundingBox bbox) {
    this.bbox = bbox;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    AttributesCollection attributesCollection = (AttributesCollection) o;
    return Objects.equals(this.type, attributesCollection.type) &&
        Objects.equals(this.totalFeatures, attributesCollection.totalFeatures) &&
        Objects.equals(this.features, attributesCollection.features) &&
        Objects.equals(this.crs, attributesCollection.crs) &&
        Objects.equals(this.bbox, attributesCollection.bbox);
  }

  @Override
  public int hashCode() {
    return Objects.hash(type, totalFeatures, features, crs, bbox);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class AttributesCollection {\n");
    
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    totalFeatures: ").append(toIndentedString(totalFeatures)).append("\n");
    sb.append("    features: ").append(toIndentedString(features)).append("\n");
    sb.append("    crs: ").append(toIndentedString(crs)).append("\n");
    sb.append("    bbox: ").append(toIndentedString(bbox)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
  
}

