/*
 * 1map API
 * 1map API Documentation (<b>Premium</b> and <b>Enterprise</b> Users).  # How it works:  First you will login to the API with the <b><i>API's Login Service</i></b>.  After a successful call to the <b><i>API's Login Service</i></b> you will receive a Token. This Token is needed for all secure calls to the 1map server (To all API calls where there is a lock icon next to it). A Token is only valid per session. The Session and your Token will expire after 2 hours of inactivity or the moment you do a call to the <b><i>API's Logout Service</i></b>.  Please note that all date/time fields are returned in SAST (South Africa Standard Time) time zone and in the <a href=\"https://en.wikipedia.org/wiki/ISO_8601\" target=\"_blank\">ISO 8601</a> format (YYYY-MM-DD[T]HH:mm:ss.SSS[Z]).  Please feel free to contact us at [Support](mailto:support@1map.co.za), should you require any additional API Services not listed below.  See a full working Javascript example and download source code [here](../api/jsmap)  --- 
 *
 * OpenAPI spec version: 1.0.0
 * Contact: support@1map.co.za
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package io.swagger.client.model;

import java.util.Objects;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;

/**
 * AttachmentsCollectionCameraPosition
 */

public class AttachmentsCollectionCameraPosition {
  @SerializedName("latitude")
  private Double latitude = null;

  @SerializedName("longitude")
  private Double longitude = null;

  @SerializedName("altitude")
  private Double altitude = null;

  @SerializedName("angle")
  private Double angle = null;

  public AttachmentsCollectionCameraPosition latitude(Double latitude) {
    this.latitude = latitude;
    return this;
  }

   /**
   * Latitude of position where Attachment was taken/recorded
   * @return latitude
  **/
  @ApiModelProperty(value = "Latitude of position where Attachment was taken/recorded")
  public Double getLatitude() {
    return latitude;
  }

  public void setLatitude(Double latitude) {
    this.latitude = latitude;
  }

  public AttachmentsCollectionCameraPosition longitude(Double longitude) {
    this.longitude = longitude;
    return this;
  }

   /**
   * Longitude of position where Attachment was taken/recorded
   * @return longitude
  **/
  @ApiModelProperty(value = "Longitude of position where Attachment was taken/recorded")
  public Double getLongitude() {
    return longitude;
  }

  public void setLongitude(Double longitude) {
    this.longitude = longitude;
  }

  public AttachmentsCollectionCameraPosition altitude(Double altitude) {
    this.altitude = altitude;
    return this;
  }

   /**
   * Altitude of position where Attachment was taken/recorded
   * @return altitude
  **/
  @ApiModelProperty(value = "Altitude of position where Attachment was taken/recorded")
  public Double getAltitude() {
    return altitude;
  }

  public void setAltitude(Double altitude) {
    this.altitude = altitude;
  }

  public AttachmentsCollectionCameraPosition angle(Double angle) {
    this.angle = angle;
    return this;
  }

   /**
   * Angle of camera when Attachment was taken/recorded
   * @return angle
  **/
  @ApiModelProperty(value = "Angle of camera when Attachment was taken/recorded")
  public Double getAngle() {
    return angle;
  }

  public void setAngle(Double angle) {
    this.angle = angle;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    AttachmentsCollectionCameraPosition attachmentsCollectionCameraPosition = (AttachmentsCollectionCameraPosition) o;
    return Objects.equals(this.latitude, attachmentsCollectionCameraPosition.latitude) &&
        Objects.equals(this.longitude, attachmentsCollectionCameraPosition.longitude) &&
        Objects.equals(this.altitude, attachmentsCollectionCameraPosition.altitude) &&
        Objects.equals(this.angle, attachmentsCollectionCameraPosition.angle);
  }

  @Override
  public int hashCode() {
    return Objects.hash(latitude, longitude, altitude, angle);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class AttachmentsCollectionCameraPosition {\n");
    
    sb.append("    latitude: ").append(toIndentedString(latitude)).append("\n");
    sb.append("    longitude: ").append(toIndentedString(longitude)).append("\n");
    sb.append("    altitude: ").append(toIndentedString(altitude)).append("\n");
    sb.append("    angle: ").append(toIndentedString(angle)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
  
}

