/*
 * 1map API
 * 1map API Documentation (<b>Premium</b> and <b>Enterprise</b> Users).  # How it works:  First you will login to the API with the <b><i>API's Login Service</i></b>.  After a successful call to the <b><i>API's Login Service</i></b> you will receive a Token. This Token is needed for all secure calls to the 1map server (To all API calls where there is a lock icon next to it). A Token is only valid per session. The Session and your Token will expire after 2 hours of inactivity or the moment you do a call to the <b><i>API's Logout Service</i></b>.  Please note that all date/time fields are returned in SAST (South Africa Standard Time) time zone and in the <a href=\"https://en.wikipedia.org/wiki/ISO_8601\" target=\"_blank\">ISO 8601</a> format (YYYY-MM-DD[T]HH:mm:ss.SSS[Z]).  Please feel free to contact us at [Support](mailto:support@1map.co.za), should you require any additional API Services not listed below.  See a full working Javascript example and download source code [here](../api/jsmap)  --- 
 *
 * OpenAPI spec version: 1.0.0
 * Contact: support@1map.co.za
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package io.swagger.client.model;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModelProperty;

import java.io.IOException;
import java.util.Objects;

/**
 * AttachmentsCollection
 */

public class AttachmentsCollection {
  @SerializedName("attachmentId")
  private Long attachmentId = null;

  /**
   * The attachment type (audio, image, text, video)
   */
  @JsonAdapter(TypeEnum.Adapter.class)
  public enum TypeEnum {
    AUDIO("audio"),
    
    IMAGE("image"),
    
    TEXT("text"),
    
    VIDEO("video");

    private String value;

    TypeEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static TypeEnum fromValue(String text) {
      for (TypeEnum b : TypeEnum.values()) {
        if (String.valueOf(b.value).equals(text)) {
          return b;
        }
      }
      return null;
    }

    public static class Adapter extends TypeAdapter<TypeEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final TypeEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public TypeEnum read(final JsonReader jsonReader) throws IOException {
        String value = jsonReader.nextString();
        return TypeEnum.fromValue(String.valueOf(value));
      }
    }
  }

  @SerializedName("type")
  private TypeEnum type = null;

  /**
   * The attachment header (audio/3gpp, image/jpeg, text/plain, video/mp4)
   */
  @JsonAdapter(HeaderEnum.Adapter.class)
  public enum HeaderEnum {
    AUDIO_3GPP("audio/3gpp"),
    
    IMAGE_JPEG("image/jpeg"),
    
    TEXT_PLAIN("text/plain"),
    
    VIDEO_MP4("video/mp4");

    private String value;

    HeaderEnum(String value) {
      this.value = value;
    }

    public String getValue() {
      return value;
    }

    @Override
    public String toString() {
      return String.valueOf(value);
    }

    public static HeaderEnum fromValue(String text) {
      for (HeaderEnum b : HeaderEnum.values()) {
        if (String.valueOf(b.value).equals(text)) {
          return b;
        }
      }
      return null;
    }

    public static class Adapter extends TypeAdapter<HeaderEnum> {
      @Override
      public void write(final JsonWriter jsonWriter, final HeaderEnum enumeration) throws IOException {
        jsonWriter.value(enumeration.getValue());
      }

      @Override
      public HeaderEnum read(final JsonReader jsonReader) throws IOException {
        String value = jsonReader.nextString();
        return HeaderEnum.fromValue(String.valueOf(value));
      }
    }
  }

  @SerializedName("header")
  private HeaderEnum header = null;

  @SerializedName("uploaded")
  private AttachmentsCollectionUploaded uploaded = null;

  @SerializedName("caption")
  private String caption = null;

  @SerializedName("description")
  private String description = null;

  @SerializedName("cameraPosition")
  private AttachmentsCollectionCameraPosition cameraPosition = null;

  public AttachmentsCollection attachmentId(Long attachmentId) {
    this.attachmentId = attachmentId;
    return this;
  }

   /**
   * The unique 1map Attachment Id
   * @return attachmentId
  **/
  @ApiModelProperty(value = "The unique 1map Attachment Id")
  public Long getAttachmentId() {
    return attachmentId;
  }

  public void setAttachmentId(Long attachmentId) {
    this.attachmentId = attachmentId;
  }

  public AttachmentsCollection type(TypeEnum type) {
    this.type = type;
    return this;
  }

   /**
   * The attachment type (audio, image, text, video)
   * @return type
  **/
  @ApiModelProperty(value = "The attachment type (audio, image, text, video)")
  public TypeEnum getType() {
    return type;
  }

  public void setType(TypeEnum type) {
    this.type = type;
  }

  public AttachmentsCollection header(HeaderEnum header) {
    this.header = header;
    return this;
  }

   /**
   * The attachment header (audio/3gpp, image/jpeg, text/plain, video/mp4)
   * @return header
  **/
  @ApiModelProperty(value = "The attachment header (audio/3gpp, image/jpeg, text/plain, video/mp4)")
  public HeaderEnum getHeader() {
    return header;
  }

  public void setHeader(HeaderEnum header) {
    this.header = header;
  }

  public AttachmentsCollection uploaded(AttachmentsCollectionUploaded uploaded) {
    this.uploaded = uploaded;
    return this;
  }

   /**
   * Get uploaded
   * @return uploaded
  **/
  @ApiModelProperty(value = "")
  public AttachmentsCollectionUploaded getUploaded() {
    return uploaded;
  }

  public void setUploaded(AttachmentsCollectionUploaded uploaded) {
    this.uploaded = uploaded;
  }

  public AttachmentsCollection caption(String caption) {
    this.caption = caption;
    return this;
  }

   /**
   * Attachment caption
   * @return caption
  **/
  @ApiModelProperty(value = "Attachment caption")
  public String getCaption() {
    return caption;
  }

  public void setCaption(String caption) {
    this.caption = caption;
  }

  public AttachmentsCollection description(String description) {
    this.description = description;
    return this;
  }

   /**
   * Attachment description
   * @return description
  **/
  @ApiModelProperty(value = "Attachment description")
  public String getDescription() {
    return description;
  }

  public void setDescription(String description) {
    this.description = description;
  }

  public AttachmentsCollection cameraPosition(AttachmentsCollectionCameraPosition cameraPosition) {
    this.cameraPosition = cameraPosition;
    return this;
  }

   /**
   * Get cameraPosition
   * @return cameraPosition
  **/
  @ApiModelProperty(value = "")
  public AttachmentsCollectionCameraPosition getCameraPosition() {
    return cameraPosition;
  }

  public void setCameraPosition(AttachmentsCollectionCameraPosition cameraPosition) {
    this.cameraPosition = cameraPosition;
  }


  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    AttachmentsCollection attachmentsCollection = (AttachmentsCollection) o;
    return Objects.equals(this.attachmentId, attachmentsCollection.attachmentId) &&
        Objects.equals(this.type, attachmentsCollection.type) &&
        Objects.equals(this.header, attachmentsCollection.header) &&
        Objects.equals(this.uploaded, attachmentsCollection.uploaded) &&
        Objects.equals(this.caption, attachmentsCollection.caption) &&
        Objects.equals(this.description, attachmentsCollection.description) &&
        Objects.equals(this.cameraPosition, attachmentsCollection.cameraPosition);
  }

  @Override
  public int hashCode() {
    return Objects.hash(attachmentId, type, header, uploaded, caption, description, cameraPosition);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class AttachmentsCollection {\n");

    sb.append("    attachmentId: ").append(toIndentedString(attachmentId)).append("\n");
    sb.append("    type: ").append(toIndentedString(type)).append("\n");
    sb.append("    header: ").append(toIndentedString(header)).append("\n");
    sb.append("    uploaded: ").append(toIndentedString(uploaded)).append("\n");
    sb.append("    caption: ").append(toIndentedString(caption)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    cameraPosition: ").append(toIndentedString(cameraPosition)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
  
}

