/*
 * 1map API
 * 1map API Documentation (<b>Premium</b> and <b>Enterprise</b> Users).  # How it works:  First you will login to the API with the <b><i>API's Login Service</i></b>.  After a successful call to the <b><i>API's Login Service</i></b> you will receive a Token. This Token is needed for all secure calls to the 1map server (To all API calls where there is a lock icon next to it). A Token is only valid per session. The Session and your Token will expire after 2 hours of inactivity or the moment you do a call to the <b><i>API's Logout Service</i></b>.  Please note that all date/time fields are returned in SAST (South Africa Standard Time) time zone and in the <a href=\"https://en.wikipedia.org/wiki/ISO_8601\" target=\"_blank\">ISO 8601</a> format (YYYY-MM-DD[T]HH:mm:ss.SSS[Z]).  Please feel free to contact us at [Support](mailto:support@1map.co.za), should you require any additional API Services not listed below.  See a full working Javascript example and download source code [here](../api/jsmap)  --- 
 *
 * OpenAPI spec version: 1.0.0
 * Contact: support@1map.co.za
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package io.swagger.client.model;

import java.util.Objects;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.client.model.Billing;
import io.swagger.client.model.Contact;
import io.swagger.client.model.Licenses;
import java.io.IOException;

/**
 * Info regarding the selected account
 */
@ApiModel(description = "Info regarding the selected account")

public class Account {
  @SerializedName("accountId")
  private Long accountId = null;

  @SerializedName("accountName")
  private String accountName = null;

  @SerializedName("description")
  private String description = null;

  @SerializedName("postalAddress")
  private String postalAddress = null;

  @SerializedName("vatNumber")
  private String vatNumber = null;

  @SerializedName("contact")
  private Contact contact = null;

  @SerializedName("billing")
  private Billing billing = null;

  @SerializedName("licenses")
  private Licenses licenses = null;

  public Account accountId(Long accountId) {
    this.accountId = accountId;
    return this;
  }

   /**
   * Account&#39;s unique 1map id number - Primary Key
   * @return accountId
  **/
  @ApiModelProperty(value = "Account's unique 1map id number - Primary Key")
  public Long getAccountId() {
    return accountId;
  }

  public void setAccountId(Long accountId) {
    this.accountId = accountId;
  }

  public Account accountName(String accountName) {
    this.accountName = accountName;
    return this;
  }

   /**
   * Account Caption/Name
   * @return accountName
  **/
  @ApiModelProperty(value = "Account Caption/Name")
  public String getAccountName() {
    return accountName;
  }

  public void setAccountName(String accountName) {
    this.accountName = accountName;
  }

  public Account description(String description) {
    this.description = description;
    return this;
  }

   /**
   * Account Description
   * @return description
  **/
  @ApiModelProperty(value = "Account Description")
  public String getDescription() {
    return description;
  }

  public void setDescription(String description) {
    this.description = description;
  }

  public Account postalAddress(String postalAddress) {
    this.postalAddress = postalAddress;
    return this;
  }

   /**
   * Account&#39;s postal address
   * @return postalAddress
  **/
  @ApiModelProperty(value = "Account's postal address")
  public String getPostalAddress() {
    return postalAddress;
  }

  public void setPostalAddress(String postalAddress) {
    this.postalAddress = postalAddress;
  }

  public Account vatNumber(String vatNumber) {
    this.vatNumber = vatNumber;
    return this;
  }

   /**
   * Account&#39;s registered VAT Number - If available
   * @return vatNumber
  **/
  @ApiModelProperty(value = "Account's registered VAT Number - If available")
  public String getVatNumber() {
    return vatNumber;
  }

  public void setVatNumber(String vatNumber) {
    this.vatNumber = vatNumber;
  }

  public Account contact(Contact contact) {
    this.contact = contact;
    return this;
  }

   /**
   * Get contact
   * @return contact
  **/
  @ApiModelProperty(value = "")
  public Contact getContact() {
    return contact;
  }

  public void setContact(Contact contact) {
    this.contact = contact;
  }

  public Account billing(Billing billing) {
    this.billing = billing;
    return this;
  }

   /**
   * Get billing
   * @return billing
  **/
  @ApiModelProperty(value = "")
  public Billing getBilling() {
    return billing;
  }

  public void setBilling(Billing billing) {
    this.billing = billing;
  }

  public Account licenses(Licenses licenses) {
    this.licenses = licenses;
    return this;
  }

   /**
   * Get licenses
   * @return licenses
  **/
  @ApiModelProperty(value = "")
  public Licenses getLicenses() {
    return licenses;
  }

  public void setLicenses(Licenses licenses) {
    this.licenses = licenses;
  }


  @Override
  public boolean equals(java.lang.Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    Account account = (Account) o;
    return Objects.equals(this.accountId, account.accountId) &&
        Objects.equals(this.accountName, account.accountName) &&
        Objects.equals(this.description, account.description) &&
        Objects.equals(this.postalAddress, account.postalAddress) &&
        Objects.equals(this.vatNumber, account.vatNumber) &&
        Objects.equals(this.contact, account.contact) &&
        Objects.equals(this.billing, account.billing) &&
        Objects.equals(this.licenses, account.licenses);
  }

  @Override
  public int hashCode() {
    return Objects.hash(accountId, accountName, description, postalAddress, vatNumber, contact, billing, licenses);
  }


  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class Account {\n");
    
    sb.append("    accountId: ").append(toIndentedString(accountId)).append("\n");
    sb.append("    accountName: ").append(toIndentedString(accountName)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    postalAddress: ").append(toIndentedString(postalAddress)).append("\n");
    sb.append("    vatNumber: ").append(toIndentedString(vatNumber)).append("\n");
    sb.append("    contact: ").append(toIndentedString(contact)).append("\n");
    sb.append("    billing: ").append(toIndentedString(billing)).append("\n");
    sb.append("    licenses: ").append(toIndentedString(licenses)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(java.lang.Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }
  
}

