/*
 * 1map API
 * 1map API Documentation (<b>Premium</b> and <b>Enterprise</b> Users).  # How it works:  First you will login to the API with the <b><i>API's Login Service</i></b>.  After a successful call to the <b><i>API's Login Service</i></b> you will receive a Token. This Token is needed for all secure calls to the 1map server (To all API calls where there is a lock icon next to it). A Token is only valid per session. The Session and your Token will expire after 2 hours of inactivity or the moment you do a call to the <b><i>API's Logout Service</i></b>.  Please note that all date/time fields are returned in SAST (South Africa Standard Time) time zone and in the <a href=\"https://en.wikipedia.org/wiki/ISO_8601\" target=\"_blank\">ISO 8601</a> format (YYYY-MM-DD[T]HH:mm:ss.SSS[Z]).  Please feel free to contact us at [Support](mailto:support@1map.co.za), should you require any additional API Services not listed below.  See a full working Javascript example and download source code [here](../api/jsmap)  --- 
 *
 * OpenAPI spec version: 1.0.0
 * Contact: support@1map.co.za
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package io.swagger.client.api;

import io.swagger.client.ApiCallback;
import io.swagger.client.ApiClient;
import io.swagger.client.ApiException;
import io.swagger.client.ApiResponse;
import io.swagger.client.Configuration;
import io.swagger.client.Pair;
import io.swagger.client.ProgressRequestBody;
import io.swagger.client.ProgressResponseBody;

import com.github.filosganga.geogson.model.Feature;
import com.google.gson.reflect.TypeToken;

import java.io.IOException;


import io.swagger.client.model.FeatureWithoutPropertiesAndAttachments;
import java.io.File;
import io.swagger.client.model.OKResponseAttachmentsUpdate;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SpatialApi {
    private ApiClient apiClient;

    public SpatialApi() {
        this(Configuration.getDefaultApiClient());
    }

    public SpatialApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Build call for apiSpatialAddGeometry
     * @param layerId The Layer Id to get map tile from (required)
     * @param newFeature The feature to update with the primary id in GeoJSON format (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call apiSpatialAddGeometryCall(Long layerId, FeatureWithoutPropertiesAndAttachments newFeature, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = newFeature;
        
        // create path and map variables
        String localVarPath = "/spatial/geometry/{layerId}"
            .replaceAll("\\{" + "layerId" + "\\}", apiClient.escapeString(layerId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "token" };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }
    
    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call apiSpatialAddGeometryValidateBeforeCall(Long layerId, FeatureWithoutPropertiesAndAttachments newFeature, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'layerId' is set
        if (layerId == null) {
            throw new ApiException("Missing the required parameter 'layerId' when calling apiSpatialAddGeometry(Async)");
        }
        
        // verify the required parameter 'newFeature' is set
        if (newFeature == null) {
            throw new ApiException("Missing the required parameter 'newFeature' when calling apiSpatialAddGeometry(Async)");
        }
        
        
        com.squareup.okhttp.Call call = apiSpatialAddGeometryCall(layerId, newFeature, progressListener, progressRequestListener);
        return call;

        
        
        
        
    }

    /**
     * Add New Spatial Geometry
     * This API call will add a new Spatial Geometry to a given layer.  You must have spatial edit permissions on the layer to add the new geometry.
     * @param layerId The Layer Id to get map tile from (required)
     * @param newFeature The feature to update with the primary id in GeoJSON format (required)
     * @return OKResponseAttachmentsUpdate
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public OKResponseAttachmentsUpdate apiSpatialAddGeometry(Long layerId, FeatureWithoutPropertiesAndAttachments newFeature) throws ApiException {
        ApiResponse<OKResponseAttachmentsUpdate> resp = apiSpatialAddGeometryWithHttpInfo(layerId, newFeature);
        return resp.getData();
    }

    /**
     * Add New Spatial Geometry
     * This API call will add a new Spatial Geometry to a given layer.  You must have spatial edit permissions on the layer to add the new geometry.
     * @param layerId The Layer Id to get map tile from (required)
     * @param newFeature The feature to update with the primary id in GeoJSON format (required)
     * @return ApiResponse&lt;OKResponseAttachmentsUpdate&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<OKResponseAttachmentsUpdate> apiSpatialAddGeometryWithHttpInfo(Long layerId, FeatureWithoutPropertiesAndAttachments newFeature) throws ApiException {
        com.squareup.okhttp.Call call = apiSpatialAddGeometryValidateBeforeCall(layerId, newFeature, null, null);
        Type localVarReturnType = new TypeToken<OKResponseAttachmentsUpdate>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Add New Spatial Geometry (asynchronously)
     * This API call will add a new Spatial Geometry to a given layer.  You must have spatial edit permissions on the layer to add the new geometry.
     * @param layerId The Layer Id to get map tile from (required)
     * @param newFeature The feature to update with the primary id in GeoJSON format (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call apiSpatialAddGeometryAsync(Long layerId, FeatureWithoutPropertiesAndAttachments newFeature, final ApiCallback<OKResponseAttachmentsUpdate> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = apiSpatialAddGeometryValidateBeforeCall(layerId, newFeature, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<OKResponseAttachmentsUpdate>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for apiSpatialMaptileBaseOrOther
     * @param layerId The Layer Id to get map tile from (required)
     * @param from Whether to get tile from Base Layer (base) or not (other). (required)
     * @param BBOX BBOX (required)
     * @param CRS CRS - Projection.  If ommited then default &#39;EPSG:3857&#39; will be used.  Currently only &#39;EPSG:4326&#39; and &#39;EPSG:3857&#39; are supported. (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call apiSpatialMaptileBaseOrOtherCall(Long layerId, String from, String BBOX, String CRS, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        
        // create path and map variables
        String localVarPath = "/spatial/maptile/{layerId}/{from}"
            .replaceAll("\\{" + "layerId" + "\\}", apiClient.escapeString(layerId.toString()))
            .replaceAll("\\{" + "from" + "\\}", apiClient.escapeString(from.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (BBOX != null)
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "BBOX", BBOX));
        if (CRS != null)
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "CRS", CRS));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "image/jpeg", "image/png", "image/png; mode=8bit"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "token" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }
    
    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call apiSpatialMaptileBaseOrOtherValidateBeforeCall(Long layerId, String from, String BBOX, String CRS, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'layerId' is set
        if (layerId == null) {
            throw new ApiException("Missing the required parameter 'layerId' when calling apiSpatialMaptileBaseOrOther(Async)");
        }
        
        // verify the required parameter 'from' is set
        if (from == null) {
            throw new ApiException("Missing the required parameter 'from' when calling apiSpatialMaptileBaseOrOther(Async)");
        }
        
        // verify the required parameter 'BBOX' is set
        if (BBOX == null) {
            throw new ApiException("Missing the required parameter 'BBOX' when calling apiSpatialMaptileBaseOrOther(Async)");
        }
        
        
        com.squareup.okhttp.Call call = apiSpatialMaptileBaseOrOtherCall(layerId, from, BBOX, CRS, progressListener, progressRequestListener);
        return call;

        
        
        
        
    }

    /**
     * WMS Map tile service
     * This API call will get a map tile (256x256) from a given layer.  To be used in client components like Openlayers, Leaflet, etc. Currently WMS 1.3.0 are supported.
     * @param layerId The Layer Id to get map tile from (required)
     * @param from Whether to get tile from Base Layer (base) or not (other). (required)
     * @param BBOX BBOX (required)
     * @param CRS CRS - Projection.  If ommited then default &#39;EPSG:3857&#39; will be used.  Currently only &#39;EPSG:4326&#39; and &#39;EPSG:3857&#39; are supported. (optional)
     * @return File
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public File apiSpatialMaptileBaseOrOther(Long layerId, String from, String BBOX, String CRS) throws ApiException {
        ApiResponse<File> resp = apiSpatialMaptileBaseOrOtherWithHttpInfo(layerId, from, BBOX, CRS);
        return resp.getData();
    }

    /**
     * WMS Map tile service
     * This API call will get a map tile (256x256) from a given layer.  To be used in client components like Openlayers, Leaflet, etc. Currently WMS 1.3.0 are supported.
     * @param layerId The Layer Id to get map tile from (required)
     * @param from Whether to get tile from Base Layer (base) or not (other). (required)
     * @param BBOX BBOX (required)
     * @param CRS CRS - Projection.  If ommited then default &#39;EPSG:3857&#39; will be used.  Currently only &#39;EPSG:4326&#39; and &#39;EPSG:3857&#39; are supported. (optional)
     * @return ApiResponse&lt;File&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<File> apiSpatialMaptileBaseOrOtherWithHttpInfo(Long layerId, String from, String BBOX, String CRS) throws ApiException {
        com.squareup.okhttp.Call call = apiSpatialMaptileBaseOrOtherValidateBeforeCall(layerId, from, BBOX, CRS, null, null);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * WMS Map tile service (asynchronously)
     * This API call will get a map tile (256x256) from a given layer.  To be used in client components like Openlayers, Leaflet, etc. Currently WMS 1.3.0 are supported.
     * @param layerId The Layer Id to get map tile from (required)
     * @param from Whether to get tile from Base Layer (base) or not (other). (required)
     * @param BBOX BBOX (required)
     * @param CRS CRS - Projection.  If ommited then default &#39;EPSG:3857&#39; will be used.  Currently only &#39;EPSG:4326&#39; and &#39;EPSG:3857&#39; are supported. (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call apiSpatialMaptileBaseOrOtherAsync(Long layerId, String from, String BBOX, String CRS, final ApiCallback<File> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = apiSpatialMaptileBaseOrOtherValidateBeforeCall(layerId, from, BBOX, CRS, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for apiSpatialMaptileOther
     * @param layerId The Layer Id to get map tile from (required)
     * @param BBOX BBOX (required)
     * @param CRS CRS - Projection.  If ommited then default &#39;EPSG:3857&#39; will be used.  Currently only &#39;EPSG:4326&#39; and &#39;EPSG:3857&#39; are supported. (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call apiSpatialMaptileOtherCall(Long layerId, String BBOX, String CRS, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        
        // create path and map variables
        String localVarPath = "/spatial/maptile/{layerId}"
            .replaceAll("\\{" + "layerId" + "\\}", apiClient.escapeString(layerId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (BBOX != null)
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "BBOX", BBOX));
        if (CRS != null)
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "CRS", CRS));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "image/jpeg", "image/png", "image/png; mode=8bit"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "token" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }
    
    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call apiSpatialMaptileOtherValidateBeforeCall(Long layerId, String BBOX, String CRS, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'layerId' is set
        if (layerId == null) {
            throw new ApiException("Missing the required parameter 'layerId' when calling apiSpatialMaptileOther(Async)");
        }
        
        // verify the required parameter 'BBOX' is set
        if (BBOX == null) {
            throw new ApiException("Missing the required parameter 'BBOX' when calling apiSpatialMaptileOther(Async)");
        }
        
        
        com.squareup.okhttp.Call call = apiSpatialMaptileOtherCall(layerId, BBOX, CRS, progressListener, progressRequestListener);
        return call;

        
        
        
        
    }

    /**
     * WMS Map tile service
     * This API call will get a map tile (256x256) from a given layer.  To be used in client components like Openlayers, Leaflet, etc. Currently WMS 1.3.0 are supported.  This call does not return base layers.
     * @param layerId The Layer Id to get map tile from (required)
     * @param BBOX BBOX (required)
     * @param CRS CRS - Projection.  If ommited then default &#39;EPSG:3857&#39; will be used.  Currently only &#39;EPSG:4326&#39; and &#39;EPSG:3857&#39; are supported. (optional)
     * @return File
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public File apiSpatialMaptileOther(Long layerId, String BBOX, String CRS) throws ApiException {
        ApiResponse<File> resp = apiSpatialMaptileOtherWithHttpInfo(layerId, BBOX, CRS);
        return resp.getData();
    }

    /**
     * WMS Map tile service
     * This API call will get a map tile (256x256) from a given layer.  To be used in client components like Openlayers, Leaflet, etc. Currently WMS 1.3.0 are supported.  This call does not return base layers.
     * @param layerId The Layer Id to get map tile from (required)
     * @param BBOX BBOX (required)
     * @param CRS CRS - Projection.  If ommited then default &#39;EPSG:3857&#39; will be used.  Currently only &#39;EPSG:4326&#39; and &#39;EPSG:3857&#39; are supported. (optional)
     * @return ApiResponse&lt;File&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<File> apiSpatialMaptileOtherWithHttpInfo(Long layerId, String BBOX, String CRS) throws ApiException {
        com.squareup.okhttp.Call call = apiSpatialMaptileOtherValidateBeforeCall(layerId, BBOX, CRS, null, null);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * WMS Map tile service (asynchronously)
     * This API call will get a map tile (256x256) from a given layer.  To be used in client components like Openlayers, Leaflet, etc. Currently WMS 1.3.0 are supported.  This call does not return base layers.
     * @param layerId The Layer Id to get map tile from (required)
     * @param BBOX BBOX (required)
     * @param CRS CRS - Projection.  If ommited then default &#39;EPSG:3857&#39; will be used.  Currently only &#39;EPSG:4326&#39; and &#39;EPSG:3857&#39; are supported. (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call apiSpatialMaptileOtherAsync(Long layerId, String BBOX, String CRS, final ApiCallback<File> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = apiSpatialMaptileOtherValidateBeforeCall(layerId, BBOX, CRS, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for apiSpatialUpdateGeometry
     * @param layerId The Layer Id from the Layer to update (required)
     * @param primaryId The Primary Id from the Feature to update (required)
     * @param updatedFeature The feature to update with the primary id in GeoJSON format (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call apiSpatialUpdateGeometryCall(Long layerId, Long primaryId, Feature updatedFeature, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = updatedFeature;
        
        // create path and map variables
        String localVarPath = "/spatial/geometry/{layerId}/{primaryId}"
            .replaceAll("\\{" + "layerId" + "\\}", apiClient.escapeString(layerId.toString()))
            .replaceAll("\\{" + "primaryId" + "\\}", apiClient.escapeString(primaryId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "token" };
        return apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }
    
    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call apiSpatialUpdateGeometryValidateBeforeCall(Long layerId, Long primaryId, Feature updatedFeature, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'layerId' is set
        if (layerId == null) {
            throw new ApiException("Missing the required parameter 'layerId' when calling apiSpatialUpdateGeometry(Async)");
        }
        
        // verify the required parameter 'primaryId' is set
        if (primaryId == null) {
            throw new ApiException("Missing the required parameter 'primaryId' when calling apiSpatialUpdateGeometry(Async)");
        }
        
        // verify the required parameter 'updatedFeature' is set
        if (updatedFeature == null) {
            throw new ApiException("Missing the required parameter 'updatedFeature' when calling apiSpatialUpdateGeometry(Async)");
        }
        
        
        com.squareup.okhttp.Call call = apiSpatialUpdateGeometryCall(layerId, primaryId, updatedFeature, progressListener, progressRequestListener);
        return call;

        
        
        
        
    }

    /**
     * Modify Spatial Geometry
     * This API call will update a Spatial Geometry from a given layer.  You must have spatial edit permissions on the layer to update the geometry.
     * @param layerId The Layer Id from the Layer to update (required)
     * @param primaryId The Primary Id from the Feature to update (required)
     * @param updatedFeature The feature to update with the primary id in GeoJSON format (required)
     * @return OKResponseAttachmentsUpdate
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public OKResponseAttachmentsUpdate apiSpatialUpdateGeometry(Long layerId, Long primaryId, Feature updatedFeature) throws ApiException {
        ApiResponse<OKResponseAttachmentsUpdate> resp = apiSpatialUpdateGeometryWithHttpInfo(layerId, primaryId, updatedFeature);
        return resp.getData();
    }

    /**
     * Modify Spatial Geometry
     * This API call will update a Spatial Geometry from a given layer.  You must have spatial edit permissions on the layer to update the geometry.
     * @param layerId The Layer Id from the Layer to update (required)
     * @param primaryId The Primary Id from the Feature to update (required)
     * @param updatedFeature The feature to update with the primary id in GeoJSON format (required)
     * @return ApiResponse&lt;OKResponseAttachmentsUpdate&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<OKResponseAttachmentsUpdate> apiSpatialUpdateGeometryWithHttpInfo(Long layerId, Long primaryId, Feature updatedFeature) throws ApiException {
        com.squareup.okhttp.Call call = apiSpatialUpdateGeometryValidateBeforeCall(layerId, primaryId, updatedFeature, null, null);
        Type localVarReturnType = new TypeToken<OKResponseAttachmentsUpdate>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Modify Spatial Geometry (asynchronously)
     * This API call will update a Spatial Geometry from a given layer.  You must have spatial edit permissions on the layer to update the geometry.
     * @param layerId The Layer Id from the Layer to update (required)
     * @param primaryId The Primary Id from the Feature to update (required)
     * @param updatedFeature The feature to update with the primary id in GeoJSON format (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call apiSpatialUpdateGeometryAsync(Long layerId, Long primaryId, Feature updatedFeature, final ApiCallback<OKResponseAttachmentsUpdate> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = apiSpatialUpdateGeometryValidateBeforeCall(layerId, primaryId, updatedFeature, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<OKResponseAttachmentsUpdate>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}
