/*
 * 1map API
 * 1map API Documentation (<b>Premium</b> and <b>Enterprise</b> Users).  # How it works:  First you will login to the API with the <b><i>API's Login Service</i></b>.  After a successful call to the <b><i>API's Login Service</i></b> you will receive a Token. This Token is needed for all secure calls to the 1map server (To all API calls where there is a lock icon next to it). A Token is only valid per session. The Session and your Token will expire after 2 hours of inactivity or the moment you do a call to the <b><i>API's Logout Service</i></b>.  Please note that all date/time fields are returned in SAST (South Africa Standard Time) time zone and in the <a href=\"https://en.wikipedia.org/wiki/ISO_8601\" target=\"_blank\">ISO 8601</a> format (YYYY-MM-DD[T]HH:mm:ss.SSS[Z]).  Please feel free to contact us at [Support](mailto:support@1map.co.za), should you require any additional API Services not listed below.  See a full working Javascript example and download source code [here](../api/jsmap)  --- 
 *
 * OpenAPI spec version: 1.0.0
 * Contact: support@1map.co.za
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package io.swagger.client.api;

import io.swagger.client.ApiCallback;
import io.swagger.client.ApiClient;
import io.swagger.client.ApiException;
import io.swagger.client.ApiResponse;
import io.swagger.client.Configuration;
import io.swagger.client.Pair;
import io.swagger.client.ProgressRequestBody;
import io.swagger.client.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;


import io.swagger.client.model.OKResponseParamsLayer;
import io.swagger.client.model.OKResponseParamsLayer1;
import io.swagger.client.model.OKResponseParamsLayerEditTemplateFields;
import io.swagger.client.model.OKResponseParamsLayerEditTemplates;
import io.swagger.client.model.OKResponseParamsLayerFields;
import io.swagger.client.model.OKResponseParamsLayerIndexes;
import io.swagger.client.model.OKResponseParamsWorkspace;
import io.swagger.client.model.OKResponseParamsWorkspace1;
import io.swagger.client.model.OKResponseParamsWorkspaceLayers;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ParametersApi {
    private ApiClient apiClient;

    public ParametersApi() {
        this(Configuration.getDefaultApiClient());
    }

    public ParametersApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Build call for layerAll
     * @param isBaseLayer Whether layer is from Base Layers (true) or not (false).  This is optional.  If ommited, or false passed, then get all layers from normal 1map layers. (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call layerAllCall(String isBaseLayer, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        
        // create path and map variables
        String localVarPath = "/params/layer";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (isBaseLayer != null)
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "isBaseLayer", isBaseLayer));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "token" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }
    
    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call layerAllValidateBeforeCall(String isBaseLayer, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        
        com.squareup.okhttp.Call call = layerAllCall(isBaseLayer, progressListener, progressRequestListener);
        return call;

        
        
        
        
    }

    /**
     * Get all available layers for the logged in user
     * Return a list of all available layers for the logged in user.
     * @param isBaseLayer Whether layer is from Base Layers (true) or not (false).  This is optional.  If ommited, or false passed, then get all layers from normal 1map layers. (optional)
     * @return OKResponseParamsLayer
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public OKResponseParamsLayer layerAll(String isBaseLayer) throws ApiException {
        ApiResponse<OKResponseParamsLayer> resp = layerAllWithHttpInfo(isBaseLayer);
        return resp.getData();
    }

    /**
     * Get all available layers for the logged in user
     * Return a list of all available layers for the logged in user.
     * @param isBaseLayer Whether layer is from Base Layers (true) or not (false).  This is optional.  If ommited, or false passed, then get all layers from normal 1map layers. (optional)
     * @return ApiResponse&lt;OKResponseParamsLayer&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<OKResponseParamsLayer> layerAllWithHttpInfo(String isBaseLayer) throws ApiException {
        com.squareup.okhttp.Call call = layerAllValidateBeforeCall(isBaseLayer, null, null);
        Type localVarReturnType = new TypeToken<OKResponseParamsLayer>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get all available layers for the logged in user (asynchronously)
     * Return a list of all available layers for the logged in user.
     * @param isBaseLayer Whether layer is from Base Layers (true) or not (false).  This is optional.  If ommited, or false passed, then get all layers from normal 1map layers. (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call layerAllAsync(String isBaseLayer, final ApiCallback<OKResponseParamsLayer> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = layerAllValidateBeforeCall(isBaseLayer, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<OKResponseParamsLayer>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for layerEditTemplateFields
     * @param editTemplateId The edit template id for the edit template the edit template fields belongs to. (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call layerEditTemplateFieldsCall(Long editTemplateId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        
        // create path and map variables
        String localVarPath = "/params/layer/edittemplate/{editTemplateId}/editfields"
            .replaceAll("\\{" + "editTemplateId" + "\\}", apiClient.escapeString(editTemplateId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "token" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }
    
    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call layerEditTemplateFieldsValidateBeforeCall(Long editTemplateId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'editTemplateId' is set
        if (editTemplateId == null) {
            throw new ApiException("Missing the required parameter 'editTemplateId' when calling layerEditTemplateFields(Async)");
        }
        
        
        com.squareup.okhttp.Call call = layerEditTemplateFieldsCall(editTemplateId, progressListener, progressRequestListener);
        return call;

        
        
        
        
    }

    /**
     * Get all available edit template fields for a specified edit template
     * Return a single edit template field or a list of all available edit template fields for a specified edit template.  Parameter (editTemplateFieldId) is only required if you want to return a single edit template field.
     * @param editTemplateId The edit template id for the edit template the edit template fields belongs to. (required)
     * @return OKResponseParamsLayerEditTemplateFields
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public OKResponseParamsLayerEditTemplateFields layerEditTemplateFields(Long editTemplateId) throws ApiException {
        ApiResponse<OKResponseParamsLayerEditTemplateFields> resp = layerEditTemplateFieldsWithHttpInfo(editTemplateId);
        return resp.getData();
    }

    /**
     * Get all available edit template fields for a specified edit template
     * Return a single edit template field or a list of all available edit template fields for a specified edit template.  Parameter (editTemplateFieldId) is only required if you want to return a single edit template field.
     * @param editTemplateId The edit template id for the edit template the edit template fields belongs to. (required)
     * @return ApiResponse&lt;OKResponseParamsLayerEditTemplateFields&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<OKResponseParamsLayerEditTemplateFields> layerEditTemplateFieldsWithHttpInfo(Long editTemplateId) throws ApiException {
        com.squareup.okhttp.Call call = layerEditTemplateFieldsValidateBeforeCall(editTemplateId, null, null);
        Type localVarReturnType = new TypeToken<OKResponseParamsLayerEditTemplateFields>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get all available edit template fields for a specified edit template (asynchronously)
     * Return a single edit template field or a list of all available edit template fields for a specified edit template.  Parameter (editTemplateFieldId) is only required if you want to return a single edit template field.
     * @param editTemplateId The edit template id for the edit template the edit template fields belongs to. (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call layerEditTemplateFieldsAsync(Long editTemplateId, final ApiCallback<OKResponseParamsLayerEditTemplateFields> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = layerEditTemplateFieldsValidateBeforeCall(editTemplateId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<OKResponseParamsLayerEditTemplateFields>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for layerEditTemplates
     * @param layerId The layer id for the layer the edit templates belong to. (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call layerEditTemplatesCall(Long layerId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        
        // create path and map variables
        String localVarPath = "/params/layer/{layerId}/edittemplates"
            .replaceAll("\\{" + "layerId" + "\\}", apiClient.escapeString(layerId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "token" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }
    
    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call layerEditTemplatesValidateBeforeCall(Long layerId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'layerId' is set
        if (layerId == null) {
            throw new ApiException("Missing the required parameter 'layerId' when calling layerEditTemplates(Async)");
        }
        
        
        com.squareup.okhttp.Call call = layerEditTemplatesCall(layerId, progressListener, progressRequestListener);
        return call;

        
        
        
        
    }

    /**
     * Get all available edit templates for a specified layer
     * Return a single edit template or a list of all available edit templates for a specified layer.  Parameter (editTemplateId) is only required if you want to return a single edit template.
     * @param layerId The layer id for the layer the edit templates belong to. (required)
     * @return OKResponseParamsLayerEditTemplates
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public OKResponseParamsLayerEditTemplates layerEditTemplates(Long layerId) throws ApiException {
        ApiResponse<OKResponseParamsLayerEditTemplates> resp = layerEditTemplatesWithHttpInfo(layerId);
        return resp.getData();
    }

    /**
     * Get all available edit templates for a specified layer
     * Return a single edit template or a list of all available edit templates for a specified layer.  Parameter (editTemplateId) is only required if you want to return a single edit template.
     * @param layerId The layer id for the layer the edit templates belong to. (required)
     * @return ApiResponse&lt;OKResponseParamsLayerEditTemplates&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<OKResponseParamsLayerEditTemplates> layerEditTemplatesWithHttpInfo(Long layerId) throws ApiException {
        com.squareup.okhttp.Call call = layerEditTemplatesValidateBeforeCall(layerId, null, null);
        Type localVarReturnType = new TypeToken<OKResponseParamsLayerEditTemplates>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get all available edit templates for a specified layer (asynchronously)
     * Return a single edit template or a list of all available edit templates for a specified layer.  Parameter (editTemplateId) is only required if you want to return a single edit template.
     * @param layerId The layer id for the layer the edit templates belong to. (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call layerEditTemplatesAsync(Long layerId, final ApiCallback<OKResponseParamsLayerEditTemplates> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = layerEditTemplatesValidateBeforeCall(layerId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<OKResponseParamsLayerEditTemplates>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for layerFields
     * @param layerId The layer id for the layer the fields belong to. (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call layerFieldsCall(Long layerId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        
        // create path and map variables
        String localVarPath = "/params/layer/{layerId}/fields"
            .replaceAll("\\{" + "layerId" + "\\}", apiClient.escapeString(layerId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "token" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }
    
    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call layerFieldsValidateBeforeCall(Long layerId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'layerId' is set
        if (layerId == null) {
            throw new ApiException("Missing the required parameter 'layerId' when calling layerFields(Async)");
        }
        
        
        com.squareup.okhttp.Call call = layerFieldsCall(layerId, progressListener, progressRequestListener);
        return call;

        
        
        
        
    }

    /**
     * Get all available fields for a specified layer
     * Return a single field or a list of all available fields for a specified layer.  Parameter (fieldId) is only required if you want to return a single field.
     * @param layerId The layer id for the layer the fields belong to. (required)
     * @return OKResponseParamsLayerFields
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public OKResponseParamsLayerFields layerFields(Long layerId) throws ApiException {
        ApiResponse<OKResponseParamsLayerFields> resp = layerFieldsWithHttpInfo(layerId);
        return resp.getData();
    }

    /**
     * Get all available fields for a specified layer
     * Return a single field or a list of all available fields for a specified layer.  Parameter (fieldId) is only required if you want to return a single field.
     * @param layerId The layer id for the layer the fields belong to. (required)
     * @return ApiResponse&lt;OKResponseParamsLayerFields&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<OKResponseParamsLayerFields> layerFieldsWithHttpInfo(Long layerId) throws ApiException {
        com.squareup.okhttp.Call call = layerFieldsValidateBeforeCall(layerId, null, null);
        Type localVarReturnType = new TypeToken<OKResponseParamsLayerFields>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get all available fields for a specified layer (asynchronously)
     * Return a single field or a list of all available fields for a specified layer.  Parameter (fieldId) is only required if you want to return a single field.
     * @param layerId The layer id for the layer the fields belong to. (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call layerFieldsAsync(Long layerId, final ApiCallback<OKResponseParamsLayerFields> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = layerFieldsValidateBeforeCall(layerId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<OKResponseParamsLayerFields>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for layerIndexes
     * @param layerId The layer id for the layer the sort order indexes belong to. (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call layerIndexesCall(Long layerId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        
        // create path and map variables
        String localVarPath = "/params/layer/{layerId}/indexes"
            .replaceAll("\\{" + "layerId" + "\\}", apiClient.escapeString(layerId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "token" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }
    
    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call layerIndexesValidateBeforeCall(Long layerId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'layerId' is set
        if (layerId == null) {
            throw new ApiException("Missing the required parameter 'layerId' when calling layerIndexes(Async)");
        }
        
        
        com.squareup.okhttp.Call call = layerIndexesCall(layerId, progressListener, progressRequestListener);
        return call;

        
        
        
        
    }

    /**
     * Get all available sort order indexes for a specified layer
     * Return a single sort order index or a list of all available sort order indexes for a specified layer.  Parameter (indexId) is only required if you want to return a single sort order index.
     * @param layerId The layer id for the layer the sort order indexes belong to. (required)
     * @return OKResponseParamsLayerIndexes
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public OKResponseParamsLayerIndexes layerIndexes(Long layerId) throws ApiException {
        ApiResponse<OKResponseParamsLayerIndexes> resp = layerIndexesWithHttpInfo(layerId);
        return resp.getData();
    }

    /**
     * Get all available sort order indexes for a specified layer
     * Return a single sort order index or a list of all available sort order indexes for a specified layer.  Parameter (indexId) is only required if you want to return a single sort order index.
     * @param layerId The layer id for the layer the sort order indexes belong to. (required)
     * @return ApiResponse&lt;OKResponseParamsLayerIndexes&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<OKResponseParamsLayerIndexes> layerIndexesWithHttpInfo(Long layerId) throws ApiException {
        com.squareup.okhttp.Call call = layerIndexesValidateBeforeCall(layerId, null, null);
        Type localVarReturnType = new TypeToken<OKResponseParamsLayerIndexes>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get all available sort order indexes for a specified layer (asynchronously)
     * Return a single sort order index or a list of all available sort order indexes for a specified layer.  Parameter (indexId) is only required if you want to return a single sort order index.
     * @param layerId The layer id for the layer the sort order indexes belong to. (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call layerIndexesAsync(Long layerId, final ApiCallback<OKResponseParamsLayerIndexes> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = layerIndexesValidateBeforeCall(layerId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<OKResponseParamsLayerIndexes>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for layerSingle
     * @param layerId The layer id to get. (required)
     * @param isBaseLayer Whether layer is from Base Layers (true) or not (false). (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call layerSingleCall(Long layerId, String isBaseLayer, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        
        // create path and map variables
        String localVarPath = "/params/layer/{layerId}"
            .replaceAll("\\{" + "layerId" + "\\}", apiClient.escapeString(layerId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (isBaseLayer != null)
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "isBaseLayer", isBaseLayer));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "token" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }
    
    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call layerSingleValidateBeforeCall(Long layerId, String isBaseLayer, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'layerId' is set
        if (layerId == null) {
            throw new ApiException("Missing the required parameter 'layerId' when calling layerSingle(Async)");
        }
        
        // verify the required parameter 'isBaseLayer' is set
        if (isBaseLayer == null) {
            throw new ApiException("Missing the required parameter 'isBaseLayer' when calling layerSingle(Async)");
        }
        
        
        com.squareup.okhttp.Call call = layerSingleCall(layerId, isBaseLayer, progressListener, progressRequestListener);
        return call;

        
        
        
        
    }

    /**
     * Get an individual layer or all available layers for the logged in user
     * Return a single layer or a list of all available layers for the logged in user.  Parameter (layerId) is only required if you want to return a single layer.
     * @param layerId The layer id to get. (required)
     * @param isBaseLayer Whether layer is from Base Layers (true) or not (false). (required)
     * @return OKResponseParamsLayer1
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public OKResponseParamsLayer1 layerSingle(Long layerId, String isBaseLayer) throws ApiException {
        ApiResponse<OKResponseParamsLayer1> resp = layerSingleWithHttpInfo(layerId, isBaseLayer);
        return resp.getData();
    }

    /**
     * Get an individual layer or all available layers for the logged in user
     * Return a single layer or a list of all available layers for the logged in user.  Parameter (layerId) is only required if you want to return a single layer.
     * @param layerId The layer id to get. (required)
     * @param isBaseLayer Whether layer is from Base Layers (true) or not (false). (required)
     * @return ApiResponse&lt;OKResponseParamsLayer1&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<OKResponseParamsLayer1> layerSingleWithHttpInfo(Long layerId, String isBaseLayer) throws ApiException {
        com.squareup.okhttp.Call call = layerSingleValidateBeforeCall(layerId, isBaseLayer, null, null);
        Type localVarReturnType = new TypeToken<OKResponseParamsLayer1>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get an individual layer or all available layers for the logged in user (asynchronously)
     * Return a single layer or a list of all available layers for the logged in user.  Parameter (layerId) is only required if you want to return a single layer.
     * @param layerId The layer id to get. (required)
     * @param isBaseLayer Whether layer is from Base Layers (true) or not (false). (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call layerSingleAsync(Long layerId, String isBaseLayer, final ApiCallback<OKResponseParamsLayer1> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = layerSingleValidateBeforeCall(layerId, isBaseLayer, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<OKResponseParamsLayer1>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for workspaceAll
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call workspaceAllCall(final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        
        // create path and map variables
        String localVarPath = "/params/workspace";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "token" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }
    
    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call workspaceAllValidateBeforeCall(final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        
        com.squareup.okhttp.Call call = workspaceAllCall(progressListener, progressRequestListener);
        return call;

        
        
        
        
    }

    /**
     * Get all available workspaces for the logged in user
     * Return a list of all available workspaces for the logged in user.
     * @return OKResponseParamsWorkspace
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public OKResponseParamsWorkspace workspaceAll() throws ApiException {
        ApiResponse<OKResponseParamsWorkspace> resp = workspaceAllWithHttpInfo();
        return resp.getData();
    }

    /**
     * Get all available workspaces for the logged in user
     * Return a list of all available workspaces for the logged in user.
     * @return ApiResponse&lt;OKResponseParamsWorkspace&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<OKResponseParamsWorkspace> workspaceAllWithHttpInfo() throws ApiException {
        com.squareup.okhttp.Call call = workspaceAllValidateBeforeCall(null, null);
        Type localVarReturnType = new TypeToken<OKResponseParamsWorkspace>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get all available workspaces for the logged in user (asynchronously)
     * Return a list of all available workspaces for the logged in user.
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call workspaceAllAsync(final ApiCallback<OKResponseParamsWorkspace> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = workspaceAllValidateBeforeCall(progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<OKResponseParamsWorkspace>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for workspaceLayers
     * @param workspaceId The workspace id for the workspace the layers belong to. (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call workspaceLayersCall(Long workspaceId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        
        // create path and map variables
        String localVarPath = "/params/workspace/{workspaceId}/layers"
            .replaceAll("\\{" + "workspaceId" + "\\}", apiClient.escapeString(workspaceId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "token" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }
    
    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call workspaceLayersValidateBeforeCall(Long workspaceId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'workspaceId' is set
        if (workspaceId == null) {
            throw new ApiException("Missing the required parameter 'workspaceId' when calling workspaceLayers(Async)");
        }
        
        
        com.squareup.okhttp.Call call = workspaceLayersCall(workspaceId, progressListener, progressRequestListener);
        return call;

        
        
        
        
    }

    /**
     * Get all available layers for a specified workspace
     * Return a list of all available layers for a specified workspace.
     * @param workspaceId The workspace id for the workspace the layers belong to. (required)
     * @return OKResponseParamsWorkspaceLayers
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public OKResponseParamsWorkspaceLayers workspaceLayers(Long workspaceId) throws ApiException {
        ApiResponse<OKResponseParamsWorkspaceLayers> resp = workspaceLayersWithHttpInfo(workspaceId);
        return resp.getData();
    }

    /**
     * Get all available layers for a specified workspace
     * Return a list of all available layers for a specified workspace.
     * @param workspaceId The workspace id for the workspace the layers belong to. (required)
     * @return ApiResponse&lt;OKResponseParamsWorkspaceLayers&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<OKResponseParamsWorkspaceLayers> workspaceLayersWithHttpInfo(Long workspaceId) throws ApiException {
        com.squareup.okhttp.Call call = workspaceLayersValidateBeforeCall(workspaceId, null, null);
        Type localVarReturnType = new TypeToken<OKResponseParamsWorkspaceLayers>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get all available layers for a specified workspace (asynchronously)
     * Return a list of all available layers for a specified workspace.
     * @param workspaceId The workspace id for the workspace the layers belong to. (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call workspaceLayersAsync(Long workspaceId, final ApiCallback<OKResponseParamsWorkspaceLayers> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = workspaceLayersValidateBeforeCall(workspaceId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<OKResponseParamsWorkspaceLayers>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for workspaceSingle
     * @param workspaceId The workspace id for the workspace to return. (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call workspaceSingleCall(Long workspaceId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        
        // create path and map variables
        String localVarPath = "/params/workspace/{workspaceId}"
            .replaceAll("\\{" + "workspaceId" + "\\}", apiClient.escapeString(workspaceId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "token" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }
    
    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call workspaceSingleValidateBeforeCall(Long workspaceId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'workspaceId' is set
        if (workspaceId == null) {
            throw new ApiException("Missing the required parameter 'workspaceId' when calling workspaceSingle(Async)");
        }
        
        
        com.squareup.okhttp.Call call = workspaceSingleCall(workspaceId, progressListener, progressRequestListener);
        return call;

        
        
        
        
    }

    /**
     * Get an individual workspace for the logged in user
     * Return a single workspace for the logged in user.  Parameter (workspaceId) is here required if you want to return a single workspace.
     * @param workspaceId The workspace id for the workspace to return. (required)
     * @return OKResponseParamsWorkspace1
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public OKResponseParamsWorkspace1 workspaceSingle(Long workspaceId) throws ApiException {
        ApiResponse<OKResponseParamsWorkspace1> resp = workspaceSingleWithHttpInfo(workspaceId);
        return resp.getData();
    }

    /**
     * Get an individual workspace for the logged in user
     * Return a single workspace for the logged in user.  Parameter (workspaceId) is here required if you want to return a single workspace.
     * @param workspaceId The workspace id for the workspace to return. (required)
     * @return ApiResponse&lt;OKResponseParamsWorkspace1&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<OKResponseParamsWorkspace1> workspaceSingleWithHttpInfo(Long workspaceId) throws ApiException {
        com.squareup.okhttp.Call call = workspaceSingleValidateBeforeCall(workspaceId, null, null);
        Type localVarReturnType = new TypeToken<OKResponseParamsWorkspace1>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get an individual workspace for the logged in user (asynchronously)
     * Return a single workspace for the logged in user.  Parameter (workspaceId) is here required if you want to return a single workspace.
     * @param workspaceId The workspace id for the workspace to return. (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call workspaceSingleAsync(Long workspaceId, final ApiCallback<OKResponseParamsWorkspace1> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = workspaceSingleValidateBeforeCall(workspaceId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<OKResponseParamsWorkspace1>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}
