/*
 * 1map API
 * 1map API Documentation (<b>Premium</b> and <b>Enterprise</b> Users).  # How it works:  First you will login to the API with the <b><i>API's Login Service</i></b>.  After a successful call to the <b><i>API's Login Service</i></b> you will receive a Token. This Token is needed for all secure calls to the 1map server (To all API calls where there is a lock icon next to it). A Token is only valid per session. The Session and your Token will expire after 2 hours of inactivity or the moment you do a call to the <b><i>API's Logout Service</i></b>.  Please note that all date/time fields are returned in SAST (South Africa Standard Time) time zone and in the <a href=\"https://en.wikipedia.org/wiki/ISO_8601\" target=\"_blank\">ISO 8601</a> format (YYYY-MM-DD[T]HH:mm:ss.SSS[Z]).  Please feel free to contact us at [Support](mailto:support@1map.co.za), should you require any additional API Services not listed below.  See a full working Javascript example and download source code [here](../api/jsmap)  --- 
 *
 * OpenAPI spec version: 1.0.0
 * Contact: support@1map.co.za
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package io.swagger.client.api;

import io.swagger.client.ApiCallback;
import io.swagger.client.ApiClient;
import io.swagger.client.ApiException;
import io.swagger.client.ApiResponse;
import io.swagger.client.Configuration;
import io.swagger.client.Pair;
import io.swagger.client.ProgressRequestBody;
import io.swagger.client.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;


import io.swagger.client.model.Geometry2;
import io.swagger.client.model.OKResponseLandParcelsContains;
import io.swagger.client.model.OKResponseLandParcelsIntersect;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class LandParcelsApi {
    private ApiClient apiClient;

    public LandParcelsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public LandParcelsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Build call for landParcelsContainsSearch
     * @param longitude The longitude (WGS84) for the coordinate to search (required)
     * @param latitude The latitude (WGS84) for the coordinate to search (required)
     * @param start Start record index if using paging (Optional, 1-based, 1 &#x3D; First Record).  If ommited then 1 will be used. (optional)
     * @param limit Limit result if using paging (Optional, 0 to 1000).  If ommited then default of 1000 will be used. (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call landParcelsContainsSearchCall(Double longitude, Double latitude, Long start, Long limit, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        
        // create path and map variables
        String localVarPath = "/landparcels/contains";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (longitude != null)
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "longitude", longitude));
        if (latitude != null)
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "latitude", latitude));
        if (start != null)
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "start", start));
        if (limit != null)
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "limit", limit));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "token" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }
    
    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call landParcelsContainsSearchValidateBeforeCall(Double longitude, Double latitude, Long start, Long limit, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'longitude' is set
        if (longitude == null) {
            throw new ApiException("Missing the required parameter 'longitude' when calling landParcelsContainsSearch(Async)");
        }
        
        // verify the required parameter 'latitude' is set
        if (latitude == null) {
            throw new ApiException("Missing the required parameter 'latitude' when calling landParcelsContainsSearch(Async)");
        }
        
        
        com.squareup.okhttp.Call call = landParcelsContainsSearchCall(longitude, latitude, start, limit, progressListener, progressRequestListener);
        return call;

        
        
        
        
    }

    /**
     * Get all land parcels containing point
     * This api call searches for all the land parcels that contains the given coordinate (WGS84 Lon/Lat).
     * @param longitude The longitude (WGS84) for the coordinate to search (required)
     * @param latitude The latitude (WGS84) for the coordinate to search (required)
     * @param start Start record index if using paging (Optional, 1-based, 1 &#x3D; First Record).  If ommited then 1 will be used. (optional)
     * @param limit Limit result if using paging (Optional, 0 to 1000).  If ommited then default of 1000 will be used. (optional)
     * @return OKResponseLandParcelsContains
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public OKResponseLandParcelsContains landParcelsContainsSearch(Double longitude, Double latitude, Long start, Long limit) throws ApiException {
        ApiResponse<OKResponseLandParcelsContains> resp = landParcelsContainsSearchWithHttpInfo(longitude, latitude, start, limit);
        return resp.getData();
    }

    /**
     * Get all land parcels containing point
     * This api call searches for all the land parcels that contains the given coordinate (WGS84 Lon/Lat).
     * @param longitude The longitude (WGS84) for the coordinate to search (required)
     * @param latitude The latitude (WGS84) for the coordinate to search (required)
     * @param start Start record index if using paging (Optional, 1-based, 1 &#x3D; First Record).  If ommited then 1 will be used. (optional)
     * @param limit Limit result if using paging (Optional, 0 to 1000).  If ommited then default of 1000 will be used. (optional)
     * @return ApiResponse&lt;OKResponseLandParcelsContains&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<OKResponseLandParcelsContains> landParcelsContainsSearchWithHttpInfo(Double longitude, Double latitude, Long start, Long limit) throws ApiException {
        com.squareup.okhttp.Call call = landParcelsContainsSearchValidateBeforeCall(longitude, latitude, start, limit, null, null);
        Type localVarReturnType = new TypeToken<OKResponseLandParcelsContains>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get all land parcels containing point (asynchronously)
     * This api call searches for all the land parcels that contains the given coordinate (WGS84 Lon/Lat).
     * @param longitude The longitude (WGS84) for the coordinate to search (required)
     * @param latitude The latitude (WGS84) for the coordinate to search (required)
     * @param start Start record index if using paging (Optional, 1-based, 1 &#x3D; First Record).  If ommited then 1 will be used. (optional)
     * @param limit Limit result if using paging (Optional, 0 to 1000).  If ommited then default of 1000 will be used. (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call landParcelsContainsSearchAsync(Double longitude, Double latitude, Long start, Long limit, final ApiCallback<OKResponseLandParcelsContains> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = landParcelsContainsSearchValidateBeforeCall(longitude, latitude, start, limit, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<OKResponseLandParcelsContains>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for landParcelsSearchIntersect
     * @param geometry The Geometry (Geojson Object) to search within (required)
     * @param start Start record index if using paging (Optional, 1-based, 1 &#x3D; First Record).  If ommited then 1 will be used. (optional)
     * @param limit Limit result if using paging (Optional, 0 to 1000).  If ommited then default of 1000 will be used. (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call landParcelsSearchIntersectCall(Geometry2 geometry, Long start, Long limit, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = geometry;
        
        // create path and map variables
        String localVarPath = "/landparcels/intersect";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (start != null)
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "start", start));
        if (limit != null)
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "limit", limit));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "token" };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }
    
    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call landParcelsSearchIntersectValidateBeforeCall(Geometry2 geometry, Long start, Long limit, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'geometry' is set
        if (geometry == null) {
            throw new ApiException("Missing the required parameter 'geometry' when calling landParcelsSearchIntersect(Async)");
        }
        
        
        com.squareup.okhttp.Call call = landParcelsSearchIntersectCall(geometry, start, limit, progressListener, progressRequestListener);
        return call;

        
        
        
        
    }

    /**
     * Get land parcels intersecting an area (polygon)
     * This api call searches for all land parcels that intersects a given area (polygon).
     * @param geometry The Geometry (Geojson Object) to search within (required)
     * @param start Start record index if using paging (Optional, 1-based, 1 &#x3D; First Record).  If ommited then 1 will be used. (optional)
     * @param limit Limit result if using paging (Optional, 0 to 1000).  If ommited then default of 1000 will be used. (optional)
     * @return OKResponseLandParcelsIntersect
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public OKResponseLandParcelsIntersect landParcelsSearchIntersect(Geometry2 geometry, Long start, Long limit) throws ApiException {
        ApiResponse<OKResponseLandParcelsIntersect> resp = landParcelsSearchIntersectWithHttpInfo(geometry, start, limit);
        return resp.getData();
    }

    /**
     * Get land parcels intersecting an area (polygon)
     * This api call searches for all land parcels that intersects a given area (polygon).
     * @param geometry The Geometry (Geojson Object) to search within (required)
     * @param start Start record index if using paging (Optional, 1-based, 1 &#x3D; First Record).  If ommited then 1 will be used. (optional)
     * @param limit Limit result if using paging (Optional, 0 to 1000).  If ommited then default of 1000 will be used. (optional)
     * @return ApiResponse&lt;OKResponseLandParcelsIntersect&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<OKResponseLandParcelsIntersect> landParcelsSearchIntersectWithHttpInfo(Geometry2 geometry, Long start, Long limit) throws ApiException {
        com.squareup.okhttp.Call call = landParcelsSearchIntersectValidateBeforeCall(geometry, start, limit, null, null);
        Type localVarReturnType = new TypeToken<OKResponseLandParcelsIntersect>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get land parcels intersecting an area (polygon) (asynchronously)
     * This api call searches for all land parcels that intersects a given area (polygon).
     * @param geometry The Geometry (Geojson Object) to search within (required)
     * @param start Start record index if using paging (Optional, 1-based, 1 &#x3D; First Record).  If ommited then 1 will be used. (optional)
     * @param limit Limit result if using paging (Optional, 0 to 1000).  If ommited then default of 1000 will be used. (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call landParcelsSearchIntersectAsync(Geometry2 geometry, Long start, Long limit, final ApiCallback<OKResponseLandParcelsIntersect> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = landParcelsSearchIntersectValidateBeforeCall(geometry, start, limit, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<OKResponseLandParcelsIntersect>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}
