/*
 * 1map API
 * 1map API Documentation (<b>Premium</b> and <b>Enterprise</b> Users).  # How it works:  First you will login to the API with the <b><i>API's Login Service</i></b>.  After a successful call to the <b><i>API's Login Service</i></b> you will receive a Token. This Token is needed for all secure calls to the 1map server (To all API calls where there is a lock icon next to it). A Token is only valid per session. The Session and your Token will expire after 2 hours of inactivity or the moment you do a call to the <b><i>API's Logout Service</i></b>.  Please note that all date/time fields are returned in SAST (South Africa Standard Time) time zone and in the <a href=\"https://en.wikipedia.org/wiki/ISO_8601\" target=\"_blank\">ISO 8601</a> format (YYYY-MM-DD[T]HH:mm:ss.SSS[Z]).  Please feel free to contact us at [Support](mailto:support@1map.co.za), should you require any additional API Services not listed below.  See a full working Javascript example and download source code [here](../api/jsmap)  --- 
 *
 * OpenAPI spec version: 1.0.0
 * Contact: support@1map.co.za
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package io.swagger.client.api;

import io.swagger.client.ApiCallback;
import io.swagger.client.ApiClient;
import io.swagger.client.ApiException;
import io.swagger.client.ApiResponse;
import io.swagger.client.Configuration;
import io.swagger.client.Pair;
import io.swagger.client.ProgressRequestBody;
import io.swagger.client.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;


import io.swagger.client.model.FeatureBasic;
import io.swagger.client.model.OKResponseAttributes;
import io.swagger.client.model.OKResponseAttributesAdd;
import io.swagger.client.model.OKResponseAttributesDelete;
import io.swagger.client.model.OKResponseAttributesUpdate;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AttributesBasicApi {
    private ApiClient apiClient;

    public AttributesBasicApi() {
        this(Configuration.getDefaultApiClient());
    }

    public AttributesBasicApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Build call for attributesPrimaryIdAdd
     * @param layerId The Layer Id to add new record to (required)
     * @param feature Valid GeoJSON object that needs to be added (See example).  Please note: If geometry part is omitted, then only the properties will be added. (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call attributesPrimaryIdAddCall(Long layerId, FeatureBasic feature, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = feature;
        
        // create path and map variables
        String localVarPath = "/attributes/{layerId}"
            .replaceAll("\\{" + "layerId" + "\\}", apiClient.escapeString(layerId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "token" };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }
    
    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call attributesPrimaryIdAddValidateBeforeCall(Long layerId, FeatureBasic feature, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'layerId' is set
        if (layerId == null) {
            throw new ApiException("Missing the required parameter 'layerId' when calling attributesPrimaryIdAdd(Async)");
        }
        
        // verify the required parameter 'feature' is set
        if (feature == null) {
            throw new ApiException("Missing the required parameter 'feature' when calling attributesPrimaryIdAdd(Async)");
        }
        
        
        com.squareup.okhttp.Call call = attributesPrimaryIdAddCall(layerId, feature, progressListener, progressRequestListener);
        return call;

        
        
        
        
    }

    /**
     * Add a new layer record
     * This api call adds a new record in a given layer (layerid) and returns the new primaryId. See Also: /spatial/geometry/{layerId} to just add the geometry part without properties.
     * @param layerId The Layer Id to add new record to (required)
     * @param feature Valid GeoJSON object that needs to be added (See example).  Please note: If geometry part is omitted, then only the properties will be added. (required)
     * @return OKResponseAttributesAdd
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public OKResponseAttributesAdd attributesPrimaryIdAdd(Long layerId, FeatureBasic feature) throws ApiException {
        ApiResponse<OKResponseAttributesAdd> resp = attributesPrimaryIdAddWithHttpInfo(layerId, feature);
        return resp.getData();
    }

    /**
     * Add a new layer record
     * This api call adds a new record in a given layer (layerid) and returns the new primaryId. See Also: /spatial/geometry/{layerId} to just add the geometry part without properties.
     * @param layerId The Layer Id to add new record to (required)
     * @param feature Valid GeoJSON object that needs to be added (See example).  Please note: If geometry part is omitted, then only the properties will be added. (required)
     * @return ApiResponse&lt;OKResponseAttributesAdd&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<OKResponseAttributesAdd> attributesPrimaryIdAddWithHttpInfo(Long layerId, FeatureBasic feature) throws ApiException {
        com.squareup.okhttp.Call call = attributesPrimaryIdAddValidateBeforeCall(layerId, feature, null, null);
        Type localVarReturnType = new TypeToken<OKResponseAttributesAdd>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Add a new layer record (asynchronously)
     * This api call adds a new record in a given layer (layerid) and returns the new primaryId. See Also: /spatial/geometry/{layerId} to just add the geometry part without properties.
     * @param layerId The Layer Id to add new record to (required)
     * @param feature Valid GeoJSON object that needs to be added (See example).  Please note: If geometry part is omitted, then only the properties will be added. (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call attributesPrimaryIdAddAsync(Long layerId, FeatureBasic feature, final ApiCallback<OKResponseAttributesAdd> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = attributesPrimaryIdAddValidateBeforeCall(layerId, feature, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<OKResponseAttributesAdd>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for attributesPrimaryIdDelete
     * @param layerId The Layer&#39;s Id for the record to be deleted (required)
     * @param primaryId The Layer&#39;s Primary Id for the record to be deleted (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call attributesPrimaryIdDeleteCall(Long layerId, Long primaryId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        
        // create path and map variables
        String localVarPath = "/attributes/{layerId}/{primaryId}"
            .replaceAll("\\{" + "layerId" + "\\}", apiClient.escapeString(layerId.toString()))
            .replaceAll("\\{" + "primaryId" + "\\}", apiClient.escapeString(primaryId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "token" };
        return apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }
    
    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call attributesPrimaryIdDeleteValidateBeforeCall(Long layerId, Long primaryId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'layerId' is set
        if (layerId == null) {
            throw new ApiException("Missing the required parameter 'layerId' when calling attributesPrimaryIdDelete(Async)");
        }
        
        // verify the required parameter 'primaryId' is set
        if (primaryId == null) {
            throw new ApiException("Missing the required parameter 'primaryId' when calling attributesPrimaryIdDelete(Async)");
        }
        
        
        com.squareup.okhttp.Call call = attributesPrimaryIdDeleteCall(layerId, primaryId, progressListener, progressRequestListener);
        return call;

        
        
        
        
    }

    /**
     * Delete an existing layer record
     * This api call deletes an existing record in a given layer (layerid).
     * @param layerId The Layer&#39;s Id for the record to be deleted (required)
     * @param primaryId The Layer&#39;s Primary Id for the record to be deleted (required)
     * @return OKResponseAttributesDelete
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public OKResponseAttributesDelete attributesPrimaryIdDelete(Long layerId, Long primaryId) throws ApiException {
        ApiResponse<OKResponseAttributesDelete> resp = attributesPrimaryIdDeleteWithHttpInfo(layerId, primaryId);
        return resp.getData();
    }

    /**
     * Delete an existing layer record
     * This api call deletes an existing record in a given layer (layerid).
     * @param layerId The Layer&#39;s Id for the record to be deleted (required)
     * @param primaryId The Layer&#39;s Primary Id for the record to be deleted (required)
     * @return ApiResponse&lt;OKResponseAttributesDelete&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<OKResponseAttributesDelete> attributesPrimaryIdDeleteWithHttpInfo(Long layerId, Long primaryId) throws ApiException {
        com.squareup.okhttp.Call call = attributesPrimaryIdDeleteValidateBeforeCall(layerId, primaryId, null, null);
        Type localVarReturnType = new TypeToken<OKResponseAttributesDelete>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Delete an existing layer record (asynchronously)
     * This api call deletes an existing record in a given layer (layerid).
     * @param layerId The Layer&#39;s Id for the record to be deleted (required)
     * @param primaryId The Layer&#39;s Primary Id for the record to be deleted (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call attributesPrimaryIdDeleteAsync(Long layerId, Long primaryId, final ApiCallback<OKResponseAttributesDelete> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = attributesPrimaryIdDeleteValidateBeforeCall(layerId, primaryId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<OKResponseAttributesDelete>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for attributesPrimaryIdEdit
     * @param layerId The Layer&#39;s Id for the record to be modified (required)
     * @param primaryId The Layer&#39;s Primary Id for the record to be modified (required)
     * @param feature Valid GeoJSON object that needs to be modified (See example).  Please note: If geometry part is omitted, then only the properties will be updated. (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call attributesPrimaryIdEditCall(Long layerId, Long primaryId, FeatureBasic feature, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = feature;
        
        // create path and map variables
        String localVarPath = "/attributes/{layerId}/{primaryId}"
            .replaceAll("\\{" + "layerId" + "\\}", apiClient.escapeString(layerId.toString()))
            .replaceAll("\\{" + "primaryId" + "\\}", apiClient.escapeString(primaryId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "token" };
        return apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }
    
    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call attributesPrimaryIdEditValidateBeforeCall(Long layerId, Long primaryId, FeatureBasic feature, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'layerId' is set
        if (layerId == null) {
            throw new ApiException("Missing the required parameter 'layerId' when calling attributesPrimaryIdEdit(Async)");
        }
        
        // verify the required parameter 'primaryId' is set
        if (primaryId == null) {
            throw new ApiException("Missing the required parameter 'primaryId' when calling attributesPrimaryIdEdit(Async)");
        }
        
        // verify the required parameter 'feature' is set
        if (feature == null) {
            throw new ApiException("Missing the required parameter 'feature' when calling attributesPrimaryIdEdit(Async)");
        }
        
        
        com.squareup.okhttp.Call call = attributesPrimaryIdEditCall(layerId, primaryId, feature, progressListener, progressRequestListener);
        return call;

        
        
        
        
    }

    /**
     * Edit an existing layer record
     * This api call modifies an existing record in a given layer (layerid). See Also: /spatial/geometry/{layerId}/{primaryId} to just modify the geometry part without properties.
     * @param layerId The Layer&#39;s Id for the record to be modified (required)
     * @param primaryId The Layer&#39;s Primary Id for the record to be modified (required)
     * @param feature Valid GeoJSON object that needs to be modified (See example).  Please note: If geometry part is omitted, then only the properties will be updated. (required)
     * @return OKResponseAttributesUpdate
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public OKResponseAttributesUpdate attributesPrimaryIdEdit(Long layerId, Long primaryId, FeatureBasic feature) throws ApiException {
        ApiResponse<OKResponseAttributesUpdate> resp = attributesPrimaryIdEditWithHttpInfo(layerId, primaryId, feature);
        return resp.getData();
    }

    /**
     * Edit an existing layer record
     * This api call modifies an existing record in a given layer (layerid). See Also: /spatial/geometry/{layerId}/{primaryId} to just modify the geometry part without properties.
     * @param layerId The Layer&#39;s Id for the record to be modified (required)
     * @param primaryId The Layer&#39;s Primary Id for the record to be modified (required)
     * @param feature Valid GeoJSON object that needs to be modified (See example).  Please note: If geometry part is omitted, then only the properties will be updated. (required)
     * @return ApiResponse&lt;OKResponseAttributesUpdate&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<OKResponseAttributesUpdate> attributesPrimaryIdEditWithHttpInfo(Long layerId, Long primaryId, FeatureBasic feature) throws ApiException {
        com.squareup.okhttp.Call call = attributesPrimaryIdEditValidateBeforeCall(layerId, primaryId, feature, null, null);
        Type localVarReturnType = new TypeToken<OKResponseAttributesUpdate>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Edit an existing layer record (asynchronously)
     * This api call modifies an existing record in a given layer (layerid). See Also: /spatial/geometry/{layerId}/{primaryId} to just modify the geometry part without properties.
     * @param layerId The Layer&#39;s Id for the record to be modified (required)
     * @param primaryId The Layer&#39;s Primary Id for the record to be modified (required)
     * @param feature Valid GeoJSON object that needs to be modified (See example).  Please note: If geometry part is omitted, then only the properties will be updated. (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call attributesPrimaryIdEditAsync(Long layerId, Long primaryId, FeatureBasic feature, final ApiCallback<OKResponseAttributesUpdate> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = attributesPrimaryIdEditValidateBeforeCall(layerId, primaryId, feature, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<OKResponseAttributesUpdate>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for attributesPrimaryIdSearch
     * @param layerId The Layer Id to search within (required)
     * @param primaryId Search by Layer&#39;s Primary Id (required)
     * @param showAttachments Return row attachments with the result.  If ommitted then no. (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call attributesPrimaryIdSearchCall(Long layerId, Long primaryId, String showAttachments, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        
        // create path and map variables
        String localVarPath = "/attributes/{layerId}/{primaryId}"
            .replaceAll("\\{" + "layerId" + "\\}", apiClient.escapeString(layerId.toString()))
            .replaceAll("\\{" + "primaryId" + "\\}", apiClient.escapeString(primaryId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (showAttachments != null)
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "showAttachments", showAttachments));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "token" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }
    
    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call attributesPrimaryIdSearchValidateBeforeCall(Long layerId, Long primaryId, String showAttachments, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'layerId' is set
        if (layerId == null) {
            throw new ApiException("Missing the required parameter 'layerId' when calling attributesPrimaryIdSearch(Async)");
        }
        
        // verify the required parameter 'primaryId' is set
        if (primaryId == null) {
            throw new ApiException("Missing the required parameter 'primaryId' when calling attributesPrimaryIdSearch(Async)");
        }
        
        
        com.squareup.okhttp.Call call = attributesPrimaryIdSearchCall(layerId, primaryId, showAttachments, progressListener, progressRequestListener);
        return call;

        
        
        
        
    }

    /**
     * Get individual layer record
     * This api call searches for a record in a given layer (layerid) and record (primaryId) and return all attributes associated with the record.
     * @param layerId The Layer Id to search within (required)
     * @param primaryId Search by Layer&#39;s Primary Id (required)
     * @param showAttachments Return row attachments with the result.  If ommitted then no. (optional)
     * @return OKResponseAttributes
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public OKResponseAttributes attributesPrimaryIdSearch(Long layerId, Long primaryId, String showAttachments) throws ApiException {
        ApiResponse<OKResponseAttributes> resp = attributesPrimaryIdSearchWithHttpInfo(layerId, primaryId, showAttachments);
        return resp.getData();
    }

    /**
     * Get individual layer record
     * This api call searches for a record in a given layer (layerid) and record (primaryId) and return all attributes associated with the record.
     * @param layerId The Layer Id to search within (required)
     * @param primaryId Search by Layer&#39;s Primary Id (required)
     * @param showAttachments Return row attachments with the result.  If ommitted then no. (optional)
     * @return ApiResponse&lt;OKResponseAttributes&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<OKResponseAttributes> attributesPrimaryIdSearchWithHttpInfo(Long layerId, Long primaryId, String showAttachments) throws ApiException {
        com.squareup.okhttp.Call call = attributesPrimaryIdSearchValidateBeforeCall(layerId, primaryId, showAttachments, null, null);
        Type localVarReturnType = new TypeToken<OKResponseAttributes>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get individual layer record (asynchronously)
     * This api call searches for a record in a given layer (layerid) and record (primaryId) and return all attributes associated with the record.
     * @param layerId The Layer Id to search within (required)
     * @param primaryId Search by Layer&#39;s Primary Id (required)
     * @param showAttachments Return row attachments with the result.  If ommitted then no. (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call attributesPrimaryIdSearchAsync(Long layerId, Long primaryId, String showAttachments, final ApiCallback<OKResponseAttributes> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = attributesPrimaryIdSearchValidateBeforeCall(layerId, primaryId, showAttachments, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<OKResponseAttributes>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for attributesSortedSearchSorted
     * @param layerId The Layer Id to search within (required)
     * @param indexId Return result sorted using indexId. (required)
     * @param filterString Return result using this filterString.  If omitted, then all attributes will be returned. (optional)
     * @param showAttachments Return row attachments with the result.  If ommitted then no. (optional)
     * @param start Start record index if using paging (Optional, 1-based, 1 &#x3D; First Record).  If ommited then 1 will be used. (optional)
     * @param limit Limit result if using paging (Optional, 0 to 25).  If ommited then default of 25 will be used. (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call attributesSortedSearchSortedCall(Long layerId, Long indexId, String filterString, String showAttachments, Long start, Long limit, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        
        // create path and map variables
        String localVarPath = "/attributes/{layerId}/sorted/{indexId}"
            .replaceAll("\\{" + "layerId" + "\\}", apiClient.escapeString(layerId.toString()))
            .replaceAll("\\{" + "indexId" + "\\}", apiClient.escapeString(indexId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (filterString != null)
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "filterString", filterString));
        if (showAttachments != null)
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "showAttachments", showAttachments));
        if (start != null)
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "start", start));
        if (limit != null)
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "limit", limit));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "token" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }
    
    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call attributesSortedSearchSortedValidateBeforeCall(Long layerId, Long indexId, String filterString, String showAttachments, Long start, Long limit, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'layerId' is set
        if (layerId == null) {
            throw new ApiException("Missing the required parameter 'layerId' when calling attributesSortedSearchSorted(Async)");
        }
        
        // verify the required parameter 'indexId' is set
        if (indexId == null) {
            throw new ApiException("Missing the required parameter 'indexId' when calling attributesSortedSearchSorted(Async)");
        }
        
        
        com.squareup.okhttp.Call call = attributesSortedSearchSortedCall(layerId, indexId, filterString, showAttachments, start, limit, progressListener, progressRequestListener);
        return call;

        
        
        
        
    }

    /**
     * Get all layer records sorted
     * This api call get all available records in a given layer (layerid) and return the result sorted (indexId).  It also filters on the optional filterString.
     * @param layerId The Layer Id to search within (required)
     * @param indexId Return result sorted using indexId. (required)
     * @param filterString Return result using this filterString.  If omitted, then all attributes will be returned. (optional)
     * @param showAttachments Return row attachments with the result.  If ommitted then no. (optional)
     * @param start Start record index if using paging (Optional, 1-based, 1 &#x3D; First Record).  If ommited then 1 will be used. (optional)
     * @param limit Limit result if using paging (Optional, 0 to 25).  If ommited then default of 25 will be used. (optional)
     * @return OKResponseAttributes
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public OKResponseAttributes attributesSortedSearchSorted(Long layerId, Long indexId, String filterString, String showAttachments, Long start, Long limit) throws ApiException {
        ApiResponse<OKResponseAttributes> resp = attributesSortedSearchSortedWithHttpInfo(layerId, indexId, filterString, showAttachments, start, limit);
        return resp.getData();
    }

    /**
     * Get all layer records sorted
     * This api call get all available records in a given layer (layerid) and return the result sorted (indexId).  It also filters on the optional filterString.
     * @param layerId The Layer Id to search within (required)
     * @param indexId Return result sorted using indexId. (required)
     * @param filterString Return result using this filterString.  If omitted, then all attributes will be returned. (optional)
     * @param showAttachments Return row attachments with the result.  If ommitted then no. (optional)
     * @param start Start record index if using paging (Optional, 1-based, 1 &#x3D; First Record).  If ommited then 1 will be used. (optional)
     * @param limit Limit result if using paging (Optional, 0 to 25).  If ommited then default of 25 will be used. (optional)
     * @return ApiResponse&lt;OKResponseAttributes&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<OKResponseAttributes> attributesSortedSearchSortedWithHttpInfo(Long layerId, Long indexId, String filterString, String showAttachments, Long start, Long limit) throws ApiException {
        com.squareup.okhttp.Call call = attributesSortedSearchSortedValidateBeforeCall(layerId, indexId, filterString, showAttachments, start, limit, null, null);
        Type localVarReturnType = new TypeToken<OKResponseAttributes>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get all layer records sorted (asynchronously)
     * This api call get all available records in a given layer (layerid) and return the result sorted (indexId).  It also filters on the optional filterString.
     * @param layerId The Layer Id to search within (required)
     * @param indexId Return result sorted using indexId. (required)
     * @param filterString Return result using this filterString.  If omitted, then all attributes will be returned. (optional)
     * @param showAttachments Return row attachments with the result.  If ommitted then no. (optional)
     * @param start Start record index if using paging (Optional, 1-based, 1 &#x3D; First Record).  If ommited then 1 will be used. (optional)
     * @param limit Limit result if using paging (Optional, 0 to 25).  If ommited then default of 25 will be used. (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call attributesSortedSearchSortedAsync(Long layerId, Long indexId, String filterString, String showAttachments, Long start, Long limit, final ApiCallback<OKResponseAttributes> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = attributesSortedSearchSortedValidateBeforeCall(layerId, indexId, filterString, showAttachments, start, limit, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<OKResponseAttributes>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for attributesSortedSearchUnsorted
     * @param layerId The Layer Id to search within (required)
     * @param filterString Return result using this filterString.  If omitted, then all attributes will be returned. (optional)
     * @param showAttachments Return row attachments with the result.  If ommitted then no. (optional)
     * @param start Start record index if using paging (Optional, 1-based, 1 &#x3D; First Record).  If ommited then 1 will be used. (optional)
     * @param limit Limit result if using paging (Optional, 0 to 25).  If ommited then default of 25 will be used. (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call attributesSortedSearchUnsortedCall(Long layerId, String filterString, String showAttachments, Long start, Long limit, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        
        // create path and map variables
        String localVarPath = "/attributes/{layerId}/sorted"
            .replaceAll("\\{" + "layerId" + "\\}", apiClient.escapeString(layerId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (filterString != null)
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "filterString", filterString));
        if (showAttachments != null)
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "showAttachments", showAttachments));
        if (start != null)
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "start", start));
        if (limit != null)
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "limit", limit));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "token" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }
    
    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call attributesSortedSearchUnsortedValidateBeforeCall(Long layerId, String filterString, String showAttachments, Long start, Long limit, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'layerId' is set
        if (layerId == null) {
            throw new ApiException("Missing the required parameter 'layerId' when calling attributesSortedSearchUnsorted(Async)");
        }
        
        
        com.squareup.okhttp.Call call = attributesSortedSearchUnsortedCall(layerId, filterString, showAttachments, start, limit, progressListener, progressRequestListener);
        return call;

        
        
        
        
    }

    /**
     * Get all layer records sorted
     * This api call get all available records in a given layer (layerid) and return the result unsorted.  It also filters on the optional filterString.
     * @param layerId The Layer Id to search within (required)
     * @param filterString Return result using this filterString.  If omitted, then all attributes will be returned. (optional)
     * @param showAttachments Return row attachments with the result.  If ommitted then no. (optional)
     * @param start Start record index if using paging (Optional, 1-based, 1 &#x3D; First Record).  If ommited then 1 will be used. (optional)
     * @param limit Limit result if using paging (Optional, 0 to 25).  If ommited then default of 25 will be used. (optional)
     * @return OKResponseAttributes
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public OKResponseAttributes attributesSortedSearchUnsorted(Long layerId, String filterString, String showAttachments, Long start, Long limit) throws ApiException {
        ApiResponse<OKResponseAttributes> resp = attributesSortedSearchUnsortedWithHttpInfo(layerId, filterString, showAttachments, start, limit);
        return resp.getData();
    }

    /**
     * Get all layer records sorted
     * This api call get all available records in a given layer (layerid) and return the result unsorted.  It also filters on the optional filterString.
     * @param layerId The Layer Id to search within (required)
     * @param filterString Return result using this filterString.  If omitted, then all attributes will be returned. (optional)
     * @param showAttachments Return row attachments with the result.  If ommitted then no. (optional)
     * @param start Start record index if using paging (Optional, 1-based, 1 &#x3D; First Record).  If ommited then 1 will be used. (optional)
     * @param limit Limit result if using paging (Optional, 0 to 25).  If ommited then default of 25 will be used. (optional)
     * @return ApiResponse&lt;OKResponseAttributes&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<OKResponseAttributes> attributesSortedSearchUnsortedWithHttpInfo(Long layerId, String filterString, String showAttachments, Long start, Long limit) throws ApiException {
        com.squareup.okhttp.Call call = attributesSortedSearchUnsortedValidateBeforeCall(layerId, filterString, showAttachments, start, limit, null, null);
        Type localVarReturnType = new TypeToken<OKResponseAttributes>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get all layer records sorted (asynchronously)
     * This api call get all available records in a given layer (layerid) and return the result unsorted.  It also filters on the optional filterString.
     * @param layerId The Layer Id to search within (required)
     * @param filterString Return result using this filterString.  If omitted, then all attributes will be returned. (optional)
     * @param showAttachments Return row attachments with the result.  If ommitted then no. (optional)
     * @param start Start record index if using paging (Optional, 1-based, 1 &#x3D; First Record).  If ommited then 1 will be used. (optional)
     * @param limit Limit result if using paging (Optional, 0 to 25).  If ommited then default of 25 will be used. (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call attributesSortedSearchUnsortedAsync(Long layerId, String filterString, String showAttachments, Long start, Long limit, final ApiCallback<OKResponseAttributes> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = attributesSortedSearchUnsortedValidateBeforeCall(layerId, filterString, showAttachments, start, limit, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<OKResponseAttributes>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}
