/*
 * 1map API
 * 1map API Documentation (<b>Premium</b> and <b>Enterprise</b> Users).  # How it works:  First you will login to the API with the <b><i>API's Login Service</i></b>.  After a successful call to the <b><i>API's Login Service</i></b> you will receive a Token. This Token is needed for all secure calls to the 1map server (To all API calls where there is a lock icon next to it). A Token is only valid per session. The Session and your Token will expire after 2 hours of inactivity or the moment you do a call to the <b><i>API's Logout Service</i></b>.  Please note that all date/time fields are returned in SAST (South Africa Standard Time) time zone and in the <a href=\"https://en.wikipedia.org/wiki/ISO_8601\" target=\"_blank\">ISO 8601</a> format (YYYY-MM-DD[T]HH:mm:ss.SSS[Z]).  Please feel free to contact us at [Support](mailto:support@1map.co.za), should you require any additional API Services not listed below.  See a full working Javascript example and download source code [here](../api/jsmap)  --- 
 *
 * OpenAPI spec version: 1.0.0
 * Contact: support@1map.co.za
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package io.swagger.client.api;

import io.swagger.client.ApiCallback;
import io.swagger.client.ApiClient;
import io.swagger.client.ApiException;
import io.swagger.client.ApiResponse;
import io.swagger.client.Configuration;
import io.swagger.client.Pair;
import io.swagger.client.ProgressRequestBody;
import io.swagger.client.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;


import io.swagger.client.model.Geometry1;
import io.swagger.client.model.OKResponseAttributesClosest;
import io.swagger.client.model.OKResponseAttributesContains;
import io.swagger.client.model.OKResponseAttributesIntersect;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AttributesAdvancedApi {
    private ApiClient apiClient;

    public AttributesAdvancedApi() {
        this(Configuration.getDefaultApiClient());
    }

    public AttributesAdvancedApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Build call for attributesClosestSearch
     * @param layerId The Layer Id to search within (required)
     * @param longitude The longitude (WGS84) for the coordinate to search (required)
     * @param latitude The latitude (WGS84) for the coordinate to search (required)
     * @param showAttachments Return row attachments with the result.  If ommitted then no. (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call attributesClosestSearchCall(Long layerId, Double longitude, Double latitude, String showAttachments, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        
        // create path and map variables
        String localVarPath = "/attributes/closest/{layerId}"
            .replaceAll("\\{" + "layerId" + "\\}", apiClient.escapeString(layerId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (showAttachments != null)
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "showAttachments", showAttachments));
        if (longitude != null)
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "longitude", longitude));
        if (latitude != null)
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "latitude", latitude));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "token" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }
    
    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call attributesClosestSearchValidateBeforeCall(Long layerId, Double longitude, Double latitude, String showAttachments, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'layerId' is set
        if (layerId == null) {
            throw new ApiException("Missing the required parameter 'layerId' when calling attributesClosestSearch(Async)");
        }
        
        // verify the required parameter 'longitude' is set
        if (longitude == null) {
            throw new ApiException("Missing the required parameter 'longitude' when calling attributesClosestSearch(Async)");
        }
        
        // verify the required parameter 'latitude' is set
        if (latitude == null) {
            throw new ApiException("Missing the required parameter 'latitude' when calling attributesClosestSearch(Async)");
        }
        
        
        com.squareup.okhttp.Call call = attributesClosestSearchCall(layerId, longitude, latitude, showAttachments, progressListener, progressRequestListener);
        return call;

        
        
        
        
    }

    /**
     * Get layer record closest to a point
     * This api call searches for the closest record in a given layer (layerid) using the given coordinate (WGS84 Lon/Lat).
     * @param layerId The Layer Id to search within (required)
     * @param longitude The longitude (WGS84) for the coordinate to search (required)
     * @param latitude The latitude (WGS84) for the coordinate to search (required)
     * @param showAttachments Return row attachments with the result.  If ommitted then no. (optional)
     * @return OKResponseAttributesClosest
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public OKResponseAttributesClosest attributesClosestSearch(Long layerId, Double longitude, Double latitude, String showAttachments) throws ApiException {
        ApiResponse<OKResponseAttributesClosest> resp = attributesClosestSearchWithHttpInfo(layerId, longitude, latitude, showAttachments);
        return resp.getData();
    }

    /**
     * Get layer record closest to a point
     * This api call searches for the closest record in a given layer (layerid) using the given coordinate (WGS84 Lon/Lat).
     * @param layerId The Layer Id to search within (required)
     * @param longitude The longitude (WGS84) for the coordinate to search (required)
     * @param latitude The latitude (WGS84) for the coordinate to search (required)
     * @param showAttachments Return row attachments with the result.  If ommitted then no. (optional)
     * @return ApiResponse&lt;OKResponseAttributesClosest&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<OKResponseAttributesClosest> attributesClosestSearchWithHttpInfo(Long layerId, Double longitude, Double latitude, String showAttachments) throws ApiException {
        com.squareup.okhttp.Call call = attributesClosestSearchValidateBeforeCall(layerId, longitude, latitude, showAttachments, null, null);
        Type localVarReturnType = new TypeToken<OKResponseAttributesClosest>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get layer record closest to a point (asynchronously)
     * This api call searches for the closest record in a given layer (layerid) using the given coordinate (WGS84 Lon/Lat).
     * @param layerId The Layer Id to search within (required)
     * @param longitude The longitude (WGS84) for the coordinate to search (required)
     * @param latitude The latitude (WGS84) for the coordinate to search (required)
     * @param showAttachments Return row attachments with the result.  If ommitted then no. (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call attributesClosestSearchAsync(Long layerId, Double longitude, Double latitude, String showAttachments, final ApiCallback<OKResponseAttributesClosest> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = attributesClosestSearchValidateBeforeCall(layerId, longitude, latitude, showAttachments, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<OKResponseAttributesClosest>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for attributesContainsSearch
     * @param layerId The Layer Id to search within (required)
     * @param longitude The longitude (WGS84) for the coordinate to search (required)
     * @param latitude The latitude (WGS84) for the coordinate to search (required)
     * @param showAttachments Return row attachments with the result.  If ommitted then no. (optional)
     * @param start Start record index if using paging (Optional, 1-based, 1 &#x3D; First Record).  If ommited then 1 will be used. (optional)
     * @param limit Limit result if using paging (Optional, 0 to 25).  If ommited then default of 25 will be used. (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call attributesContainsSearchCall(Long layerId, Double longitude, Double latitude, String showAttachments, Long start, Long limit, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        
        // create path and map variables
        String localVarPath = "/attributes/contains/{layerId}"
            .replaceAll("\\{" + "layerId" + "\\}", apiClient.escapeString(layerId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (showAttachments != null)
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "showAttachments", showAttachments));
        if (longitude != null)
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "longitude", longitude));
        if (latitude != null)
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "latitude", latitude));
        if (start != null)
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "start", start));
        if (limit != null)
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "limit", limit));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "token" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }
    
    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call attributesContainsSearchValidateBeforeCall(Long layerId, Double longitude, Double latitude, String showAttachments, Long start, Long limit, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'layerId' is set
        if (layerId == null) {
            throw new ApiException("Missing the required parameter 'layerId' when calling attributesContainsSearch(Async)");
        }
        
        // verify the required parameter 'longitude' is set
        if (longitude == null) {
            throw new ApiException("Missing the required parameter 'longitude' when calling attributesContainsSearch(Async)");
        }
        
        // verify the required parameter 'latitude' is set
        if (latitude == null) {
            throw new ApiException("Missing the required parameter 'latitude' when calling attributesContainsSearch(Async)");
        }
        
        
        com.squareup.okhttp.Call call = attributesContainsSearchCall(layerId, longitude, latitude, showAttachments, start, limit, progressListener, progressRequestListener);
        return call;

        
        
        
        
    }

    /**
     * Get layer record(s) containing point
     * This api call searches for all the records in a given layer (layerid) that contains the given coordinate (WGS84 Lon/Lat).
     * @param layerId The Layer Id to search within (required)
     * @param longitude The longitude (WGS84) for the coordinate to search (required)
     * @param latitude The latitude (WGS84) for the coordinate to search (required)
     * @param showAttachments Return row attachments with the result.  If ommitted then no. (optional)
     * @param start Start record index if using paging (Optional, 1-based, 1 &#x3D; First Record).  If ommited then 1 will be used. (optional)
     * @param limit Limit result if using paging (Optional, 0 to 25).  If ommited then default of 25 will be used. (optional)
     * @return OKResponseAttributesContains
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public OKResponseAttributesContains attributesContainsSearch(Long layerId, Double longitude, Double latitude, String showAttachments, Long start, Long limit) throws ApiException {
        ApiResponse<OKResponseAttributesContains> resp = attributesContainsSearchWithHttpInfo(layerId, longitude, latitude, showAttachments, start, limit);
        return resp.getData();
    }

    /**
     * Get layer record(s) containing point
     * This api call searches for all the records in a given layer (layerid) that contains the given coordinate (WGS84 Lon/Lat).
     * @param layerId The Layer Id to search within (required)
     * @param longitude The longitude (WGS84) for the coordinate to search (required)
     * @param latitude The latitude (WGS84) for the coordinate to search (required)
     * @param showAttachments Return row attachments with the result.  If ommitted then no. (optional)
     * @param start Start record index if using paging (Optional, 1-based, 1 &#x3D; First Record).  If ommited then 1 will be used. (optional)
     * @param limit Limit result if using paging (Optional, 0 to 25).  If ommited then default of 25 will be used. (optional)
     * @return ApiResponse&lt;OKResponseAttributesContains&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<OKResponseAttributesContains> attributesContainsSearchWithHttpInfo(Long layerId, Double longitude, Double latitude, String showAttachments, Long start, Long limit) throws ApiException {
        com.squareup.okhttp.Call call = attributesContainsSearchValidateBeforeCall(layerId, longitude, latitude, showAttachments, start, limit, null, null);
        Type localVarReturnType = new TypeToken<OKResponseAttributesContains>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get layer record(s) containing point (asynchronously)
     * This api call searches for all the records in a given layer (layerid) that contains the given coordinate (WGS84 Lon/Lat).
     * @param layerId The Layer Id to search within (required)
     * @param longitude The longitude (WGS84) for the coordinate to search (required)
     * @param latitude The latitude (WGS84) for the coordinate to search (required)
     * @param showAttachments Return row attachments with the result.  If ommitted then no. (optional)
     * @param start Start record index if using paging (Optional, 1-based, 1 &#x3D; First Record).  If ommited then 1 will be used. (optional)
     * @param limit Limit result if using paging (Optional, 0 to 25).  If ommited then default of 25 will be used. (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call attributesContainsSearchAsync(Long layerId, Double longitude, Double latitude, String showAttachments, Long start, Long limit, final ApiCallback<OKResponseAttributesContains> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = attributesContainsSearchValidateBeforeCall(layerId, longitude, latitude, showAttachments, start, limit, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<OKResponseAttributesContains>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for attributesSearchIntersect
     * @param layerId The Layer Id to search within (required)
     * @param geometry The Geometry (Geojson Object) to search within (required)
     * @param showAttachments Return row attachments with the result.  If ommitted then no. (optional)
     * @param start Start record index if using paging (Optional, 1-based, 1 &#x3D; First Record).  If ommited then 1 will be used. (optional)
     * @param limit Limit result if using paging (Optional, 0 to 25).  If ommited then default of 25 will be used. (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call attributesSearchIntersectCall(Long layerId, Geometry1 geometry, String showAttachments, Long start, Long limit, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = geometry;
        
        // create path and map variables
        String localVarPath = "/attributes/intersect/{layerId}"
            .replaceAll("\\{" + "layerId" + "\\}", apiClient.escapeString(layerId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (showAttachments != null)
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "showAttachments", showAttachments));
        if (start != null)
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "start", start));
        if (limit != null)
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "limit", limit));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "token" };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }
    
    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call attributesSearchIntersectValidateBeforeCall(Long layerId, Geometry1 geometry, String showAttachments, Long start, Long limit, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'layerId' is set
        if (layerId == null) {
            throw new ApiException("Missing the required parameter 'layerId' when calling attributesSearchIntersect(Async)");
        }
        
        // verify the required parameter 'geometry' is set
        if (geometry == null) {
            throw new ApiException("Missing the required parameter 'geometry' when calling attributesSearchIntersect(Async)");
        }
        
        
        com.squareup.okhttp.Call call = attributesSearchIntersectCall(layerId, geometry, showAttachments, start, limit, progressListener, progressRequestListener);
        return call;

        
        
        
        
    }

    /**
     * Get layer record(s) intersecting an area (polygon)
     * This api call searches for all records within a given layer that intersects a given area (polygon).
     * @param layerId The Layer Id to search within (required)
     * @param geometry The Geometry (Geojson Object) to search within (required)
     * @param showAttachments Return row attachments with the result.  If ommitted then no. (optional)
     * @param start Start record index if using paging (Optional, 1-based, 1 &#x3D; First Record).  If ommited then 1 will be used. (optional)
     * @param limit Limit result if using paging (Optional, 0 to 25).  If ommited then default of 25 will be used. (optional)
     * @return OKResponseAttributesIntersect
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public OKResponseAttributesIntersect attributesSearchIntersect(Long layerId, Geometry1 geometry, String showAttachments, Long start, Long limit) throws ApiException {
        ApiResponse<OKResponseAttributesIntersect> resp = attributesSearchIntersectWithHttpInfo(layerId, geometry, showAttachments, start, limit);
        return resp.getData();
    }

    /**
     * Get layer record(s) intersecting an area (polygon)
     * This api call searches for all records within a given layer that intersects a given area (polygon).
     * @param layerId The Layer Id to search within (required)
     * @param geometry The Geometry (Geojson Object) to search within (required)
     * @param showAttachments Return row attachments with the result.  If ommitted then no. (optional)
     * @param start Start record index if using paging (Optional, 1-based, 1 &#x3D; First Record).  If ommited then 1 will be used. (optional)
     * @param limit Limit result if using paging (Optional, 0 to 25).  If ommited then default of 25 will be used. (optional)
     * @return ApiResponse&lt;OKResponseAttributesIntersect&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<OKResponseAttributesIntersect> attributesSearchIntersectWithHttpInfo(Long layerId, Geometry1 geometry, String showAttachments, Long start, Long limit) throws ApiException {
        com.squareup.okhttp.Call call = attributesSearchIntersectValidateBeforeCall(layerId, geometry, showAttachments, start, limit, null, null);
        Type localVarReturnType = new TypeToken<OKResponseAttributesIntersect>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get layer record(s) intersecting an area (polygon) (asynchronously)
     * This api call searches for all records within a given layer that intersects a given area (polygon).
     * @param layerId The Layer Id to search within (required)
     * @param geometry The Geometry (Geojson Object) to search within (required)
     * @param showAttachments Return row attachments with the result.  If ommitted then no. (optional)
     * @param start Start record index if using paging (Optional, 1-based, 1 &#x3D; First Record).  If ommited then 1 will be used. (optional)
     * @param limit Limit result if using paging (Optional, 0 to 25).  If ommited then default of 25 will be used. (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call attributesSearchIntersectAsync(Long layerId, Geometry1 geometry, String showAttachments, Long start, Long limit, final ApiCallback<OKResponseAttributesIntersect> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = attributesSearchIntersectValidateBeforeCall(layerId, geometry, showAttachments, start, limit, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<OKResponseAttributesIntersect>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}
