/*
 * 1map API
 * 1map API Documentation (<b>Premium</b> and <b>Enterprise</b> Users).  # How it works:  First you will login to the API with the <b><i>API's Login Service</i></b>.  After a successful call to the <b><i>API's Login Service</i></b> you will receive a Token. This Token is needed for all secure calls to the 1map server (To all API calls where there is a lock icon next to it). A Token is only valid per session. The Session and your Token will expire after 2 hours of inactivity or the moment you do a call to the <b><i>API's Logout Service</i></b>.  Please note that all date/time fields are returned in SAST (South Africa Standard Time) time zone and in the <a href=\"https://en.wikipedia.org/wiki/ISO_8601\" target=\"_blank\">ISO 8601</a> format (YYYY-MM-DD[T]HH:mm:ss.SSS[Z]).  Please feel free to contact us at [Support](mailto:support@1map.co.za), should you require any additional API Services not listed below.  See a full working Javascript example and download source code [here](../api/jsmap)  --- 
 *
 * OpenAPI spec version: 1.0.0
 * Contact: support@1map.co.za
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package io.swagger.client.api;

import io.swagger.client.ApiCallback;
import io.swagger.client.ApiClient;
import io.swagger.client.ApiException;
import io.swagger.client.ApiResponse;
import io.swagger.client.Configuration;
import io.swagger.client.Pair;
import io.swagger.client.ProgressRequestBody;
import io.swagger.client.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;


import java.io.File;
import io.swagger.client.model.OKResponseAttachments;
import io.swagger.client.model.OKResponseAttachmentsAdd;
import io.swagger.client.model.OKResponseAttachmentsUpdate;
import io.swagger.client.model.OKResponseAttributesDelete;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AttachmentsApi {
    private ApiClient apiClient;

    public AttachmentsApi() {
        this(Configuration.getDefaultApiClient());
    }

    public AttachmentsApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Build call for attributesAttachAdd
     * @param layerId The Layer Id to add a new record to (required)
     * @param primaryId Add new attachment to given Layers&#39;s Primary Id (required)
     * @param newAttachmentInfo Info on the attachment to add (required)
     * @param newAttachmentFile The attachment to add (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call attributesAttachAddCall(Long layerId, Long primaryId, String newAttachmentInfo, File newAttachmentFile, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/attachments/{layerId}/{primaryId}"
                .replaceAll("\\{" + "layerId" + "\\}", apiClient.escapeString(layerId.toString()))
                .replaceAll("\\{" + "primaryId" + "\\}", apiClient.escapeString(primaryId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (newAttachmentInfo != null)
            localVarFormParams.put("newAttachmentInfo", newAttachmentInfo);
        if (newAttachmentFile != null)
            localVarFormParams.put("newAttachmentFile", newAttachmentFile);

        final String[] localVarAccepts = {
                "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                            .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                            .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "token" };

        //FD
        localVarHeaderParams.put("Content-Type", "multipart/form-data");

        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call attributesAttachAddValidateBeforeCall(Long layerId, Long primaryId, String newAttachmentInfo, File newAttachmentFile, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {

        // verify the required parameter 'layerId' is set
        if (layerId == null) {
            throw new ApiException("Missing the required parameter 'layerId' when calling attributesAttachAdd(Async)");
        }

        // verify the required parameter 'primaryId' is set
        if (primaryId == null) {
            throw new ApiException("Missing the required parameter 'primaryId' when calling attributesAttachAdd(Async)");
        }

        // verify the required parameter 'newAttachmentInfo' is set
        if (newAttachmentInfo == null) {
            throw new ApiException("Missing the required parameter 'newAttachmentInfo' when calling attributesAttachAdd(Async)");
        }

        // verify the required parameter 'newAttachmentFile' is set
        if (newAttachmentFile == null) {
            throw new ApiException("Missing the required parameter 'newAttachmentFile' when calling attributesAttachAdd(Async)");
        }


        com.squareup.okhttp.Call call = attributesAttachAddCall(layerId, primaryId, newAttachmentInfo, newAttachmentFile, progressListener, progressRequestListener);
        return call;





    }

    /**
     * Add a new attachment
     * This api call adds a new attachment to a given layer (layerId) and record (primaryId).
     * @param layerId The Layer Id to add a new record to (required)
     * @param primaryId Add new attachment to given Layers&#39;s Primary Id (required)
     * @param newAttachmentInfo Info on the attachment to add (required)
     * @param newAttachmentFile The attachment to add (required)
     * @return OKResponseAttachmentsAdd
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public OKResponseAttachmentsAdd attributesAttachAdd(Long layerId, Long primaryId, String newAttachmentInfo, File newAttachmentFile) throws ApiException {
        ApiResponse<OKResponseAttachmentsAdd> resp = attributesAttachAddWithHttpInfo(layerId, primaryId, newAttachmentInfo, newAttachmentFile);
        return resp.getData();
    }

    /**
     * Add a new attachment
     * This api call adds a new attachment to a given layer (layerId) and record (primaryId).
     * @param layerId The Layer Id to add a new record to (required)
     * @param primaryId Add new attachment to given Layers&#39;s Primary Id (required)
     * @param newAttachmentInfo Info on the attachment to add (required)
     * @param newAttachmentFile The attachment to add (required)
     * @return ApiResponse&lt;OKResponseAttachmentsAdd&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<OKResponseAttachmentsAdd> attributesAttachAddWithHttpInfo(Long layerId, Long primaryId, String newAttachmentInfo, File newAttachmentFile) throws ApiException {
        com.squareup.okhttp.Call call = attributesAttachAddValidateBeforeCall(layerId, primaryId, newAttachmentInfo, newAttachmentFile, null, null);
        Type localVarReturnType = new TypeToken<OKResponseAttachmentsAdd>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Add a new attachment (asynchronously)
     * This api call adds a new attachment to a given layer (layerId) and record (primaryId).
     * @param layerId The Layer Id to add a new record to (required)
     * @param primaryId Add new attachment to given Layers&#39;s Primary Id (required)
     * @param newAttachmentInfo Info on the attachment to add (required)
     * @param newAttachmentFile The attachment to add (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call attributesAttachAddAsync(Long layerId, Long primaryId, String newAttachmentInfo, File newAttachmentFile, final ApiCallback<OKResponseAttachmentsAdd> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = attributesAttachAddValidateBeforeCall(layerId, primaryId, newAttachmentInfo, newAttachmentFile, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<OKResponseAttachmentsAdd>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for attributesAttachFilePrimaryIdSearchSingle
     * @param layerId The Layer Id to search within (required)
     * @param primaryId Search by Layer&#39;s Primary Id (required)
     * @param attachmentId Search by Attachment&#39;s Primary Id (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call attributesAttachFilePrimaryIdSearchSingleCall(Long layerId, Long primaryId, Long attachmentId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/attachments/file/{layerId}/{primaryId}/{attachmentId}"
                .replaceAll("\\{" + "layerId" + "\\}", apiClient.escapeString(layerId.toString()))
                .replaceAll("\\{" + "primaryId" + "\\}", apiClient.escapeString(primaryId.toString()))
                .replaceAll("\\{" + "attachmentId" + "\\}", apiClient.escapeString(attachmentId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
                "file"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                            .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                            .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "token" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call attributesAttachFilePrimaryIdSearchSingleValidateBeforeCall(Long layerId, Long primaryId, Long attachmentId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {

        // verify the required parameter 'layerId' is set
        if (layerId == null) {
            throw new ApiException("Missing the required parameter 'layerId' when calling attributesAttachFilePrimaryIdSearchSingle(Async)");
        }

        // verify the required parameter 'primaryId' is set
        if (primaryId == null) {
            throw new ApiException("Missing the required parameter 'primaryId' when calling attributesAttachFilePrimaryIdSearchSingle(Async)");
        }

        // verify the required parameter 'attachmentId' is set
        if (attachmentId == null) {
            throw new ApiException("Missing the required parameter 'attachmentId' when calling attributesAttachFilePrimaryIdSearchSingle(Async)");
        }


        com.squareup.okhttp.Call call = attributesAttachFilePrimaryIdSearchSingleCall(layerId, primaryId, attachmentId, progressListener, progressRequestListener);
        return call;





    }

    /**
     * Get individual attachment as file
     * Get an individual attachment as a file from a given layer (layerid) and record (primaryId). Just the individual attachment will be returned.  Also see: /attachments/{layerId}/{primaryId} to return all available attachments for a record.
     * @param layerId The Layer Id to search within (required)
     * @param primaryId Search by Layer&#39;s Primary Id (required)
     * @param attachmentId Search by Attachment&#39;s Primary Id (required)
     * @return File
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public File attributesAttachFilePrimaryIdSearchSingle(Long layerId, Long primaryId, Long attachmentId) throws ApiException {
        ApiResponse<File> resp = attributesAttachFilePrimaryIdSearchSingleWithHttpInfo(layerId, primaryId, attachmentId);
        return resp.getData();
    }

    /**
     * Get individual attachment as file
     * Get an individual attachment as a file from a given layer (layerid) and record (primaryId). Just the individual attachment will be returned.  Also see: /attachments/{layerId}/{primaryId} to return all available attachments for a record.
     * @param layerId The Layer Id to search within (required)
     * @param primaryId Search by Layer&#39;s Primary Id (required)
     * @param attachmentId Search by Attachment&#39;s Primary Id (required)
     * @return ApiResponse&lt;File&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<File> attributesAttachFilePrimaryIdSearchSingleWithHttpInfo(Long layerId, Long primaryId, Long attachmentId) throws ApiException {
        com.squareup.okhttp.Call call = attributesAttachFilePrimaryIdSearchSingleValidateBeforeCall(layerId, primaryId, attachmentId, null, null);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get individual attachment as file (asynchronously)
     * Get an individual attachment as a file from a given layer (layerid) and record (primaryId). Just the individual attachment will be returned.  Also see: /attachments/{layerId}/{primaryId} to return all available attachments for a record.
     * @param layerId The Layer Id to search within (required)
     * @param primaryId Search by Layer&#39;s Primary Id (required)
     * @param attachmentId Search by Attachment&#39;s Primary Id (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call attributesAttachFilePrimaryIdSearchSingleAsync(Long layerId, Long primaryId, Long attachmentId, final ApiCallback<File> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = attributesAttachFilePrimaryIdSearchSingleValidateBeforeCall(layerId, primaryId, attachmentId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<File>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for attributesAttachPrimaryIdDelete
     * @param layerId The Layer Id to delete the attachment from (required)
     * @param primaryId The Layer Record&#39;s Primary Id to delete attachment from (required)
     * @param attachmentId Delete attachment with given Attachment&#39;s Primary Id (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call attributesAttachPrimaryIdDeleteCall(Long layerId, Long primaryId, Long attachmentId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/attachments/{layerId}/{primaryId}/{attachmentId}"
                .replaceAll("\\{" + "layerId" + "\\}", apiClient.escapeString(layerId.toString()))
                .replaceAll("\\{" + "primaryId" + "\\}", apiClient.escapeString(primaryId.toString()))
                .replaceAll("\\{" + "attachmentId" + "\\}", apiClient.escapeString(attachmentId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
                "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                            .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                            .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "token" };
        return apiClient.buildCall(localVarPath, "DELETE", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call attributesAttachPrimaryIdDeleteValidateBeforeCall(Long layerId, Long primaryId, Long attachmentId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {

        // verify the required parameter 'layerId' is set
        if (layerId == null) {
            throw new ApiException("Missing the required parameter 'layerId' when calling attributesAttachPrimaryIdDelete(Async)");
        }

        // verify the required parameter 'primaryId' is set
        if (primaryId == null) {
            throw new ApiException("Missing the required parameter 'primaryId' when calling attributesAttachPrimaryIdDelete(Async)");
        }

        // verify the required parameter 'attachmentId' is set
        if (attachmentId == null) {
            throw new ApiException("Missing the required parameter 'attachmentId' when calling attributesAttachPrimaryIdDelete(Async)");
        }


        com.squareup.okhttp.Call call = attributesAttachPrimaryIdDeleteCall(layerId, primaryId, attachmentId, progressListener, progressRequestListener);
        return call;





    }

    /**
     * Delete an attachment
     * Delete an attachment in a given layer (layerid) and record (primaryId) using the given Attachment Id (attachmentId).
     * @param layerId The Layer Id to delete the attachment from (required)
     * @param primaryId The Layer Record&#39;s Primary Id to delete attachment from (required)
     * @param attachmentId Delete attachment with given Attachment&#39;s Primary Id (required)
     * @return OKResponseAttributesDelete
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public OKResponseAttributesDelete attributesAttachPrimaryIdDelete(Long layerId, Long primaryId, Long attachmentId) throws ApiException {
        ApiResponse<OKResponseAttributesDelete> resp = attributesAttachPrimaryIdDeleteWithHttpInfo(layerId, primaryId, attachmentId);
        return resp.getData();
    }

    /**
     * Delete an attachment
     * Delete an attachment in a given layer (layerid) and record (primaryId) using the given Attachment Id (attachmentId).
     * @param layerId The Layer Id to delete the attachment from (required)
     * @param primaryId The Layer Record&#39;s Primary Id to delete attachment from (required)
     * @param attachmentId Delete attachment with given Attachment&#39;s Primary Id (required)
     * @return ApiResponse&lt;OKResponseAttributesDelete&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<OKResponseAttributesDelete> attributesAttachPrimaryIdDeleteWithHttpInfo(Long layerId, Long primaryId, Long attachmentId) throws ApiException {
        com.squareup.okhttp.Call call = attributesAttachPrimaryIdDeleteValidateBeforeCall(layerId, primaryId, attachmentId, null, null);
        Type localVarReturnType = new TypeToken<OKResponseAttributesDelete>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Delete an attachment (asynchronously)
     * Delete an attachment in a given layer (layerid) and record (primaryId) using the given Attachment Id (attachmentId).
     * @param layerId The Layer Id to delete the attachment from (required)
     * @param primaryId The Layer Record&#39;s Primary Id to delete attachment from (required)
     * @param attachmentId Delete attachment with given Attachment&#39;s Primary Id (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call attributesAttachPrimaryIdDeleteAsync(Long layerId, Long primaryId, Long attachmentId, final ApiCallback<OKResponseAttributesDelete> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = attributesAttachPrimaryIdDeleteValidateBeforeCall(layerId, primaryId, attachmentId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<OKResponseAttributesDelete>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for attributesAttachPrimaryIdSearchAll
     * @param layerId The Layer Id to search within (required)
     * @param primaryId Search by Layer&#39;s Primary Id (required)
     * @param start Start record index if using paging (Optional, 1-based, 1 &#x3D; First Record).  If ommited then 1 will be used. (optional)
     * @param limit Limit result if using paging (Optional, 0 to 100).  If ommited then default of 25 will be used. (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call attributesAttachPrimaryIdSearchAllCall(Long layerId, Long primaryId, Long start, Long limit, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/attachments/{layerId}/{primaryId}"
                .replaceAll("\\{" + "layerId" + "\\}", apiClient.escapeString(layerId.toString()))
                .replaceAll("\\{" + "primaryId" + "\\}", apiClient.escapeString(primaryId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (start != null)
            localVarQueryParams.addAll(apiClient.parameterToPairs("", "start", start));
        if (limit != null)
            localVarQueryParams.addAll(apiClient.parameterToPairs("", "limit", limit));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
                "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                            .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                            .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "token" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call attributesAttachPrimaryIdSearchAllValidateBeforeCall(Long layerId, Long primaryId, Long start, Long limit, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {

        // verify the required parameter 'layerId' is set
        if (layerId == null) {
            throw new ApiException("Missing the required parameter 'layerId' when calling attributesAttachPrimaryIdSearchAll(Async)");
        }

        // verify the required parameter 'primaryId' is set
        if (primaryId == null) {
            throw new ApiException("Missing the required parameter 'primaryId' when calling attributesAttachPrimaryIdSearchAll(Async)");
        }


        com.squareup.okhttp.Call call = attributesAttachPrimaryIdSearchAllCall(layerId, primaryId, start, limit, progressListener, progressRequestListener);
        return call;





    }

    /**
     * Get all available attachments for a record
     * Get all attachments from a given layer (layerid) and record (primaryId).  Also see: /attachments/{layerId}/{primaryId}/{attachmentId} to return an individual attachment from a record.
     * @param layerId The Layer Id to search within (required)
     * @param primaryId Search by Layer&#39;s Primary Id (required)
     * @param start Start record index if using paging (Optional, 1-based, 1 &#x3D; First Record).  If ommited then 1 will be used. (optional)
     * @param limit Limit result if using paging (Optional, 0 to 100).  If ommited then default of 25 will be used. (optional)
     * @return OKResponseAttachments
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public OKResponseAttachments attributesAttachPrimaryIdSearchAll(Long layerId, Long primaryId, Long start, Long limit) throws ApiException {
        ApiResponse<OKResponseAttachments> resp = attributesAttachPrimaryIdSearchAllWithHttpInfo(layerId, primaryId, start, limit);
        return resp.getData();
    }

    /**
     * Get all available attachments for a record
     * Get all attachments from a given layer (layerid) and record (primaryId).  Also see: /attachments/{layerId}/{primaryId}/{attachmentId} to return an individual attachment from a record.
     * @param layerId The Layer Id to search within (required)
     * @param primaryId Search by Layer&#39;s Primary Id (required)
     * @param start Start record index if using paging (Optional, 1-based, 1 &#x3D; First Record).  If ommited then 1 will be used. (optional)
     * @param limit Limit result if using paging (Optional, 0 to 100).  If ommited then default of 25 will be used. (optional)
     * @return ApiResponse&lt;OKResponseAttachments&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<OKResponseAttachments> attributesAttachPrimaryIdSearchAllWithHttpInfo(Long layerId, Long primaryId, Long start, Long limit) throws ApiException {
        com.squareup.okhttp.Call call = attributesAttachPrimaryIdSearchAllValidateBeforeCall(layerId, primaryId, start, limit, null, null);
        Type localVarReturnType = new TypeToken<OKResponseAttachments>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get all available attachments for a record (asynchronously)
     * Get all attachments from a given layer (layerid) and record (primaryId).  Also see: /attachments/{layerId}/{primaryId}/{attachmentId} to return an individual attachment from a record.
     * @param layerId The Layer Id to search within (required)
     * @param primaryId Search by Layer&#39;s Primary Id (required)
     * @param start Start record index if using paging (Optional, 1-based, 1 &#x3D; First Record).  If ommited then 1 will be used. (optional)
     * @param limit Limit result if using paging (Optional, 0 to 100).  If ommited then default of 25 will be used. (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call attributesAttachPrimaryIdSearchAllAsync(Long layerId, Long primaryId, Long start, Long limit, final ApiCallback<OKResponseAttachments> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = attributesAttachPrimaryIdSearchAllValidateBeforeCall(layerId, primaryId, start, limit, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<OKResponseAttachments>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for attributesAttachPrimaryIdSearchSingle
     * @param layerId The Layer Id to search within (required)
     * @param primaryId Search by Layer&#39;s Primary Id (required)
     * @param attachmentId Search by Attachment&#39;s Primary Id (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call attributesAttachPrimaryIdSearchSingleCall(Long layerId, Long primaryId, Long attachmentId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/attachments/{layerId}/{primaryId}/{attachmentId}"
                .replaceAll("\\{" + "layerId" + "\\}", apiClient.escapeString(layerId.toString()))
                .replaceAll("\\{" + "primaryId" + "\\}", apiClient.escapeString(primaryId.toString()))
                .replaceAll("\\{" + "attachmentId" + "\\}", apiClient.escapeString(attachmentId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
                "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                            .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                            .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "token" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call attributesAttachPrimaryIdSearchSingleValidateBeforeCall(Long layerId, Long primaryId, Long attachmentId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {

        // verify the required parameter 'layerId' is set
        if (layerId == null) {
            throw new ApiException("Missing the required parameter 'layerId' when calling attributesAttachPrimaryIdSearchSingle(Async)");
        }

        // verify the required parameter 'primaryId' is set
        if (primaryId == null) {
            throw new ApiException("Missing the required parameter 'primaryId' when calling attributesAttachPrimaryIdSearchSingle(Async)");
        }

        // verify the required parameter 'attachmentId' is set
        if (attachmentId == null) {
            throw new ApiException("Missing the required parameter 'attachmentId' when calling attributesAttachPrimaryIdSearchSingle(Async)");
        }


        com.squareup.okhttp.Call call = attributesAttachPrimaryIdSearchSingleCall(layerId, primaryId, attachmentId, progressListener, progressRequestListener);
        return call;





    }

    /**
     * Get individual attachment
     * Get an individual attachment from a given layer (layerid) and record (primaryId). Just the individual attachment will be returned.  Also see: /attachments/{layerId}/{primaryId} to return all available attachments for a record.
     * @param layerId The Layer Id to search within (required)
     * @param primaryId Search by Layer&#39;s Primary Id (required)
     * @param attachmentId Search by Attachment&#39;s Primary Id (required)
     * @return OKResponseAttachments
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public OKResponseAttachments attributesAttachPrimaryIdSearchSingle(Long layerId, Long primaryId, Long attachmentId) throws ApiException {
        ApiResponse<OKResponseAttachments> resp = attributesAttachPrimaryIdSearchSingleWithHttpInfo(layerId, primaryId, attachmentId);
        return resp.getData();
    }

    /**
     * Get individual attachment
     * Get an individual attachment from a given layer (layerid) and record (primaryId). Just the individual attachment will be returned.  Also see: /attachments/{layerId}/{primaryId} to return all available attachments for a record.
     * @param layerId The Layer Id to search within (required)
     * @param primaryId Search by Layer&#39;s Primary Id (required)
     * @param attachmentId Search by Attachment&#39;s Primary Id (required)
     * @return ApiResponse&lt;OKResponseAttachments&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<OKResponseAttachments> attributesAttachPrimaryIdSearchSingleWithHttpInfo(Long layerId, Long primaryId, Long attachmentId) throws ApiException {
        com.squareup.okhttp.Call call = attributesAttachPrimaryIdSearchSingleValidateBeforeCall(layerId, primaryId, attachmentId, null, null);
        Type localVarReturnType = new TypeToken<OKResponseAttachments>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get individual attachment (asynchronously)
     * Get an individual attachment from a given layer (layerid) and record (primaryId). Just the individual attachment will be returned.  Also see: /attachments/{layerId}/{primaryId} to return all available attachments for a record.
     * @param layerId The Layer Id to search within (required)
     * @param primaryId Search by Layer&#39;s Primary Id (required)
     * @param attachmentId Search by Attachment&#39;s Primary Id (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call attributesAttachPrimaryIdSearchSingleAsync(Long layerId, Long primaryId, Long attachmentId, final ApiCallback<OKResponseAttachments> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = attributesAttachPrimaryIdSearchSingleValidateBeforeCall(layerId, primaryId, attachmentId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<OKResponseAttachments>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for attributesPrimaryIdUpdate
     * @param layerId The Layer Id to update the attachment from (required)
     * @param primaryId The Layer&#39;s Primary Id to update attachment from (required)
     * @param attachmentId Update/Replace attachment using given Attachment&#39;s Primary Id (required)
     * @param updatedAttachmentInfo Info on the attachment to modify (required)
     * @param updatedAttachmentFile The attachment to modify (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call attributesPrimaryIdUpdateCall(Long layerId, Long primaryId, Long attachmentId, Map<String, String> updatedAttachmentInfo, File updatedAttachmentFile, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;

        // create path and map variables
        String localVarPath = "/attachments/{layerId}/{primaryId}/{attachmentId}"
                .replaceAll("\\{" + "layerId" + "\\}", apiClient.escapeString(layerId.toString()))
                .replaceAll("\\{" + "primaryId" + "\\}", apiClient.escapeString(primaryId.toString()))
                .replaceAll("\\{" + "attachmentId" + "\\}", apiClient.escapeString(attachmentId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();
        if (updatedAttachmentInfo != null)
            localVarFormParams.put("updatedAttachmentInfo", updatedAttachmentInfo);
        if (updatedAttachmentFile != null)
            localVarFormParams.put("updatedAttachmentFile", updatedAttachmentFile);

        final String[] localVarAccepts = {
                "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {

        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                            .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                            .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "token" };
        return apiClient.buildCall(localVarPath, "PUT", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }

    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call attributesPrimaryIdUpdateValidateBeforeCall(Long layerId, Long primaryId, Long attachmentId, Map<String, String> updatedAttachmentInfo, File updatedAttachmentFile, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {

        // verify the required parameter 'layerId' is set
        if (layerId == null) {
            throw new ApiException("Missing the required parameter 'layerId' when calling attributesPrimaryIdUpdate(Async)");
        }

        // verify the required parameter 'primaryId' is set
        if (primaryId == null) {
            throw new ApiException("Missing the required parameter 'primaryId' when calling attributesPrimaryIdUpdate(Async)");
        }

        // verify the required parameter 'attachmentId' is set
        if (attachmentId == null) {
            throw new ApiException("Missing the required parameter 'attachmentId' when calling attributesPrimaryIdUpdate(Async)");
        }

        // verify the required parameter 'updatedAttachmentInfo' is set
        if (updatedAttachmentInfo == null) {
            throw new ApiException("Missing the required parameter 'updatedAttachmentInfo' when calling attributesPrimaryIdUpdate(Async)");
        }

        // verify the required parameter 'updatedAttachmentFile' is set
        if (updatedAttachmentFile == null) {
            throw new ApiException("Missing the required parameter 'updatedAttachmentFile' when calling attributesPrimaryIdUpdate(Async)");
        }


        com.squareup.okhttp.Call call = attributesPrimaryIdUpdateCall(layerId, primaryId, attachmentId, updatedAttachmentInfo, updatedAttachmentFile, progressListener, progressRequestListener);
        return call;





    }

    /**
     * Update/Replace an attachment
     * Update/Replace an attachment in a given layer (layerid) and record (primaryId) using the given Attachment Id (attachmentId).
     * @param layerId The Layer Id to update the attachment from (required)
     * @param primaryId The Layer&#39;s Primary Id to update attachment from (required)
     * @param attachmentId Update/Replace attachment using given Attachment&#39;s Primary Id (required)
     * @param updatedAttachmentInfo Info on the attachment to modify (required)
     * @param updatedAttachmentFile The attachment to modify (required)
     * @return OKResponseAttachmentsUpdate
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public OKResponseAttachmentsUpdate attributesPrimaryIdUpdate(Long layerId, Long primaryId, Long attachmentId, Map<String, String> updatedAttachmentInfo, File updatedAttachmentFile) throws ApiException {
        ApiResponse<OKResponseAttachmentsUpdate> resp = attributesPrimaryIdUpdateWithHttpInfo(layerId, primaryId, attachmentId, updatedAttachmentInfo, updatedAttachmentFile);
        return resp.getData();
    }

    /**
     * Update/Replace an attachment
     * Update/Replace an attachment in a given layer (layerid) and record (primaryId) using the given Attachment Id (attachmentId).
     * @param layerId The Layer Id to update the attachment from (required)
     * @param primaryId The Layer&#39;s Primary Id to update attachment from (required)
     * @param attachmentId Update/Replace attachment using given Attachment&#39;s Primary Id (required)
     * @param updatedAttachmentInfo Info on the attachment to modify (required)
     * @param updatedAttachmentFile The attachment to modify (required)
     * @return ApiResponse&lt;OKResponseAttachmentsUpdate&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<OKResponseAttachmentsUpdate> attributesPrimaryIdUpdateWithHttpInfo(Long layerId, Long primaryId, Long attachmentId, Map<String, String> updatedAttachmentInfo, File updatedAttachmentFile) throws ApiException {
        com.squareup.okhttp.Call call = attributesPrimaryIdUpdateValidateBeforeCall(layerId, primaryId, attachmentId, updatedAttachmentInfo, updatedAttachmentFile, null, null);
        Type localVarReturnType = new TypeToken<OKResponseAttachmentsUpdate>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Update/Replace an attachment (asynchronously)
     * Update/Replace an attachment in a given layer (layerid) and record (primaryId) using the given Attachment Id (attachmentId).
     * @param layerId The Layer Id to update the attachment from (required)
     * @param primaryId The Layer&#39;s Primary Id to update attachment from (required)
     * @param attachmentId Update/Replace attachment using given Attachment&#39;s Primary Id (required)
     * @param updatedAttachmentInfo Info on the attachment to modify (required)
     * @param updatedAttachmentFile The attachment to modify (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call attributesPrimaryIdUpdateAsync(Long layerId, Long primaryId, Long attachmentId, Map<String, String> updatedAttachmentInfo, File updatedAttachmentFile, final ApiCallback<OKResponseAttachmentsUpdate> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = attributesPrimaryIdUpdateValidateBeforeCall(layerId, primaryId, attachmentId, updatedAttachmentInfo, updatedAttachmentFile, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<OKResponseAttachmentsUpdate>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}
