/*
 * 1map API
 * 1map API Documentation (<b>Premium</b> and <b>Enterprise</b> Users).  # How it works:  First you will login to the API with the <b><i>API's Login Service</i></b>.  After a successful call to the <b><i>API's Login Service</i></b> you will receive a Token. This Token is needed for all secure calls to the 1map server (To all API calls where there is a lock icon next to it). A Token is only valid per session. The Session and your Token will expire after 2 hours of inactivity or the moment you do a call to the <b><i>API's Logout Service</i></b>.  Please note that all date/time fields are returned in SAST (South Africa Standard Time) time zone and in the <a href=\"https://en.wikipedia.org/wiki/ISO_8601\" target=\"_blank\">ISO 8601</a> format (YYYY-MM-DD[T]HH:mm:ss.SSS[Z]).  Please feel free to contact us at [Support](mailto:support@1map.co.za), should you require any additional API Services not listed below.  See a full working Javascript example and download source code [here](../api/jsmap)  --- 
 *
 * OpenAPI spec version: 1.0.0
 * Contact: support@1map.co.za
 *
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen.git
 * Do not edit the class manually.
 */


package io.swagger.client.api;

import io.swagger.client.ApiCallback;
import io.swagger.client.ApiClient;
import io.swagger.client.ApiException;
import io.swagger.client.ApiResponse;
import io.swagger.client.Configuration;
import io.swagger.client.Pair;
import io.swagger.client.ProgressRequestBody;
import io.swagger.client.ProgressResponseBody;

import com.google.gson.reflect.TypeToken;

import java.io.IOException;


import io.swagger.client.model.Geometry;
import io.swagger.client.model.OKResponseAddressClosest;
import io.swagger.client.model.OKResponseAddressIntersect;
import io.swagger.client.model.OKResponseAddressNADId;
import io.swagger.client.model.OKResponseAddressRadial;
import io.swagger.client.model.OKResponseAddressSearch;
import io.swagger.client.model.OKResponseAddressStandNo;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AddressesApi {
    private ApiClient apiClient;

    public AddressesApi() {
        this(Configuration.getDefaultApiClient());
    }

    public AddressesApi(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    public ApiClient getApiClient() {
        return apiClient;
    }

    public void setApiClient(ApiClient apiClient) {
        this.apiClient = apiClient;
    }

    /**
     * Build call for addressClosestSearch
     * @param longitude The longitude (WGS84) for the coordinate to search (required)
     * @param latitude The latitude (WGS84) for the coordinate to search (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call addressClosestSearchCall(Double longitude, Double latitude, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        
        // create path and map variables
        String localVarPath = "/address/closest";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (longitude != null)
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "longitude", longitude));
        if (latitude != null)
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "latitude", latitude));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "token" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }
    
    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call addressClosestSearchValidateBeforeCall(Double longitude, Double latitude, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'longitude' is set
        if (longitude == null) {
            throw new ApiException("Missing the required parameter 'longitude' when calling addressClosestSearch(Async)");
        }
        
        // verify the required parameter 'latitude' is set
        if (latitude == null) {
            throw new ApiException("Missing the required parameter 'latitude' when calling addressClosestSearch(Async)");
        }
        
        
        com.squareup.okhttp.Call call = addressClosestSearchCall(longitude, latitude, progressListener, progressRequestListener);
        return call;

        
        
        
        
    }

    /**
     * Search for closest street address to given coordinate
     * This api call searches for the closest 1map Street Address to a given coordinate (WGS84 Lon/Lat).
     * @param longitude The longitude (WGS84) for the coordinate to search (required)
     * @param latitude The latitude (WGS84) for the coordinate to search (required)
     * @return OKResponseAddressClosest
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public OKResponseAddressClosest addressClosestSearch(Double longitude, Double latitude) throws ApiException {
        ApiResponse<OKResponseAddressClosest> resp = addressClosestSearchWithHttpInfo(longitude, latitude);
        return resp.getData();
    }

    /**
     * Search for closest street address to given coordinate
     * This api call searches for the closest 1map Street Address to a given coordinate (WGS84 Lon/Lat).
     * @param longitude The longitude (WGS84) for the coordinate to search (required)
     * @param latitude The latitude (WGS84) for the coordinate to search (required)
     * @return ApiResponse&lt;OKResponseAddressClosest&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<OKResponseAddressClosest> addressClosestSearchWithHttpInfo(Double longitude, Double latitude) throws ApiException {
        com.squareup.okhttp.Call call = addressClosestSearchValidateBeforeCall(longitude, latitude, null, null);
        Type localVarReturnType = new TypeToken<OKResponseAddressClosest>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Search for closest street address to given coordinate (asynchronously)
     * This api call searches for the closest 1map Street Address to a given coordinate (WGS84 Lon/Lat).
     * @param longitude The longitude (WGS84) for the coordinate to search (required)
     * @param latitude The latitude (WGS84) for the coordinate to search (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call addressClosestSearchAsync(Double longitude, Double latitude, final ApiCallback<OKResponseAddressClosest> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = addressClosestSearchValidateBeforeCall(longitude, latitude, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<OKResponseAddressClosest>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for addressIdSearch
     * @param nadId Search for address with given id (Primary Key) (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call addressIdSearchCall(Long nadId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        
        // create path and map variables
        String localVarPath = "/address/nadid/{nadId}"
            .replaceAll("\\{" + "nadId" + "\\}", apiClient.escapeString(nadId.toString()));

        List<Pair> localVarQueryParams = new ArrayList<Pair>();

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "token" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }
    
    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call addressIdSearchValidateBeforeCall(Long nadId, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'nadId' is set
        if (nadId == null) {
            throw new ApiException("Missing the required parameter 'nadId' when calling addressIdSearch(Async)");
        }
        
        
        com.squareup.okhttp.Call call = addressIdSearchCall(nadId, progressListener, progressRequestListener);
        return call;

        
        
        
        
    }

    /**
     * Search for street address by 1map NAD Id
     * This api call searches for a given 1map Street Address by using the passed 1map NAD Id
     * @param nadId Search for address with given id (Primary Key) (required)
     * @return OKResponseAddressNADId
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public OKResponseAddressNADId addressIdSearch(Long nadId) throws ApiException {
        ApiResponse<OKResponseAddressNADId> resp = addressIdSearchWithHttpInfo(nadId);
        return resp.getData();
    }

    /**
     * Search for street address by 1map NAD Id
     * This api call searches for a given 1map Street Address by using the passed 1map NAD Id
     * @param nadId Search for address with given id (Primary Key) (required)
     * @return ApiResponse&lt;OKResponseAddressNADId&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<OKResponseAddressNADId> addressIdSearchWithHttpInfo(Long nadId) throws ApiException {
        com.squareup.okhttp.Call call = addressIdSearchValidateBeforeCall(nadId, null, null);
        Type localVarReturnType = new TypeToken<OKResponseAddressNADId>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Search for street address by 1map NAD Id (asynchronously)
     * This api call searches for a given 1map Street Address by using the passed 1map NAD Id
     * @param nadId Search for address with given id (Primary Key) (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call addressIdSearchAsync(Long nadId, final ApiCallback<OKResponseAddressNADId> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = addressIdSearchValidateBeforeCall(nadId, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<OKResponseAddressNADId>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for addressIntersectSearch
     * @param geometry The Geometry (Geojson Object) to search within (required)
     * @param start Start record index if using paging (Optional, 1-based, 1 &#x3D; First Record).  If ommited then 1 will be used. (optional)
     * @param limit Limit result if using paging (Optional, 0 to 25).  If ommited then default of 25 will be used. (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call addressIntersectSearchCall(Geometry geometry, Long start, Long limit, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = geometry;
        
        // create path and map variables
        String localVarPath = "/address/intersect";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (start != null)
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "start", start));
        if (limit != null)
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "limit", limit));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "token" };
        return apiClient.buildCall(localVarPath, "POST", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }
    
    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call addressIntersectSearchValidateBeforeCall(Geometry geometry, Long start, Long limit, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'geometry' is set
        if (geometry == null) {
            throw new ApiException("Missing the required parameter 'geometry' when calling addressIntersectSearch(Async)");
        }
        
        
        com.squareup.okhttp.Call call = addressIntersectSearchCall(geometry, start, limit, progressListener, progressRequestListener);
        return call;

        
        
        
        
    }

    /**
     * Get Street Addresses intersecting an area (polygon)
     * This api call searches for all Street Addresses from the 1map NAD that intersects a given area (polygon).
     * @param geometry The Geometry (Geojson Object) to search within (required)
     * @param start Start record index if using paging (Optional, 1-based, 1 &#x3D; First Record).  If ommited then 1 will be used. (optional)
     * @param limit Limit result if using paging (Optional, 0 to 25).  If ommited then default of 25 will be used. (optional)
     * @return OKResponseAddressIntersect
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public OKResponseAddressIntersect addressIntersectSearch(Geometry geometry, Long start, Long limit) throws ApiException {
        ApiResponse<OKResponseAddressIntersect> resp = addressIntersectSearchWithHttpInfo(geometry, start, limit);
        return resp.getData();
    }

    /**
     * Get Street Addresses intersecting an area (polygon)
     * This api call searches for all Street Addresses from the 1map NAD that intersects a given area (polygon).
     * @param geometry The Geometry (Geojson Object) to search within (required)
     * @param start Start record index if using paging (Optional, 1-based, 1 &#x3D; First Record).  If ommited then 1 will be used. (optional)
     * @param limit Limit result if using paging (Optional, 0 to 25).  If ommited then default of 25 will be used. (optional)
     * @return ApiResponse&lt;OKResponseAddressIntersect&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<OKResponseAddressIntersect> addressIntersectSearchWithHttpInfo(Geometry geometry, Long start, Long limit) throws ApiException {
        com.squareup.okhttp.Call call = addressIntersectSearchValidateBeforeCall(geometry, start, limit, null, null);
        Type localVarReturnType = new TypeToken<OKResponseAddressIntersect>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Get Street Addresses intersecting an area (polygon) (asynchronously)
     * This api call searches for all Street Addresses from the 1map NAD that intersects a given area (polygon).
     * @param geometry The Geometry (Geojson Object) to search within (required)
     * @param start Start record index if using paging (Optional, 1-based, 1 &#x3D; First Record).  If ommited then 1 will be used. (optional)
     * @param limit Limit result if using paging (Optional, 0 to 25).  If ommited then default of 25 will be used. (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call addressIntersectSearchAsync(Geometry geometry, Long start, Long limit, final ApiCallback<OKResponseAddressIntersect> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = addressIntersectSearchValidateBeforeCall(geometry, start, limit, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<OKResponseAddressIntersect>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for addressRadialSearch
     * @param longitude The longitude (WGS84) for the coordinate to search (required)
     * @param latitude The latitude (WGS84) for the coordinate to search (required)
     * @param radius The radius (in meters - maksimum 200) to search for (required)
     * @param start Start record index if using paging (Optional, 1-based, 1 &#x3D; First Record).  If ommited then 1 will be used. (optional)
     * @param limit Limit result if using paging (Optional, 0 to 25).  If ommited then default of 25 will be used. (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call addressRadialSearchCall(Double longitude, Double latitude, Double radius, Long start, Long limit, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        
        // create path and map variables
        String localVarPath = "/address/radial";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (longitude != null)
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "longitude", longitude));
        if (latitude != null)
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "latitude", latitude));
        if (radius != null)
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "radius", radius));
        if (start != null)
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "start", start));
        if (limit != null)
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "limit", limit));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "token" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }
    
    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call addressRadialSearchValidateBeforeCall(Double longitude, Double latitude, Double radius, Long start, Long limit, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'longitude' is set
        if (longitude == null) {
            throw new ApiException("Missing the required parameter 'longitude' when calling addressRadialSearch(Async)");
        }
        
        // verify the required parameter 'latitude' is set
        if (latitude == null) {
            throw new ApiException("Missing the required parameter 'latitude' when calling addressRadialSearch(Async)");
        }
        
        // verify the required parameter 'radius' is set
        if (radius == null) {
            throw new ApiException("Missing the required parameter 'radius' when calling addressRadialSearch(Async)");
        }
        
        
        com.squareup.okhttp.Call call = addressRadialSearchCall(longitude, latitude, radius, start, limit, progressListener, progressRequestListener);
        return call;

        
        
        
        
    }

    /**
     * Search for all street address within a radius to a given coordinate
     * This api call searches for all 1map Street Address within a radius (in meters) to a given coordinate (WGS84 Lon/Lat).
     * @param longitude The longitude (WGS84) for the coordinate to search (required)
     * @param latitude The latitude (WGS84) for the coordinate to search (required)
     * @param radius The radius (in meters - maksimum 200) to search for (required)
     * @param start Start record index if using paging (Optional, 1-based, 1 &#x3D; First Record).  If ommited then 1 will be used. (optional)
     * @param limit Limit result if using paging (Optional, 0 to 25).  If ommited then default of 25 will be used. (optional)
     * @return OKResponseAddressRadial
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public OKResponseAddressRadial addressRadialSearch(Double longitude, Double latitude, Double radius, Long start, Long limit) throws ApiException {
        ApiResponse<OKResponseAddressRadial> resp = addressRadialSearchWithHttpInfo(longitude, latitude, radius, start, limit);
        return resp.getData();
    }

    /**
     * Search for all street address within a radius to a given coordinate
     * This api call searches for all 1map Street Address within a radius (in meters) to a given coordinate (WGS84 Lon/Lat).
     * @param longitude The longitude (WGS84) for the coordinate to search (required)
     * @param latitude The latitude (WGS84) for the coordinate to search (required)
     * @param radius The radius (in meters - maksimum 200) to search for (required)
     * @param start Start record index if using paging (Optional, 1-based, 1 &#x3D; First Record).  If ommited then 1 will be used. (optional)
     * @param limit Limit result if using paging (Optional, 0 to 25).  If ommited then default of 25 will be used. (optional)
     * @return ApiResponse&lt;OKResponseAddressRadial&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<OKResponseAddressRadial> addressRadialSearchWithHttpInfo(Double longitude, Double latitude, Double radius, Long start, Long limit) throws ApiException {
        com.squareup.okhttp.Call call = addressRadialSearchValidateBeforeCall(longitude, latitude, radius, start, limit, null, null);
        Type localVarReturnType = new TypeToken<OKResponseAddressRadial>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Search for all street address within a radius to a given coordinate (asynchronously)
     * This api call searches for all 1map Street Address within a radius (in meters) to a given coordinate (WGS84 Lon/Lat).
     * @param longitude The longitude (WGS84) for the coordinate to search (required)
     * @param latitude The latitude (WGS84) for the coordinate to search (required)
     * @param radius The radius (in meters - maksimum 200) to search for (required)
     * @param start Start record index if using paging (Optional, 1-based, 1 &#x3D; First Record).  If ommited then 1 will be used. (optional)
     * @param limit Limit result if using paging (Optional, 0 to 25).  If ommited then default of 25 will be used. (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call addressRadialSearchAsync(Double longitude, Double latitude, Double radius, Long start, Long limit, final ApiCallback<OKResponseAddressRadial> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = addressRadialSearchValidateBeforeCall(longitude, latitude, radius, start, limit, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<OKResponseAddressRadial>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for addressSG21KeySearch
     * @param sg21Key Search for addresses with the given SG21Key (required)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call addressSG21KeySearchCall(String sg21Key, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        
        // create path and map variables
        String localVarPath = "/address/sg21key";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (sg21Key != null)
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "sg21Key", sg21Key));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "token" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }
    
    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call addressSG21KeySearchValidateBeforeCall(String sg21Key, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'sg21Key' is set
        if (sg21Key == null) {
            throw new ApiException("Missing the required parameter 'sg21Key' when calling addressSG21KeySearch(Async)");
        }
        
        
        com.squareup.okhttp.Call call = addressSG21KeySearchCall(sg21Key, progressListener, progressRequestListener);
        return call;

        
        
        
        
    }

    /**
     * Search for street address by SG21Key
     * This api call searches for a given stand by SG21Key.  It will return the stand and all street addresses associated with the returned stand (If any).
     * @param sg21Key Search for addresses with the given SG21Key (required)
     * @return OKResponseAddressStandNo
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public OKResponseAddressStandNo addressSG21KeySearch(String sg21Key) throws ApiException {
        ApiResponse<OKResponseAddressStandNo> resp = addressSG21KeySearchWithHttpInfo(sg21Key);
        return resp.getData();
    }

    /**
     * Search for street address by SG21Key
     * This api call searches for a given stand by SG21Key.  It will return the stand and all street addresses associated with the returned stand (If any).
     * @param sg21Key Search for addresses with the given SG21Key (required)
     * @return ApiResponse&lt;OKResponseAddressStandNo&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<OKResponseAddressStandNo> addressSG21KeySearchWithHttpInfo(String sg21Key) throws ApiException {
        com.squareup.okhttp.Call call = addressSG21KeySearchValidateBeforeCall(sg21Key, null, null);
        Type localVarReturnType = new TypeToken<OKResponseAddressStandNo>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Search for street address by SG21Key (asynchronously)
     * This api call searches for a given stand by SG21Key.  It will return the stand and all street addresses associated with the returned stand (If any).
     * @param sg21Key Search for addresses with the given SG21Key (required)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call addressSG21KeySearchAsync(String sg21Key, final ApiCallback<OKResponseAddressStandNo> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = addressSG21KeySearchValidateBeforeCall(sg21Key, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<OKResponseAddressStandNo>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for addressSearch
     * @param address The street address to search for or part of it (required)
     * @param start Start record index if using paging (Optional, 1-based, 1 &#x3D; First Record).  If ommited then 1 will be used. (optional)
     * @param limit Limit result if using paging (Optional, 0 to 25).  If ommited then default of 25 will be used. (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call addressSearchCall(String address, Long start, Long limit, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        
        // create path and map variables
        String localVarPath = "/address/search";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (address != null)
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "address", address));
        if (start != null)
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "start", start));
        if (limit != null)
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "limit", limit));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "token" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }
    
    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call addressSearchValidateBeforeCall(String address, Long start, Long limit, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'address' is set
        if (address == null) {
            throw new ApiException("Missing the required parameter 'address' when calling addressSearch(Async)");
        }
        
        
        com.squareup.okhttp.Call call = addressSearchCall(address, start, limit, progressListener, progressRequestListener);
        return call;

        
        
        
        
    }

    /**
     * Search for street address
     * This uses 1map&#39;s very fast street address search.  It does a partial and full search on all 1map street addresses using the address string passed.
     * @param address The street address to search for or part of it (required)
     * @param start Start record index if using paging (Optional, 1-based, 1 &#x3D; First Record).  If ommited then 1 will be used. (optional)
     * @param limit Limit result if using paging (Optional, 0 to 25).  If ommited then default of 25 will be used. (optional)
     * @return OKResponseAddressSearch
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public OKResponseAddressSearch addressSearch(String address, Long start, Long limit) throws ApiException {
        ApiResponse<OKResponseAddressSearch> resp = addressSearchWithHttpInfo(address, start, limit);
        return resp.getData();
    }

    /**
     * Search for street address
     * This uses 1map&#39;s very fast street address search.  It does a partial and full search on all 1map street addresses using the address string passed.
     * @param address The street address to search for or part of it (required)
     * @param start Start record index if using paging (Optional, 1-based, 1 &#x3D; First Record).  If ommited then 1 will be used. (optional)
     * @param limit Limit result if using paging (Optional, 0 to 25).  If ommited then default of 25 will be used. (optional)
     * @return ApiResponse&lt;OKResponseAddressSearch&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<OKResponseAddressSearch> addressSearchWithHttpInfo(String address, Long start, Long limit) throws ApiException {
        com.squareup.okhttp.Call call = addressSearchValidateBeforeCall(address, start, limit, null, null);
        Type localVarReturnType = new TypeToken<OKResponseAddressSearch>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Search for street address (asynchronously)
     * This uses 1map&#39;s very fast street address search.  It does a partial and full search on all 1map street addresses using the address string passed.
     * @param address The street address to search for or part of it (required)
     * @param start Start record index if using paging (Optional, 1-based, 1 &#x3D; First Record).  If ommited then 1 will be used. (optional)
     * @param limit Limit result if using paging (Optional, 0 to 25).  If ommited then default of 25 will be used. (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call addressSearchAsync(String address, Long start, Long limit, final ApiCallback<OKResponseAddressSearch> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = addressSearchValidateBeforeCall(address, start, limit, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<OKResponseAddressSearch>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
    /**
     * Build call for addressStandSearch
     * @param cityMunicipality Search for addresses in the given City or Municipality (required)
     * @param standNo Search for addresses with the given Stand Number (required)
     * @param portionNo Search for addresses with the given Portion Number (optional)
     * @param progressListener Progress listener
     * @param progressRequestListener Progress request listener
     * @return Call to execute
     * @throws ApiException If fail to serialize the request body object
     */
    public com.squareup.okhttp.Call addressStandSearchCall(String cityMunicipality, String standNo, String portionNo, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        Object localVarPostBody = null;
        
        // create path and map variables
        String localVarPath = "/address/standno";

        List<Pair> localVarQueryParams = new ArrayList<Pair>();
        if (cityMunicipality != null)
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "cityMunicipality", cityMunicipality));
        if (standNo != null)
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "standNo", standNo));
        if (portionNo != null)
        localVarQueryParams.addAll(apiClient.parameterToPairs("", "portionNo", portionNo));

        Map<String, String> localVarHeaderParams = new HashMap<String, String>();

        Map<String, Object> localVarFormParams = new HashMap<String, Object>();

        final String[] localVarAccepts = {
            "application/json"
        };
        final String localVarAccept = apiClient.selectHeaderAccept(localVarAccepts);
        if (localVarAccept != null) localVarHeaderParams.put("Accept", localVarAccept);

        final String[] localVarContentTypes = {
            
        };
        final String localVarContentType = apiClient.selectHeaderContentType(localVarContentTypes);
        localVarHeaderParams.put("Content-Type", localVarContentType);

        if(progressListener != null) {
            apiClient.getHttpClient().networkInterceptors().add(new com.squareup.okhttp.Interceptor() {
                @Override
                public com.squareup.okhttp.Response intercept(com.squareup.okhttp.Interceptor.Chain chain) throws IOException {
                    com.squareup.okhttp.Response originalResponse = chain.proceed(chain.request());
                    return originalResponse.newBuilder()
                    .body(new ProgressResponseBody(originalResponse.body(), progressListener))
                    .build();
                }
            });
        }

        String[] localVarAuthNames = new String[] { "token" };
        return apiClient.buildCall(localVarPath, "GET", localVarQueryParams, localVarPostBody, localVarHeaderParams, localVarFormParams, localVarAuthNames, progressRequestListener);
    }
    
    @SuppressWarnings("rawtypes")
    private com.squareup.okhttp.Call addressStandSearchValidateBeforeCall(String cityMunicipality, String standNo, String portionNo, final ProgressResponseBody.ProgressListener progressListener, final ProgressRequestBody.ProgressRequestListener progressRequestListener) throws ApiException {
        
        // verify the required parameter 'cityMunicipality' is set
        if (cityMunicipality == null) {
            throw new ApiException("Missing the required parameter 'cityMunicipality' when calling addressStandSearch(Async)");
        }
        
        // verify the required parameter 'standNo' is set
        if (standNo == null) {
            throw new ApiException("Missing the required parameter 'standNo' when calling addressStandSearch(Async)");
        }
        
        
        com.squareup.okhttp.Call call = addressStandSearchCall(cityMunicipality, standNo, portionNo, progressListener, progressRequestListener);
        return call;

        
        
        
        
    }

    /**
     * Search for street address by stand number within a given city / municipality
     * This api call searches for a given stand by stand number within a given city / municipality.  It will return the stand and all street addresses associated with the returned stand.
     * @param cityMunicipality Search for addresses in the given City or Municipality (required)
     * @param standNo Search for addresses with the given Stand Number (required)
     * @param portionNo Search for addresses with the given Portion Number (optional)
     * @return OKResponseAddressStandNo
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public OKResponseAddressStandNo addressStandSearch(String cityMunicipality, String standNo, String portionNo) throws ApiException {
        ApiResponse<OKResponseAddressStandNo> resp = addressStandSearchWithHttpInfo(cityMunicipality, standNo, portionNo);
        return resp.getData();
    }

    /**
     * Search for street address by stand number within a given city / municipality
     * This api call searches for a given stand by stand number within a given city / municipality.  It will return the stand and all street addresses associated with the returned stand.
     * @param cityMunicipality Search for addresses in the given City or Municipality (required)
     * @param standNo Search for addresses with the given Stand Number (required)
     * @param portionNo Search for addresses with the given Portion Number (optional)
     * @return ApiResponse&lt;OKResponseAddressStandNo&gt;
     * @throws ApiException If fail to call the API, e.g. server error or cannot deserialize the response body
     */
    public ApiResponse<OKResponseAddressStandNo> addressStandSearchWithHttpInfo(String cityMunicipality, String standNo, String portionNo) throws ApiException {
        com.squareup.okhttp.Call call = addressStandSearchValidateBeforeCall(cityMunicipality, standNo, portionNo, null, null);
        Type localVarReturnType = new TypeToken<OKResponseAddressStandNo>(){}.getType();
        return apiClient.execute(call, localVarReturnType);
    }

    /**
     * Search for street address by stand number within a given city / municipality (asynchronously)
     * This api call searches for a given stand by stand number within a given city / municipality.  It will return the stand and all street addresses associated with the returned stand.
     * @param cityMunicipality Search for addresses in the given City or Municipality (required)
     * @param standNo Search for addresses with the given Stand Number (required)
     * @param portionNo Search for addresses with the given Portion Number (optional)
     * @param callback The callback to be executed when the API call finishes
     * @return The request call
     * @throws ApiException If fail to process the API call, e.g. serializing the request body object
     */
    public com.squareup.okhttp.Call addressStandSearchAsync(String cityMunicipality, String standNo, String portionNo, final ApiCallback<OKResponseAddressStandNo> callback) throws ApiException {

        ProgressResponseBody.ProgressListener progressListener = null;
        ProgressRequestBody.ProgressRequestListener progressRequestListener = null;

        if (callback != null) {
            progressListener = new ProgressResponseBody.ProgressListener() {
                @Override
                public void update(long bytesRead, long contentLength, boolean done) {
                    callback.onDownloadProgress(bytesRead, contentLength, done);
                }
            };

            progressRequestListener = new ProgressRequestBody.ProgressRequestListener() {
                @Override
                public void onRequestProgress(long bytesWritten, long contentLength, boolean done) {
                    callback.onUploadProgress(bytesWritten, contentLength, done);
                }
            };
        }

        com.squareup.okhttp.Call call = addressStandSearchValidateBeforeCall(cityMunicipality, standNo, portionNo, progressListener, progressRequestListener);
        Type localVarReturnType = new TypeToken<OKResponseAddressStandNo>(){}.getType();
        apiClient.executeAsync(call, localVarReturnType, callback);
        return call;
    }
}
