offlineSelectedFeatures = [];

/*
 * Based on comments by @runanet and @coomsie
 * https://github.com/CloudMade/Leaflet/issues/386
 *
 * Wrapping function is needed to preserve L.Marker.update function
 */
(function () {
	var _old__setPos = L.Marker.prototype._setPos;
	L.Marker.include({
		_updateImg: function (i, a, s) {
			a = L.point(s).divideBy(2)._subtract(L.point(a));
			var transform = '';
			transform += ' translate(' + -a.x + 'px, ' + -a.y + 'px)';
			transform += ' rotate(' + this.options.iconAngle + 'deg)';
			transform += ' translate(' + a.x + 'px, ' + a.y + 'px)';
			i.style[L.DomUtil.TRANSFORM] += transform;
		},

		_getShortestEndDegree: function (startDegrees, endDegrees) {
			var turnAngle = Math.abs(endDegrees - startDegrees);
			var turnAnglePositive = (endDegrees - startDegrees) >= 0;
			if (turnAngle <= 180) return endDegrees;
			var result = startDegrees + (360 - turnAngle) * (turnAnglePositive ? -1 : 1);
			return result;
		},

		setIconAngle: function (iconAngle) {
			// find shortest angle to turn over
			this.options.iconAngle = this._getShortestEndDegree(this.options.iconAngle || 0, iconAngle);
			if (this._map)
				this.update();
		},

		_setPos: function (pos) {
			if (this._icon)
				this._icon.style[L.DomUtil.TRANSFORM] = '';
			if (this._shadow)
				this._shadow.style[L.DomUtil.TRANSFORM] = '';

			_old__setPos.apply(this,[pos]);

			if (this.options.iconAngle) {
				var defaultIcon = new L.Icon.Default();
				var a = this.options.icon.options.iconAnchor || defaultIcon.options.iconAnchor;
				var s = this.options.icon.options.iconSize || defaultIcon.options.iconSize;
				var i;
				if (this._icon) {
					i = this._icon;
					this._updateImg(i, a, s);
				}
				if (this._shadow) {
					if (this.options.icon.options.shadowAnchor)
						a = this.options.icon.options.shadowAnchor;
					s = this.options.icon.options.shadowSize;
					i = this._shadow;
					this._updateImg(i, a, s);
				}
			}
		}
	});
}());

L.BingLayer = L.TileLayer.extend({
	options: {
		subdomains: [0, 1, 2, 3],
		type: 'Aerial',
		attribution: 'Bing',
		culture: ''
	},

	initialize: function (key, options) {
		L.Util.setOptions(this, options);

		this._key = key;
		this._url = null;
		this._providers = [];
		this.metaRequested = false;
	},

	tile2quad: function (x, y, z) {
		var quad = '';
		for (var i = z; i > 0; i--) {
			var digit = 0;
			var mask = 1 << (i - 1);
			if ((x & mask) !== 0) digit += 1;
			if ((y & mask) !== 0) digit += 2;
			quad = quad + digit;
		}
		return quad;
	},

	getTileUrl: function (tilePoint) {
		var zoom = this._getZoomForUrl();
		var subdomains = this.options.subdomains,
			s = this.options.subdomains[Math.abs((tilePoint.x + tilePoint.y) % subdomains.length)];
		return this._url.replace('{subdomain}', s)
				.replace('{quadkey}', this.tile2quad(tilePoint.x, tilePoint.y, zoom))
				.replace('{culture}', this.options.culture);
	},

	loadMetadata: function () {
		if (this.metaRequested) return;
		this.metaRequested = true;
		var _this = this;
		var cbid = '_bing_metadata_' + L.Util.stamp(this);
		window[cbid] = function (meta) {
			window[cbid] = undefined;
			var e = document.getElementById(cbid);
			e.parentNode.removeChild(e);
			if (meta.errorDetails) {
				throw new Error(meta.errorDetails);
				return;
			}
			_this.initMetadata(meta);
		};
		var urlScheme = (document.location.protocol === 'file:') ? 'http' : document.location.protocol.slice(0, -1);
		var url = urlScheme + '://dev.virtualearth.net/REST/v1/Imagery/Metadata/'
					+ this.options.type + '?include=ImageryProviders&jsonp=' + cbid +
					'&key=' + this._key + '&UriScheme=' + urlScheme;
		var script = document.createElement('script');
		script.type = 'text/javascript';
		script.src = url;
		script.id = cbid;
		document.getElementsByTagName('head')[0].appendChild(script);
	},

	initMetadata: function (meta) {
		var r = meta.resourceSets[0].resources[0];
		this.options.subdomains = r.imageUrlSubdomains;
		this._url = r.imageUrl;
		if (r.imageryProviders) {
			for (var i = 0; i < r.imageryProviders.length; i++) {
				var p = r.imageryProviders[i];
				for (var j = 0; j < p.coverageAreas.length; j++) {
					var c = p.coverageAreas[j];
					var coverage = {zoomMin: c.zoomMin, zoomMax: c.zoomMax, active: false};
					var bounds = new L.LatLngBounds(
							new L.LatLng(c.bbox[0]+0.01, c.bbox[1]+0.01),
							new L.LatLng(c.bbox[2]-0.01, c.bbox[3]-0.01)
					);
					coverage.bounds = bounds;
					coverage.attrib = p.attribution;
					this._providers.push(coverage);
				}
			}
		}
		this._update();
	},

	_update: function () {
		if (this._url === null || !this._map) return;
		this._update_attribution();
		L.TileLayer.prototype._update.apply(this, []);
	},

	_update_attribution: function () {
		var bounds = this._map.getBounds();
		var zoom = this._map.getZoom();
		for (var i = 0; i < this._providers.length; i++) {
			var p = this._providers[i];
			if ((zoom <= p.zoomMax && zoom >= p.zoomMin) &&
					bounds.intersects(p.bounds)) {
				if (!p.active && this._map.attributionControl)
					this._map.attributionControl.addAttribution(p.attrib);
				p.active = true;
			} else {
				if (p.active && this._map.attributionControl)
					this._map.attributionControl.removeAttribution(p.attrib);
				p.active = false;
			}
		}
	},

	onAdd: function (map) {
		this.loadMetadata();
		L.TileLayer.prototype.onAdd.apply(this, [map]);
	},

	onRemove: function (map) {
		for (var i = 0; i < this._providers.length; i++) {
			var p = this._providers[i];
			if (p.active && this._map.attributionControl) {
				this._map.attributionControl.removeAttribution(p.attrib);
				p.active = false;
			}
		}
		L.TileLayer.prototype.onRemove.apply(this, [map]);
	}
});

L.bingLayer = function (key, options) {
    return new L.BingLayer(key, options);
};

var map;
var gmap;
var saExtent;
var serial;
var token;
var projection;
var marker;
var resultMarker;
zoomLevel = 17;
var vectorLayer;

var scales = [
    524288000,
    131072000,
    65536000,
    32768000,
    16384000,
    8192000,
    4096000,
    2048000,
    1024000,
    512000,
    256000,
    128000,
    64000,
    32000,
    16000,
    8000,
    4000,
    2000,
    1000,
    500,
    250,
    125,
    63,
    31,
    16,
    8,
    4,
    2,
    1
];

function test() {
    initMap(1001, '03056dc5e2ddf473388b2590f44545de3692c87e');
    addOSMLayer();
    // addWMSLayer(2, 'Test attribution', true, 1, 10000000, 1, '');
    addWMSLayer(1, 'Test attribution', false, 1, 16000, 1, 'erven');  //1map erven
    // addWMSLayer(330, '&copy; <a href="http://www.1map.co.za/copyright" target="_blank">1map Spatial Solutions (Pty) Ltd</a>', false, 1, 100000000, 1.0, 'point');
    zoomToPoint(-33.87701030868317, 18.67643207828828);
    zoomIn();
}

function saveState() {
    var coord = map.getCenter();
    var longitude = coord.lng;
    var latitude = coord.lat;
    Android.setCurrentLongitude(longitude);
    Android.setCurrentLatitude(latitude);

    zoomLevel = map.getZoom();
    Android.setCurrentZoomLevel(zoomLevel);

    var extent = map.getBounds();
    var boundsLeft = extent.getWest();   //minX
    var boundsBottom = extent.getSouth();   //minY
    var boundsRight = extent.getEast();   //maxX
    var boundsTop = extent.getNorth();   //maxY
    Android.setBoundsLeft(boundsLeft);
    Android.setBoundsRight(boundsRight);
    Android.setBoundsTop(boundsTop);
    Android.setBoundsBottom(boundsBottom);

    Android.notifySaveStateCompleted();
}

function addOfflineLayer(tileUrl, maxZoom) {
    L.tileLayer(tileUrl, {
        type: 'base',
        isbase: true,
        drawcache: true,
        attribution: 'Map data &copy; <a href="https://www.1map.co.za">1map</a>',
        maxZoom: maxZoom,
        errorTileUrl: 'NoImageAvailable.png'
    }).addTo(map);
}

function simpleStringify(object){
    var simpleObject = {};
    for (var prop in object ){
        if (!object.hasOwnProperty(prop)){
            continue;
        }
        if (typeof(object[prop]) == 'object'){
            continue;
        }
        if (typeof(object[prop]) == 'function'){
            continue;
        }
        simpleObject[prop] = object[prop];
    }
    return JSON.stringify(simpleObject); // returns cleaned up JSON
};

function addGeoJSONLayer(url) {
    offlineFeatures = [];
    offlineFeaturesCentroids = [];
    offlineModifiedFeatures = [];
    removeModifiedLayer();
    $.ajaxSetup({
        async: false
    });
    $.getJSON(url, function(data) {
        if (data && data.features) {
            var fc = turf.featurecollection(data.features);
            offlineFeatures = fc;
            offlineFeaturesCentroids = [];
            var i = 0;
            fc.features.forEach(function(feature) {
                i++;
                var cPoint = turf.pointOnSurface(feature);
                cPoint.properties = feature.properties;
                cPoint.mainFeature = i;
                feature.centerFeature = i;
                offlineFeaturesCentroids.push(cPoint);
            });
            offlineFeaturesCentroids = turf.featurecollection(offlineFeaturesCentroids);
        }
        $.ajaxSetup({
            async: true
        });
    });
}

function addGoogleLayer(layerType) {
    var mapType = google.maps.MapTypeId.ROADMAP; //default

    if (layerType === 'googlestreet') {
        mapType = google.maps.MapTypeId.ROADMAP;
    }
    else if(layerType === 'googlesatellite') {
        mapType = google.maps.MapTypeId.SATELLITE;
    }
    else if(layerType === 'googlehybrid') {
        mapType = google.maps.MapTypeId.HYBRID;
    }
    else if(layerType === 'googlephysical') {
        mapType = google.maps.MapTypeId.TERRAIN;
    }

    var gmapDiv = document.getElementById('gmap');

    gmap = new google.maps.Map(gmapDiv, {
      disableDefaultUI: true,
      keyboardShortcuts: false,
      draggable: false,
      disableDoubleClickZoom: true,
      scrollwheel: false,
      streetViewControl: false,
      mapTypeId: mapType
    });


    var view = map.getView();
    view.on('change:center', function() {
      var center = ol.proj.transform(view.getCenter(), 'EPSG:900913', 'EPSG:4326');
      gmap.setCenter(new google.maps.LatLng(center[1], center[0]));
    });
    view.on('change:resolution', function() {
      gmap.setZoom(view.getZoom());
    });

    var mapDiv = document.getElementById('map');
    mapDiv.parentNode.removeChild(mapDiv);
    gmap.controls[google.maps.ControlPosition.TOP_LEFT].push(mapDiv);

}

function showMarker(latitude, longitude) {

    var newLatLng = new L.LatLng(latitude, longitude);

    if(marker == null) {
         var RedIcon = L.Icon.Default.extend({
            options: {
            	    iconUrl: 'geolocation_marker_heading.png',
            	    className: 'geolocation_marker' /*,
                    iconSize: [38, 95],
                    iconAnchor: [22, 94],
                    popupAnchor: [-3, -76],
                    shadowSize: [68, 95],
                    shadowAnchor: [22, 94] */
            }
         });
         var redIcon = new RedIcon();
         marker = L.marker(map.getCenter(), {icon: redIcon}).addTo(map);
    }

    marker.setOpacity(1);
    marker.setLatLng(newLatLng);
}

function showResultMarker(latitude, longitude) {

    var newLatLng = new L.LatLng(latitude, longitude);

    if(resultMarker == null) {
         var BlueIcon = L.Icon.Default.extend({
            options: {
            	    iconUrl: 'geolocation_marker.png',
            	    className: 'result_marker' /*,
                    iconSize: [38, 95],
                    iconAnchor: [22, 94],
                    popupAnchor: [-3, -76],
                    shadowSize: [68, 95],
                    shadowAnchor: [22, 94] */
            }
         });
         var blueIcon = new BlueIcon();
         resultMarker = L.marker(map.getCenter(), {icon: blueIcon}).addTo(map);
    }

    resultMarker.setOpacity(1);
    resultMarker.setLatLng(newLatLng);

}


function hideMarker() {
    //Hack
    marker.setOpacity(0);
}

function rotateMarker(deg) {
    if (typeof marker !== "undefined") {
        marker.setIconAngle(deg);
    }
}

function rotateTo(radians) {
        /* var rotateAnimation = ol.animation.rotate({
            duration: 200,
            rotation: map.getView().getRotation()
        });
        map.beforeRender(rotateAnimation);
        map.getView().setRotation(radians); */
}

function initOfflineMap(maxZoom) {
    isOffline = true;
    retriesSetPosition = 0;
    map = new L.Map('map', {
        center: [-28.47960, 24.69845],
        minZoom: 0,
        maxZoom: maxZoom,
        zoom: 5
    });
    map.attributionControl.setPrefix('');
    // Add controls
    L.control.scale().addTo(map);

    map.on('click', function(evt) {
        offlineSelectedFeatures = [];
        if (offlineFeatures && offlineFeaturesCentroids) {
            var coord = evt.latlng;
            var longitude = coord.lng;
            var latitude = coord.lat;
            var point = turf.point([longitude, latitude], {});
            var nearest = turf.nearest(point, offlineFeaturesCentroids);
            if (nearest) {
                var mFIndex = nearest.mainFeature-1;
                offlineSelectedFeatures.push(offlineFeatures.features[mFIndex]);
                var gjs = JSON.stringify(offlineSelectedFeatures);
                Android.offlineFeaturesSelected(gjs);
                // TODO: Multiple feature selection - below is slow
                /* var cPoint = turf.point(nearest.geometry.coordinates, nearest.properties);
                var i=0;
                offlineFeatures.features.forEach(function(feature) {
                    var cIntersect = turf.intersect(cPoint, feature);
                    if (cIntersect && i !== mFIndex) {
                        offlineSelectedFeatures.push(feature);
                    }
                    i++;
                }); */
            }
        }
        if (offlineSelectedFeatures.length !== 1) {
            var gjs = JSON.stringify(offlineSelectedFeatures);
            Android.offlineFeaturesSelected(gjs);
        }
    });

    map.on('moveend', function(e) {
        var center = map.getCenter();
        var zoom = map.getZoom();
        lastZoomLevel = zoom;
        lastPoint = center;
        saveState();
    });

    //the touch event is used to turn off follow me if it is on
    var mapDiv = document.getElementById('map');
    mapDiv.addEventListener('touchstart', function(e) {
        Android.mapTouchStart();
    });

}


function initMap(serial, token) {
    isOffline = false;
    this.serial = serial;
    this.token = token;
    justStarted = true;

    map = new L.Map('map', {
        center: [-28.47960, 24.69845],
        minZoom: 0,
        maxZoom: 30,
        zoom: 5
    });
    map.attributionControl.setPrefix('');
    // Add controls
    L.control.scale().addTo(map);

    //forward map click events to Android
    map.on('click', function(evt) {
        var coord = evt.latlng;
        var longitude = coord.lng;
        var latitude = coord.lat;

        Android.mapClicked(latitude, longitude);
    });

    map.on('moveend', function(e) {
        var center = map.getCenter();
        var zoom = map.getZoom();
        lastZoomLevel = zoom;
        lastPoint = center;
        saveState();
    });

    var mapDiv = document.getElementById('map');
    mapDiv.addEventListener('touchstart', function(e) {
        Android.mapTouchStart();
    });

    setTimeout(map.invalidateSize.bind(map),500);

    return true;
}

function removeAllLayers() {
    map.eachLayer(function (layer) {
        map.removeLayer(layer);
    });
    if(typeof(vectorLayer) !== 'undefined' && vectorLayer !== null) {
        map.removeLayer(vectorLayer);
    }
    if(typeof(modifiedLayer) !== 'undefined' && modifiedLayer !== null) {
        map.removeLayer(modifiedLayer);
    }
    vectorLayer = null;
    modifiedLayer = null;
}

function addWMSLayer(layerId, attributionsHtml, isBaseLayer, minScale, maxScale, opacity, style, drawCache) {

    var baseType = isBaseLayer ? "base" : "other";
    var urlStr = "https://www.1map.co.za/api/v1/spatial/maptile/" + layerId + "/" + baseType;

    if (isBaseLayer !== true) {
        //L.tileLayer.wms("http://www.1map.co.za/mobile/spatial/get/tile", {
        L.tileLayer.wms(urlStr, {
            maxZoom: 30,
            type: 'overlay',
            isbase: false,
            drawcache: drawCache,
            'serial'    : this.serial,                                                                            // serial
            'token'     : this.token,                                      // token
            'layerid'   : layerId,                                                                               // layerid
            'isbaselayer' : isBaseLayer,                                                                         // isbaselayer
            format: 'image/png8',
            version: '1.3.0',
            srs: 'EPSG:3857',
            transparent: true,
            attribution: attributionsHtml,
            tileloadingdelay: 0,
            format_options: 'palette:safe',
            tiled: true,
            opacity: opacity,
            style: style
		}).addTo(map);
    } else {
        //L.tileLayer.wms("http://www.1map.co.za/mobile/spatial/get/tile", {
        L.tileLayer.wms(urlStr, {
            maxZoom: 30,
            type: 'base',
            isbase: true,
            drawcache: true,
            'serial'    : this.serial,                                                                            // serial
            'token'     : this.token,                                      // token
            'layerid'   : layerId,                                                                               // layerid
            'isbaselayer' : isBaseLayer,                                                                         // isbaselayer
            format: 'image/jpeg',
            version: '1.3.0',
            srs: 'EPSG:3857',
            transparent: true,
            attribution: attributionsHtml,
            tileloadingdelay: 0,
            format_options: 'antialias:none;palette:safe',
            tiled:true,
            opacity: opacity,
            style: style
        }).addTo(map);
    }
}

function addTonerLayer() {
    L.tileLayer('https://stamen-tiles-{s}.a.ssl.fastly.net/toner/{z}/{x}/{y}.png', {
      attribution: 'Map tiles by <a href="http://stamen.com">Stamen Design</a>, under <a href="http://creativecommons.org/licenses/by/3.0">CC BY 3.0</a>. Data by <a href="http://openstreetmap.org">OpenStreetMap</a>, under <a href="http://creativecommons.org/licenses/by-sa/3.0">CC BY SA</a>.',
      maxZoom: 30
    }).addTo(map);
}

function addOSMLayer() {
    L.tileLayer('http://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png', {
        attribution: 'Map data &copy; <a href="http://openstreetmap.org">OpenStreetMap</a> contributors',
        maxZoom: 30
    }).addTo(map);
}

function addNGILayer() {
    L.tileLayer("http://{s}.aerial.openstreetmap.org.za/ngi-aerial/{z}/{x}/{y}.jpg", {
        type: 'base',
        isbase: true,
        drawcache: true,
        attribution: 'Tiles &copy; <a href="http://www.ngi.gov.za/">CD:NGI Aerial</a>',
        maxZoom: 30
    }).addTo(map);
}

function addBingLayer(imagerySet) {
    L.BingLayer("Aucj-WlqSW_Ge3gG6w6eRo8C3Fg_2AfSyIEkfM9MC--oNEPoC-KNy2acpjXhNAit", {
        type: imagerySet,
        maxZoom: 30
    }).addTo(map);
}


function zoomToPoint(latitude, longitude) {
    console.log('zoomToPoint');
    zoomLevel = map.getZoom();
    lastZoomLevel = zoomLevel;
    lastPoint = [latitude, longitude];
    //map.setView([latitude, longitude], zoomLevel);
    var newLatLng = new L.LatLng(latitude, longitude);
    console.log('Panning');
    map.panTo(newLatLng);
    console.log('Setting zoom to ' + zoomLevel);
    map.setZoom(zoomLevel);
}

function moveToPoint(latitude, longitude) {
    console.log('moveToPoint');
    var newLatLng = new L.LatLng(latitude, longitude);
    lastZoomLevel = map.getZoom();
    lastPoint = newLatLng;
    map.panTo(newLatLng);
}

function moveToPointAndShowMarker(latitude, longitude) {
    var newLatLng = new L.LatLng(latitude, longitude);
    lastZoomLevel = map.getZoom();
    lastPoint = newLatLng;
    map.panTo(newLatLng);
    if(marker == null) {
         var RedIcon = L.Icon.Default.extend({
            options: {
            	    iconUrl: 'geolocation_marker_heading.png',
            	    className: 'geolocation_marker' /*,
                    iconSize: [38, 95],
                    iconAnchor: [22, 94],
                    popupAnchor: [-3, -76],
                    shadowSize: [68, 95],
                    shadowAnchor: [22, 94] */
            }
         });
         var redIcon = new RedIcon();
         marker = L.marker(map.getCenter(), {icon: redIcon}).addTo(map);
    }

    marker.setOpacity(1);
    marker.setLatLng(newLatLng);
}

function setZoomLevel(newZoomLevel) {
    zoomLevel = newZoomLevel;
    lastZoomLevel = zoomLevel;
    map.setZoom(newZoomLevel);
}

function removeModifiedLayer() {
    if(typeof(modifiedLayer) !== 'undefined' && modifiedLayer !== null) {
        map.removeLayer(modifiedLayer);
    }
    modifiedLayer = null;
}

function addModifiedLayer(geoJsonStr) {
    var geoJson = JSON.parse(geoJsonStr);

    removeModifiedLayer();

    modifiedLayer = L.geoJson(geoJson, {
        style: function(feature) {
            return {
                   width: 3,
                   weight: 3,
                   opacity: 1,
                   color: feature.properties.xxxOfflineModifiedState == 'AddFeature' ? 'blue' : feature.properties.xxxOfflineModifiedState == 'EditFeature' ? 'orange' : feature.properties.xxxOfflineModifiedState == 'MoveFeature' ? 'green' : 'transparent',
                   fillOpacity: 0.1,
                   fillColor: feature.properties.xxxOfflineModifiedState == 'AddFeature' ? 'blue' : feature.properties.xxxOfflineModifiedState == 'EditFeature' ? 'orange' : feature.properties.xxxOfflineModifiedState == 'MoveFeature' ? 'green' : 'transparent'
            };
        },
        pointToLayer: function (feature, latlng) {
            return L.circleMarker(latlng, {
                  radius: 16,
                  width: 3,
                  weight: 3,
                  opacity: 1,
                  color: feature.properties.xxxOfflineModifiedState == 'AddFeature' ? 'blue' : feature.properties.xxxOfflineModifiedState == 'EditFeature' ? 'orange' : feature.properties.xxxOfflineModifiedState == 'MoveFeature' ? 'green' : 'transparent',
                  fillOpacity: 0,
                  fillColor: "transparent"
            });
        }
    }).addTo(map);
}

function removeVectorLayer() {
    if(typeof(vectorLayer) !== 'undefined' && vectorLayer !== null) {
        map.removeLayer(vectorLayer);
    }
    vectorLayer = null;
}

function addVectorLayer(geoJsonStr) {
    var geoJson = JSON.parse(geoJsonStr);

    removeVectorLayer();

    vectorLayer = L.geoJson(geoJson, {
        style: function(feature) {
            return {
                   width: 3,
                   weight: 3,
                   opacity: 1,
                   color: 'red',
                   fillOpacity: 0.1,
                   fillColor: 'red'
            };
        },
        pointToLayer: function (feature, latlng) {
            return L.circleMarker(latlng, {
                  radius: 16,
                  width: 3,
                  weight: 3,
                  opacity: 1,
                  color: "red",
                  fillOpacity: 0,
                  fillColor: "transparent"
            });
        }
    }).addTo(map);
}


/**
* Returns the closest number from a sorted array.
**/
function closest(arr, target) {
    if (!(arr) || arr.length == 0)
        return null;
    if (arr.length == 1)
        return i[0];

    for (var i=1; i<arr.length; i++) {
        // As soon as a number bigger than target is found, return the previous or current
        // number depending on which has smaller difference to the target.
        if (arr[i] > target) {
            var p = arr[i-1];
            var c = arr[i]
            return Math.abs( p-target ) < Math.abs( c-target ) ? p : c;
        }
    }
    // No number in array is bigger so return the last.
    return arr[arr.length-1];
}

/**
* Returns the closest index from a sorted array.
**/
function closestIndex(arr, target) {
    if (!(arr) || arr.length == 0)
        return null;
    if (arr.length == 1)
        return 0;

    for (var i=0; i<arr.length; i++) {
        // As soon as a number smaller than target is found, return the previous or current
        // number depending on which has smaller difference to the target.
        if (arr[i] < target) {
            var p = arr[i-1];
            var c = arr[i];
            
            return Math.abs( p-target ) < Math.abs( c-target ) ? i-1 : i;
        }
    }
    // No number in array is bigger so return the last.
    return arr.length-1;
}

function zoomOut() {

    var currentZoomLevel = map.getZoom();
    var newZoomLevel = currentZoomLevel - 1;
    if (newZoomLevel <= 1) {
        newZoomLevel = 1;
    }

    lastZoomLevel = newZoomLevel;
    map.setZoom(newZoomLevel);
    zoomLevel = newZoomLevel;

}

function zoomIn() {

    var currentZoomLevel = map.getZoom();
    var newZoomLevel = currentZoomLevel + 1;
    if (newZoomLevel >= 30) {
        newZoomLevel = 30;
    }

    lastZoomLevel = newZoomLevel;
    map.setZoom(newZoomLevel);
    zoomLevel = newZoomLevel;

}

function offlineFeatureChanged(editType, featureJson) {
    // editType = NEW, UPDATE, MOVE, DELETE
    var feature = JSON.parse(featureJson);
    feature.properties.xxxOfflineModifiedState = editType;

    if (editType == 'AddFeature') {
        if (offlineFeatures && offlineFeatures.features) {
            var found = false;
            for (var i=0; i<offlineFeatures.features.length; i++) {
                var offlineFeature = offlineFeatures.features[i];
                if (offlineFeature.id == feature.id) {
                    offlineFeatures[i] = feature;

                    var cPoint = turf.pointOnSurface(offlineFeatures[i]);
                    cPoint.properties = offlineFeatures[i].properties;
                    cPoint.mainFeature = i+1;
                    offlineFeatures[i].centerFeature = i+1;
                    offlineFeaturesCentroids[i] = cPoint;

                    found = true;
                    break;
                }
            }
            if (!found) {
                offlineFeatures.features.push(feature);

                var cPoint = turf.pointOnSurface(offlineFeatures[offlineFeatures.length-1]);
                cPoint.properties = offlineFeatures[offlineFeatures.length-1].properties;
                cPoint.mainFeature = offlineFeatures.length;
                offlineFeatures[offlineFeatures.length-1].centerFeature = offlineFeatures.length;
                offlineFeaturesCentroids.push(cPoint);
            }
        }
    } else if (editType == 'DeleteFeature') {
    } else if (editType == 'MOVE') {
        if (offlineFeatures && offlineFeatures.features) {
            for (var i=0; i<offlineFeatures.features.length; i++) {
                var offlineFeature = offlineFeatures.features[i];
                if (offlineFeature.id == feature.id) {
                    offlineFeatures[i] = feature;

                    var cPoint = turf.pointOnSurface(offlineFeatures[i]);
                    cPoint.properties = offlineFeatures[i].properties;
                    cPoint.mainFeature = i+1;
                    offlineFeatures[i].centerFeature = i+1;
                    offlineFeaturesCentroids[i] = cPoint;

                    break;
                }
            }
        }
    } else {
        if (offlineFeatures && offlineFeatures.features) {
            for (var i=0; i<offlineFeatures.features.length; i++) {
                var offlineFeature = offlineFeatures.features[i];
                if (offlineFeature.id == feature.id) {
                    offlineFeatures[i] = feature;
                    break;
                }
            }
        }
    }
    offlineModifiedFeatures.push(feature);
}

function doneLoadingOfflineMap() {
    if (offlineModifiedFeatures.length > 0) {
        offlineModifiedFeatures = JSON.stringify(offlineModifiedFeatures);
        addModifiedLayer(offlineModifiedFeatures);
    }
    setTimeout(function() {
        map.setView(lastPoint, lastZoomLevel);
        $("#loadingMask").fadeOut(1000, function(){
            $(this).remove();
        });
    },200);
}

function doneLoadingOnlineMap() {
    setTimeout(function() {
        if (typeof lastPoint !== "undefined" && typeof lastZoomLevel !== "undefined") {
            retriesSetPosition = 0;
            if (justStarted == true && lastPoint[0] == 0 && lastPoint[1] == 0) {
                justStarted = false;
                lastZoomLevel = 5;
                lastPoint = [-28.47960, 24.69845];
                map.setView(lastPoint, lastZoomLevel);
            } else {
                map.setView(lastPoint, lastZoomLevel);
            }
            $("#loadingMask").fadeOut(1000, function(){
                $(this).remove();
            });
        } else {
            retriesSetPosition++;
            if (retriesSetPosition < 10) {
                doneLoadingOnlineMap();
            }
        }
    },200);
}