var map;
var gmap;
var saExtent;
var serial;
var token;
var projection;
var marker;
var resultMarker;
var zoomLevel = 17;
var vectorLayer;

var scales = [
    524288000,
    131072000,
    65536000,
    32768000,
    16384000,
    8192000,
    4096000,
    2048000,
    1024000,
    512000,
    256000,
    128000,
    64000,
    32000,
    16000,
    8000,
    4000,
    2000,
    1000,
    500,
    250,
    125,
    63,
    31,
    16,
    8,
    4,
    2,
    1
];

function test() {
    initMap(1001, 'bee2701825405deb5d0d949cd0b1d80908671e67');
    // addOSMLayer();
    // addWMSLayer(2, 'Test attribution', true, 1, 10000000, 1, '');
    addWMSLayer(1, 'Test attribution', false, 1, 16000, 1, 'erven');  //1map erven
    // addWMSLayer(330, '&copy; <a href="http://www.1map.co.za/copyright" target="_blank">1map Spatial Solutions (Pty) Ltd</a>', false, 1, 100000000, 1.0, 'point');
    zoomToPoint(-25.808611, 28.256111);
}

function saveState() {
    var coord = ol.proj.transform(map.getView().getCenter(), 'EPSG:900913', 'EPSG:4326');
    var longitude = coord[0];
    var latitude = coord[1];
    Android.setCurrentLongitude(longitude);
    Android.setCurrentLatitude(latitude);

    var zoomLevel = map.getView().getZoom();
    Android.setCurrentZoomLevel(zoomLevel);

    var extent = map.getView().calculateExtent(map.getSize());
    extent = ol.proj.transformExtent(extent, 'EPSG:900913', 'EPSG:4326');
    var boundsLeft = extent[0];   //minX
    var boundsBottom = extent[1];   //minY
    var boundsRight = extent[2];   //maxX
    var boundsTop = extent[3];   //maxY
    Android.setBoundsLeft(boundsLeft);
    Android.setBoundsRight(boundsRight);
    Android.setBoundsTop(boundsTop);
    Android.setBoundsBottom(boundsBottom);

    Android.notifySaveStateCompleted();
}

function addOfflineLayer(tileUrl) {
    var offlineLayer = new ol.layer.Tile({
        type: 'base',
        isbase: true,
        drawcache: true,
        source: new ol.source.XYZ({
            attributions: [
        	    new ol.Attribution({
        		    html: '1Map'
        		})
        	],
            url: tileUrl,
            wrapX: false
        })
    });

    map.addLayer(offlineLayer);
}

function addGeoJSONLayer(url) {
    var circleStyle = new ol.style.Circle({
        radius: 10,
        /*
        fill: new ol.style.Fill({
          color: '#0000ff',
          opacity: 0.6
        }),
        */
        stroke: new ol.style.Stroke({
          color: '#0000ff',
          opacity: 0.8,
          width: 2
        })
    });

    var selectedCircleStyle = new ol.style.Circle({
        radius: 10,
        fill: new ol.style.Fill({
          color: '#0000ff',
          opacity: 0.6
        }),
        stroke: new ol.style.Stroke({
          color: '#0000ff',
          opacity: 1.0,
          width: 4
        })
    });

    var pointStyle = new ol.style.Style({
        image: circleStyle
    });

    var selectedPointStyle = new ol.style.Style({
        image: selectedCircleStyle
    });


    var vectorLayer = new ol.layer.Vector({
        name: 'Active Layer',
        style: pointStyle,
        source: new ol.source.Vector({
            url: url,
            format: new ol.format.GeoJSON()
        })
    });

    map.addLayer(vectorLayer);

    var selectInteraction = new ol.interaction.Select({
        layers: [vectorLayer],
        style: selectedPointStyle
    });


    selectInteraction.getFeatures().on('change:length', function(e) {

        var features = [];

        //TODO send all features that was selected
        //for(c = 0; c < e.target.getLength(); c++) {
        for(c = 0; c < 1; c++) {
            var feature = e.target.item(c);

            var format = new ol.format.GeoJSON();
            //var gjs = format.writeFeature(feature);
            var geoObj = format.writeFeatureObject(feature);

            features.push(geoObj);

        }

        var gjs = JSON.stringify(features);

        Android.offlineFeaturesSelected(gjs);

    });

    map.addInteraction(selectInteraction);
}

function addGoogleLayer(layerType) {
    var mapType = google.maps.MapTypeId.ROADMAP; //default

    if (layerType === 'googlestreet') {
        mapType = google.maps.MapTypeId.ROADMAP;
    }
    else if(layerType === 'googlesatellite') {
        mapType = google.maps.MapTypeId.SATELLITE;
    }
    else if(layerType === 'googlehybrid') {
        mapType = google.maps.MapTypeId.HYBRID;
    }
    else if(layerType === 'googlephysical') {
        mapType = google.maps.MapTypeId.TERRAIN;
    }

    var gmapDiv = document.getElementById('gmap');

    gmap = new google.maps.Map(gmapDiv, {
      disableDefaultUI: true,
      keyboardShortcuts: false,
      draggable: false,
      disableDoubleClickZoom: true,
      scrollwheel: false,
      streetViewControl: false,
      mapTypeId: mapType
    });


    var view = map.getView();
    view.on('change:center', function() {
      var center = ol.proj.transform(view.getCenter(), 'EPSG:900913', 'EPSG:4326');
      gmap.setCenter(new google.maps.LatLng(center[1], center[0]));
    });
    view.on('change:resolution', function() {
      gmap.setZoom(view.getZoom());
    });

    var mapDiv = document.getElementById('map');
    mapDiv.parentNode.removeChild(mapDiv);
    gmap.controls[google.maps.ControlPosition.TOP_LEFT].push(mapDiv);

}

function showMarker(latitude, longitude) {

    if(marker == null) {
        var markerEl = document.getElementById('geolocation_marker');
        marker = new ol.Overlay({
          positioning: 'center-center',
          element: markerEl,
          stopEvent: true
        });
        map.addOverlay(marker);
    }

    var coord = ol.proj.transform([longitude, latitude], 'EPSG:4326', 'EPSG:900913');
    marker.setPosition(coord);

}

function showResultMarker(latitude, longitude) {

    if(resultMarker == null) {
        var markerEl = document.getElementById('result_marker');
        resultMarker = new ol.Overlay({
          positioning: 'center-center',
          element: markerEl,
          stopEvent: false
        });
        map.addOverlay(resultMarker);
    }

    var coord = ol.proj.transform([longitude, latitude], 'EPSG:4326', 'EPSG:900913');
    resultMarker.setPosition(coord);

}


function hideMarker() {
    //Hack
    var coord = ol.proj.transform([0, 0], 'EPSG:4326', 'EPSG:900913');
    marker.setPosition(coord);

}

function rotateMarker(deg) {
    var div = document.getElementById('geolocation_marker');

    div.style.webkitTransform = 'rotate('+deg+'deg)';
    div.style.mozTransform    = 'rotate('+deg+'deg)';
    div.style.msTransform     = 'rotate('+deg+'deg)';
    div.style.oTransform      = 'rotate('+deg+'deg)';
    div.style.transform       = 'rotate('+deg+'deg)';

}

function rotateTo(radians) {
        var rotateAnimation = ol.animation.rotate({
            duration: 200,
            rotation: map.getView().getRotation()
        });
        map.beforeRender(rotateAnimation);
        map.getView().setRotation(radians);
}

function initOfflineMap() {
    projection = new ol.proj.Projection({
          code: 'EPSG:900913',
          units: 'm'
    });
    ol.proj.addProjection(projection);

    var mapView = new ol.View({
        center: ol.proj.transform([18.41970, -33.92212], 'EPSG:4326', 'EPSG:900913'),
        zoom: 17
    });

    map = new ol.Map({
        target: 'map',
        layers: [],
        view: mapView,
        controls: []
    });

    //the touch event is used to turn off follow me if it is on
    var mapDiv = document.getElementById('map');
    mapDiv.addEventListener('touchstart', function(e) {
        Android.mapTouchStart();
    });


}


function initMap(serial, token) {
    this.serial = serial;
    this.token = token;

    projection = new ol.proj.Projection({
          code: 'EPSG:900913',
          units: 'm'
    });
    ol.proj.addProjection(projection);

    saExtent = ol.proj.transform([15.3, -35.16, 35.4, -21.2], 'EPSG:4326', 'EPSG:900913');

    if (typeof goog !== "undefined") {
        var mapView = new ol.View({
            center: ol.proj.transform([18.41970, -33.92212], 'EPSG:4326', 'EPSG:900913'),
            zoom: 17
        });

        /* Inherits from ol.Map to override handleTileChange_ and intercept number of pending tiles */
        var QMapClass = function(options) {
            goog.base(this, options);
        };
    	goog.inherits(QMapClass, ol.Map);

        ol.TileCache.prototype.expireCache = function(usedTiles) {
            var tile,
                zKey;
            while (this.canExpireCache()) {
                tile = /** @type {ol.Tile} */(this.peekLast());
                zKey = tile.tileCoord[0].toString();
                if (usedTiles && zKey in usedTiles && usedTiles[zKey].contains(tile.tileCoord)) {
                    break;
                } else {
                    var disposetile = this.pop();
                    try {
                        disposetile.dispose();
                    } catch (e) {
                    }
                }
            }
        };

        QMapClass.prototype.handleTileChange_ = function(handleTileChange_) {
            var pendingTiles = this.tileQueue_.tilesLoading_;
            this.render();
        };

        map = new QMapClass({
            target: 'map',
            layers: [ ],
            view: mapView,
            controls: []
        });

        var scaleControl = new ol.control.ScaleLine();
        map.addControl(scaleControl);

        var rotateControl = new ol.control.Rotate();
        map.addControl(rotateControl);

        var attribControl = new ol.control.Attribution();
        map.addControl(attribControl);

        //forward map click events to Android
        map.on('singleclick', function(evt) {
            var coord = ol.proj.transform(evt.coordinate, 'EPSG:900913', 'EPSG:4326');
            var longitude = coord[0];
            var latitude = coord[1];

            Android.mapClicked(latitude, longitude);
        });

    };


    var mapDiv = document.getElementById('map');
    mapDiv.addEventListener('touchstart', function(e) {
        Android.mapTouchStart();
    });

}

function removeAllLayers() {
    var layers = map.getLayers();
    var i;
    var noOfLayers = layers.getLength();
    for(i = 0; i < noOfLayers; i++) {
        var layer = layers.item(i);
        map.removeLayer(layer);
    }

}

function addWMSLayer(layerId, attributionsHtml, isBaseLayer, minScale, maxScale, opacity, style, drawCache) {
    var wmsSource = new ol.source.TileWMS({
        url             : 'http://www.1map.co.za/mobile/spatial/get/tile',                                 // Base URL
        attributions    : [new ol.Attribution({html: attributionsHtml})],    // attributions
        projection      : map.getView().getProjection(),
        params: {
            'serial'    : this.serial,                                                                            // serial
            'token'     : this.token,                                      // token
            'layerid'   : layerId,                                                                               // layerid
            'isbaselayer' : isBaseLayer                                                                         // isbaselayer

        },
        hidpi           : false,
        //// crossOrigin : 'anonymous',
        wrapX: false
    });

    var tileGrid = wmsSource.getTileGrid();
    var cResol = map.getView().maxResolution_;
    var resolutions = [];
    for (var i=0; i<=28; i++) {
        resolutions.push(cResol);
        cResol = cResol / 2;
    }

    var closestMinScaleIndex = closestIndex(scales, minScale);
    var closestMaxScaleIndex = closestIndex(scales, maxScale);
    var minResolution = resolutions[closestMinScaleIndex];
    var maxResolution = resolutions[closestMaxScaleIndex];
    var wmsLayer;

    if (isBaseLayer !== true) {
        wmsLayer = new ol.layer.Tile({
            source              : wmsSource,
            minResolution       : minResolution,
            maxResolution       : maxResolution,
            type                : 'overlay',
            isbase              : isBaseLayer,
            drawcache           : drawCache,
            visible             : true,                                                                             // visibility
            opacity             : opacity                                                                                 // opacity
        });
    } else {
        wmsLayer = new ol.layer.Tile({
            source              : wmsSource,
            type                : 'base',
            isbase              : isBaseLayer,
            drawcache           : drawCache,
            visible             : true,                                                                             // visibility
            opacity             : opacity                                                                                 // opacity
        });
    }

    if (isBaseLayer == false && drawCache == false) {
        var source = wmsLayer.getSource();
        if (typeof source.tileCache !== "undefined") {
            source.tileCache.highWaterMark_ = 0;
            source.oldTileUrlFunction = source.getTileUrlFunction();
            source.setTileUrlFunction(
                function (tileCoord, pixelRatio, projection) {

                    var tileGrid = this.getTileGrid();
                    if (goog.isNull(tileGrid)) {
                        tileGrid = this.getTileGridForProjection(projection);
                    }

                    if (tileGrid.getResolutions().length <= tileCoord[0]) {
                        return undefined;
                    }

                    if (pixelRatio != 1 && (!this.hidpi_ || !goog.isDef(this.serverType_))) {
                        pixelRatio = 1;
                    }

                    var tileResolution = tileGrid.getResolution(tileCoord[0]);
                    var tileExtent = tileGrid.getTileCoordExtent(
                            tileCoord, this.tmpExtent_);
                    var tileSize = tileGrid.getTileSize(tileCoord[0]);

                    var gutter = this.gutter_;
                    if (gutter !== 0) {
                        tileSize += 2 * gutter;
                        tileExtent = ol.extent.buffer(tileExtent,
                                tileResolution * gutter, tileExtent);
                    }

                    if (pixelRatio != 1) {
                        tileSize = (tileSize * pixelRatio + 0.5) | 0;
                    }

                    var baseParams = {
                        'RANDOM': Math.random()
                    };
                    goog.object.extend(baseParams, this.params_);

                    return this.getRequestUrl_(tileCoord, tileSize, tileExtent,
                            pixelRatio, projection, baseParams);
                }
            );
            source.newTileUrlFunction = source.getTileUrlFunction();
        }
    }

    //1 to 500

    map.addLayer(wmsLayer);
    //currentLayer = wmsLayer;

}

function addOSMLayer() {
    var osmLayer = new ol.layer.Tile({
        type: 'base',
        isbase: true,
        drawcache: true,
        source: new ol.source.OSM({
            wrapX: false
        })
    });

    map.addLayer(osmLayer);
}

function addNGILayer() {
    var ngiLayer = new ol.layer.Tile({
        type: 'base',
        isbase: true,
        drawcache: true,
        source: new ol.source.XYZ({
            attributions: [
        	    new ol.Attribution({
        		    html: 'Tiles &copy; <a href="http://www.ngi.gov.za/">CD:NGI Aerial</a>'
        		})
        	],
            urls: [
                    "http://a.aerial.openstreetmap.org.za/ngi-aerial/{z}/{x}/{y}.jpg",
                    "http://b.aerial.openstreetmap.org.za/ngi-aerial/{z}/{x}/{y}.jpg",
                    "http://c.aerial.openstreetmap.org.za/ngi-aerial/{z}/{x}/{y}.jpg"
        	],
            wrapX: false
        })
    });

    map.addLayer(ngiLayer);
}

function addBingLayer(imagerySet) {
    var bingLayer = new ol.layer.Tile({
        type: 'base',
        isbase: true,
        drawcache: true,
        source: new ol.source.BingMaps({
            key: 'Aucj-WlqSW_Ge3gG6w6eRo8C3Fg_2AfSyIEkfM9MC--oNEPoC-KNy2acpjXhNAit',
            imagerySet: imagerySet,
            maxZoom: 19
        })
    });

    map.addLayer(bingLayer);
}


function zoomToPoint(latitude, longitude) {
    var coord = ol.proj.transform([longitude, latitude], 'EPSG:4326', 'EPSG:900913');
    var view = map.getView();
    view.setCenter(coord);

    var zoom = ol.animation.zoom({
      resolution: map.getView().getResolution()
    });
    map.beforeRender(zoom);
    view.setZoom(zoomLevel);
}

function moveToPoint(latitude, longitude) {
    var coord = ol.proj.transform([longitude, latitude], 'EPSG:4326', 'EPSG:900913');
    var view = map.getView();
    view.setCenter(coord);
}

function moveToPointAndShowMarker(latitude, longitude) {
    var coord = ol.proj.transform([longitude, latitude], 'EPSG:4326', 'EPSG:900913');
    var view = map.getView();
    view.setCenter(coord);

    if(marker == null) {
        var markerEl = document.getElementById('geolocation_marker');
        marker = new ol.Overlay({
          positioning: 'center-center',
          element: markerEl,
          stopEvent: true
        });
        map.addOverlay(marker);
    }
    marker.setPosition(coord);
}

function setZoomLevel(newZoomLevel) {
    zoomLevel = newZoomLevel;
}

function removeVectorLayer() {
    if(vectorLayer != null) {
        map.removeLayer(vectorLayer);
    }
}

function addVectorLayer(geoJsonStr) {
    var geoJson = JSON.parse(geoJsonStr);
    
    var image = new ol.style.Circle({
      radius: 20,
      fill: null,
      stroke: new ol.style.Stroke({color: 'red', width: 3})
    });

    var styles = {
      'Point': [new ol.style.Style({
        image: image
      })],
      'LineString': [new ol.style.Style({
        stroke: new ol.style.Stroke({
          color: 'red',
          width: 3
        })
      })],
      'MultiLineString': [new ol.style.Style({
        stroke: new ol.style.Stroke({
          color: 'red',
          width: 3
        })
      })],
      'MultiPoint': [new ol.style.Style({
        image: image
      })],
      'MultiPolygon': [new ol.style.Style({
        stroke: new ol.style.Stroke({
          color: 'red',
          width: 3
        }),
        fill: new ol.style.Fill({
          color: 'rgba(255, 255, 0, 0.1)'
        })
      })],
      'Polygon': [new ol.style.Style({
        stroke: new ol.style.Stroke({
          color: 'red',
          lineDash: [4],
          width: 3
        }),
        fill: new ol.style.Fill({
          color: 'rgba(0, 0, 255, 0.1)'
        })
      })],
      'GeometryCollection': [new ol.style.Style({
        stroke: new ol.style.Stroke({
          color: 'red',
          width: 3
        }),
        fill: new ol.style.Fill({
          color: 'magenta'
        }),
        image: new ol.style.Circle({
          radius: 10,
          fill: null,
          stroke: new ol.style.Stroke({
            color: 'red'
          })
        })
      })],
      'Circle': [new ol.style.Style({
        stroke: new ol.style.Stroke({
          color: 'red',
          width: 2
        }),
        fill: new ol.style.Fill({
          color: 'rgba(255,0,0,0.2)'
        })
      })]
    };

    var styleFunction = function(feature, resolution) {
      return styles[feature.getGeometry().getType()];
    };    
    
    var vectorSource = new ol.source.Vector({
    });
	vectorSource.addFeatures((new ol.format.GeoJSON()).readFeatures(geoJson, {dataProjection: "EPSG:4326", featureProjection: "EPSG:900913"}));

    if(vectorLayer != null) {
        map.removeLayer(vectorLayer);
    }
    
    vectorLayer = new ol.layer.Vector({  
      source: vectorSource,
      style: styleFunction
    });
    
    
    map.addLayer(vectorLayer);
    
}


/**
* Returns the closest number from a sorted array.
**/
function closest(arr, target) {
    if (!(arr) || arr.length == 0)
        return null;
    if (arr.length == 1)
        return i[0];

    for (var i=1; i<arr.length; i++) {
        // As soon as a number bigger than target is found, return the previous or current
        // number depending on which has smaller difference to the target.
        if (arr[i] > target) {
            var p = arr[i-1];
            var c = arr[i]
            return Math.abs( p-target ) < Math.abs( c-target ) ? p : c;
        }
    }
    // No number in array is bigger so return the last.
    return arr[arr.length-1];
}

/**
* Returns the closest index from a sorted array.
**/
function closestIndex(arr, target) {
    if (!(arr) || arr.length == 0)
        return null;
    if (arr.length == 1)
        return 0;

    for (var i=0; i<arr.length; i++) {
        // As soon as a number smaller than target is found, return the previous or current
        // number depending on which has smaller difference to the target.
        if (arr[i] < target) {
            var p = arr[i-1];
            var c = arr[i];
            
            return Math.abs( p-target ) < Math.abs( c-target ) ? i-1 : i;
        }
    }
    // No number in array is bigger so return the last.
    return arr.length-1;
}

function zoomOut() {

    var currentZoomLevel = map.getView().getZoom();
    var newZoomLevel = currentZoomLevel - 1;
    if (newZoomLevel <= 1) {
        newZoomLevel = 1;
    }

    var zoom = ol.animation.zoom({
      duration: 200,
      resolution: map.getView().getResolution()
    });
    map.beforeRender(zoom);

    map.getView().setZoom(newZoomLevel);
    zoomLevel = newZoomLevel;

}

function zoomIn() {

    var currentZoomLevel = map.getView().getZoom();
    var newZoomLevel = currentZoomLevel + 1;
    if (newZoomLevel >= 30) {
        newZoomLevel = 30;
    }

    var zoom = ol.animation.zoom({
      duration: 200,
      resolution: map.getView().getResolution()
    });
    map.beforeRender(zoom);

    map.getView().setZoom(newZoomLevel);
    zoomLevel = newZoomLevel;

}