var map;
var projection;
var zoomLevel = 17;


function initMap() {
    console.log('Init map');

    projection = new ol.proj.Projection({
          code: 'EPSG:900913',
          units: 'm'
    });
    ol.proj.addProjection(projection);            

    var mapView = new ol.View({
        center: ol.proj.transform([18.41970, -33.92212], 'EPSG:4326', 'EPSG:900913'),
        zoom: 17
    });

    map = new ol.Map({
        target: 'map',
        layers: [],
        view: mapView,
        controls: []
    });

}



function addOfflineLayer(tileUrl) {
    console.log('Add Offline layer');

    var offlineLayer = new ol.layer.Tile({
        type: 'base',
        isbase: true,
        drawcache: true,
        source: new ol.source.XYZ({
            attributions: [
        	    new ol.Attribution({
        		    html: '1Map'
        		})
        	],
            url: tileUrl,
            wrapX: false
        })
    });

    map.addLayer(offlineLayer);
}


function zoomToPoint(latitude, longitude) {
    console.log('Zoom to point ' + latitude + ', ' + longitude);
    var coord = ol.proj.transform([longitude, latitude], 'EPSG:4326', 'EPSG:900913');
    var view = map.getView();
    view.setCenter(coord);            

    var zoom = ol.animation.zoom({
      resolution: map.getView().getResolution()
    });
    map.beforeRender(zoom);            
    view.setZoom(zoomLevel);
}

function moveToPoint(latitude, longitude) {
    console.log('Move to point ' + latitude + ', ' + longitude);
    var coord = ol.proj.transform([longitude, latitude], 'EPSG:4326', 'EPSG:900913');
    var view = map.getView();
    view.setCenter(coord);            
}

function setZoomLevel(newZoomLevel) {
    console.log('Set zoom level to ' + newZoomLevel);
    zoomLevel = newZoomLevel;
}
