package org.quidity.demo.util;

import android.util.Log;

import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.protocol.HTTP;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;

import org.quidity.demo.mapi.StatusCode;


/**
 * Created by ferdiedanzfuss on 2014/09/01.
 */
public class HttpUtil {

    public interface DownloadProgressListener {
        public void downloadProgress(double percentage);
    }


    public static HttpUtilResponse httpGet(String url){
        HttpUtilResponse huResponse = new HttpUtilResponse();
        InputStream is = null;

        // HTTP
        try {
            HttpClient httpclient = new DefaultHttpClient(); // for port 80 requests!
            HttpGet httpget = new HttpGet(url);
            //HttpPost httppost = new HttpPost(url);

            HttpResponse response = httpclient.execute(httpget);
            huResponse.statusCode = response.getStatusLine().getStatusCode();
            huResponse.statusMessage = response.getStatusLine().getReasonPhrase();
            String logMessage = "HTTP status " + huResponse.statusCode + " - " + huResponse.statusMessage;
            Log.w(HttpUtil.class.getCanonicalName(), logMessage);

            HttpEntity entity = response.getEntity();
            if (entity == null) return huResponse;

            is = entity.getContent();

            String str = IOUtils.toString(is, "utf-8");
            /*
            BufferedReader reader = new BufferedReader(new InputStreamReader(is,"utf-8"),8);
            StringBuilder sb = new StringBuilder();
            String line = null;
            while ((line = reader.readLine()) != null) {
                sb.append(line + "\n");
            }
            is.close();
            String str = sb.toString();
            */
            huResponse.content = str;
        } catch(Exception e) {
            Log.e(HttpUtil.class.getCanonicalName(), e.getLocalizedMessage(), e);
            huResponse.statusCode = StatusCode.CLIENT_ERROR;
            huResponse.statusMessage = e.getLocalizedMessage();
        }

        return huResponse;

    }

    public static HttpUtilResponse httpPost(String url, HttpEntity requestEntity){

        HttpUtilResponse huResponse = new HttpUtilResponse();
        InputStream is = null;

        // HTTP
        try {
            HttpClient httpclient = new DefaultHttpClient(); // for port 80 requests!
            //HttpGet httpget = new HttpGet(url);
            HttpPost httppost = new HttpPost(url);
            httppost.setEntity(requestEntity);

            HttpResponse response = httpclient.execute(httppost);
            huResponse.statusCode = response.getStatusLine().getStatusCode();
            huResponse.statusMessage = response.getStatusLine().getReasonPhrase();
            String logMessage = "HTTP status " + huResponse.statusCode + " - " + huResponse.statusMessage;
            Log.w(HttpUtil.class.getCanonicalName(), logMessage);

            HttpEntity entity = response.getEntity();
            if (entity == null) return huResponse;

            is = entity.getContent();

            String str = IOUtils.toString(is, "utf-8");
            huResponse.content = str;
        } catch(Exception e) {
            Log.e(HttpUtil.class.getCanonicalName(), e.getLocalizedMessage(), e);
            huResponse.statusCode = StatusCode.CLIENT_ERROR;
            huResponse.statusMessage = e.getLocalizedMessage();
        }

        return huResponse;

    }


    public static HttpUtilResponse httpDownload(String url, String savePath, final DownloadProgressListener listener){
        HttpUtilResponse huResponse = new HttpUtilResponse();
        InputStream is = null;
        BufferedOutputStream bos = null;

        // HTTP
        try {
            HttpClient httpclient = new DefaultHttpClient(); // for port 80 requests!
            HttpGet httpget = new HttpGet(url);

            HttpResponse response = httpclient.execute(httpget);
            huResponse.statusCode = response.getStatusLine().getStatusCode();
            huResponse.statusMessage = response.getStatusLine().getReasonPhrase();
            String logMessage = "HTTP status " + huResponse.statusCode + " - " + huResponse.statusMessage;
            Log.w(HttpUtil.class.getCanonicalName(), logMessage);

            HttpEntity entity = response.getEntity();
            if (entity == null) return huResponse;

            is = entity.getContent();

            long totalLength = entity.getContentLength();
            Log.d(HttpUtil.class.getCanonicalName(), "Content length: " + totalLength);

            bos = new BufferedOutputStream(new FileOutputStream(savePath));
            byte[] buffer = new byte[8 * 1024];
            int numBytesRead = 0;
            int downloadedBytes = 0;
            while((numBytesRead = is.read(buffer)) > 0) {
                bos.write(buffer, 0, numBytesRead);
                downloadedBytes += numBytesRead;

                if (listener != null) {
                    double progress = ((double)downloadedBytes / (double)totalLength) * 100.0;
                    listener.downloadProgress(progress);
                }
            }

            bos.flush();

            //int noOfBytes = IOUtils.copy(is, fos);
            //Log.d(HttpUtil.class.getCanonicalName(), "No of bytes saved: " + noOfBytes);

        } catch(Exception e) {
            Log.e(HttpUtil.class.getCanonicalName(), e.getLocalizedMessage(), e);
            huResponse.statusCode = StatusCode.CLIENT_ERROR;
            huResponse.statusMessage = e.getLocalizedMessage();
        }
        finally {
            IOUtils.closeQuietly(bos);
            IOUtils.closeQuietly(is);
        }

        return huResponse;

    }

    public static String getReasonMessage(int statusCode, String statusMessage) {
        String reasonMessage = statusMessage + " (" + statusCode + ")";
        return reasonMessage;
    }
}
