package org.quidity.demo.util;

import android.app.Activity;
import android.content.Context;
import android.content.pm.PackageManager;
import android.util.Log;
import android.view.WindowManager;
import android.webkit.MimeTypeMap;

import com.google.android.gms.analytics.HitBuilders;
import com.google.android.gms.analytics.Tracker;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;

import org.quidity.demo.OneMapApplication;
import org.quidity.demo.Session;
import org.quidity.demo.Settings;
import org.quidity.demo.mapi.attributes.Feature;
import org.quidity.demo.mapi.params.Layer;

/**
 * Created by ferdiedanzfuss on 2014/08/22.
 */
public class AppUtil {

    public static String readAsset(Context context, String assetFile) {
        String response = "";
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(
                    new InputStreamReader(context.getAssets().open(assetFile)));

            String line = reader.readLine();
            while (line != null) {
                response += "\n" + line;
                line = reader.readLine();
            }
        } catch (IOException e) {
            Log.e(AppUtil.class.getCanonicalName(), e.getLocalizedMessage(), e);
        } finally {
            if (reader != null) {
                try {
                    reader.close();
                } catch (IOException e) {
                    //ignore the exception
                }
            }
        }
        return response;
    }

    public static void initActivity(Activity activity) {

        Settings settings = Settings.getSettings(activity);
        Session session = Session.getSession();

        //lock device orientation
        //noinspection ResourceType
        activity.setRequestedOrientation(session.getOrientation());

        //keep screen on
        if (settings.isKeepScreenOn()) {
            activity.getWindow().addFlags(WindowManager.LayoutParams.FLAG_KEEP_SCREEN_ON);
        }
        else {
            activity.getWindow().clearFlags(WindowManager.LayoutParams.FLAG_KEEP_SCREEN_ON);
        }

        //Google Analytics log screen view
        Tracker tracker = ((OneMapApplication)activity.getApplication()).getTracker();
        //tracker.setScreenName(activity.getTitle().toString());
        //tracker.send(new HitBuilders.AppViewBuilder().build());

    }

    // helper function to check if an app is installed
    public static boolean isAppInstalled(Context context, String uri) {
        PackageManager pm = context.getPackageManager();
        boolean app_installed = false;
        try {
            pm.getPackageInfo(uri, PackageManager.GET_ACTIVITIES);
            app_installed = true;
        } catch (PackageManager.NameNotFoundException e) {
            app_installed = false;
        }
        return app_installed;
    }

    public static String pathForAttachment(Context context, long attachmentId, String mimeType) {
        String extension = MimeTypeMap.getSingleton().getExtensionFromMimeType(mimeType);
        if (extension == null) extension = "unknown";
        String filename = "Attachment_" + attachmentId + "." + extension;
        File file = new File(context.getCacheDir(), filename);
        return file.getAbsolutePath();
    }

    public static long getPrimaryIdForSelectedFeature() {
        Session session = Session.getSession();
        Layer layer = session.getCurrentActiveLayer();
        Feature feature = session.getSelectedFeatures().get(session.getSelectedFeatureIndex());

        String primaryField = layer.getPrimaryField();

        String primaryIdStr = (String)feature.getProperties().get(primaryField);
        long primaryId = Long.parseLong(primaryIdStr);

        return primaryId;
    }

    public static double dms2dd(int degrees, int minutes, int seconds) {
        double dDegress = (double)degrees;
        double dMinutes = (double)minutes;
        double dSeconds = (double)seconds;

        double dd = dDegress + (dMinutes/60) + (dSeconds/3600);
        return dd;
    }
}
