package org.quidity.demo.mapi.tracking;

import android.location.Location;
import android.os.AsyncTask;
import android.os.Build;
import android.util.Log;

import com.google.gson.Gson;

import org.apache.http.NameValuePair;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.message.BasicNameValuePair;
import org.quidity.demo.Settings;
import org.quidity.demo.mapi.StatusCode;
import org.quidity.demo.mapi.attributes.Geometry;
import org.quidity.demo.mapi.spatial.UpdateFeatureRequest;
import org.quidity.demo.mapi.spatial.UpdateFeatureResponse;
import org.quidity.demo.util.HttpUtil;
import org.quidity.demo.util.HttpUtilResponse;

import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * Created by ferdiedanzfuss on 14/12/15.
 */
public class TrackingService {

    public interface AddTrackListener {
        public void addTrackCompleted(AddTrackResponse response);
        public void addTrackFailed(String reason);
    }

    public void addTrack(AddTrackRequest request, Location location, AddTrackListener listener) {

        AddTrackTask task = new AddTrackTask(request, location, listener);
        task.execute();

    }

    private class AddTrackTask extends AsyncTask<Void, Void, HttpUtilResponse> {

        private AddTrackListener listener;
        private AddTrackRequest request;
        private Location location;

        public AddTrackTask(AddTrackRequest request, Location location, AddTrackListener listener) {
            this.listener = listener;
            this.location = location;
            this.request = request;
        }

        @Override
        protected HttpUtilResponse doInBackground(Void... voids) {
            HttpUtilResponse response = null;

            try {
                Gson gson = new Gson();
                String sReq = gson.toJson(request);
                Log.d(TrackingService.class.getCanonicalName(), sReq);

                String urlStr = Settings.MAPI_TRACKING_URL + "/add/track?json=" + URLEncoder.encode(sReq, "UTF-8");
                Log.d(TrackingService.class.getCanonicalName(), urlStr);

                List<NameValuePair> parameters = new ArrayList<NameValuePair>();

                parameters.add(new BasicNameValuePair("lon", Double.toString(location.getLongitude())));
                parameters.add(new BasicNameValuePair("lat", Double.toString(location.getLatitude())));
                if (location.hasAltitude()) {
                    parameters.add(new BasicNameValuePair("alt", Double.toString(location.getAltitude())));
                }
                if (location.hasBearing()) {
                    parameters.add(new BasicNameValuePair("bearing", Float.toString(location.getBearing())));
                }
                if (location.hasAccuracy()) {
                    parameters.add(new BasicNameValuePair("accuracy", Float.toString(location.getAccuracy())));
                }
                if (location.hasSpeed()) {
                    parameters.add(new BasicNameValuePair("speed", Float.toString(location.getSpeed())));
                }
                parameters.add(new BasicNameValuePair("device_name", getDeviceName()));
                parameters.add(new BasicNameValuePair("device_time", formatTime(location.getTime())));

                UrlEncodedFormEntity entity = new UrlEncodedFormEntity(parameters);

                response = HttpUtil.httpPost(urlStr, entity);
            }
            catch(Exception e) {
                Log.e(TrackingService.class.getCanonicalName(), e.getLocalizedMessage(), e);
            }

            return response;
        }

        private String getDeviceName() {
            return Build.MANUFACTURER + " " + Build.MODEL;
        }

        private String formatTime(long time) {
            Date date = new Date();
            date.setTime(time);

            //SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSSSSSZ");
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SZ");
            return sdf.format(date);
        }

        @Override
        protected void onPostExecute(HttpUtilResponse hres) {

            if (hres.statusCode == StatusCode.SUCCESS) {
                String sRes = hres.content;
                Log.d(TrackingService.class.getCanonicalName(), sRes);

                Gson gson = new Gson();
                AddTrackResponse response = gson.fromJson(sRes, AddTrackResponse.class);

                listener.addTrackCompleted(response);
            }
            else {
                String reason = HttpUtil.getReasonMessage(hres.statusCode, hres.statusMessage);
                listener.addTrackFailed(reason);
            }

        }
    }
}
