package org.quidity.demo.mapi.spatial;

import android.os.AsyncTask;
import android.util.Log;

import com.google.gson.Gson;

import org.apache.http.NameValuePair;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.message.BasicNameValuePair;
import org.quidity.demo.Settings;
import org.quidity.demo.mapi.StatusCode;
import org.quidity.demo.mapi.attributes.AddAttributesResponse;
import org.quidity.demo.mapi.attributes.FeaturesRequest;
import org.quidity.demo.mapi.attributes.FeaturesResponse;
import org.quidity.demo.mapi.attributes.Geometry;
import org.quidity.demo.util.HttpUtil;
import org.quidity.demo.util.HttpUtilResponse;

import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;

/**
 * Created by ferdiedanzfuss on 14/12/11.
 */
public class SpatialService {

    public interface UpdateFeatureListener {
        public void updateFeatureCompleted(UpdateFeatureResponse response);
        public void updateFeatureFailed(String reason);
    }

    public void updateFeature(UpdateFeatureRequest request, Geometry geometry, UpdateFeatureListener listener) {

        UpdateFeatureTask task = new UpdateFeatureTask(request, geometry, listener);
        task.execute();

    }

    private class UpdateFeatureTask extends AsyncTask<Void, Void, HttpUtilResponse> {

        private UpdateFeatureListener listener;
        private UpdateFeatureRequest request;
        private Geometry geometry;

        public UpdateFeatureTask(UpdateFeatureRequest request, Geometry geometry, UpdateFeatureListener listener) {
            this.listener = listener;
            this.geometry = geometry;
            this.request = request;
        }

        @Override
        protected HttpUtilResponse doInBackground(Void... voids) {
            HttpUtilResponse response = null;

            try {
                Gson gson = new Gson();
                String sReq = gson.toJson(request);
                Log.d(SpatialService.class.getCanonicalName(), sReq);

                String urlStr = Settings.MAPI_SPATIAL_URL + "/update/feature?json=" + URLEncoder.encode(sReq, "UTF-8");
                Log.d(SpatialService.class.getCanonicalName(), urlStr);

                List<NameValuePair> parameters = new ArrayList<NameValuePair>();

                String key = "geometry";
                String value = gson.toJson(geometry);
                Log.d(getClass().getCanonicalName(), value);

                NameValuePair pair = new BasicNameValuePair(key, value);
                parameters.add(pair);

                UrlEncodedFormEntity entity = new UrlEncodedFormEntity(parameters);

                response = HttpUtil.httpPost(urlStr, entity);
            }
            catch(Exception e) {
                Log.e(SpatialService.class.getCanonicalName(), e.getLocalizedMessage(), e);
            }

            return response;
        }

        @Override
        protected void onPostExecute(HttpUtilResponse hres) {

            if (hres.statusCode == StatusCode.SUCCESS) {
                String sRes = hres.content;
                Log.d(SpatialService.class.getCanonicalName(), sRes);

                Gson gson = new Gson();
                UpdateFeatureResponse response = gson.fromJson(sRes, UpdateFeatureResponse.class);

                listener.updateFeatureCompleted(response);
            }
            else {
                String reason = HttpUtil.getReasonMessage(hres.statusCode, hres.statusMessage);
                listener.updateFeatureFailed(reason);
            }

        }
    }


}
