package org.quidity.demo.mapi.params;

import android.os.AsyncTask;
import android.util.Log;

import com.google.gson.Gson;

import java.net.URLEncoder;

import org.quidity.demo.Settings;
import org.quidity.demo.mapi.StatusCode;
import org.quidity.demo.util.HttpUtil;
import org.quidity.demo.util.HttpUtilResponse;

/**
 * Created by ferdiedanzfuss on 2014/09/01.
 */
public class ParameterService {

    public interface LayersListener {
        public void layersCompleted(LayersResponse response);
        public void layersFailed(String reason);
    }

    public interface EditTemplatesListener {
        public void editTemplatesCompleted(EditTemplatesResponse response);
        public void editTemplatesFailed(String reason);
    }

    public interface EditTemplateFieldsListener {
        public void editTemplateFieldsCompleted(EditTemplateFieldsResponse response);
        public void editTemplateFieldsFailed(String reason);
    }


    public void layers(long workspaceId, LayersRequest request, LayersListener listener) {

        LayersTask task = new LayersTask(workspaceId, request, listener);
        task.execute();

    }

    public void editTemplates(long layerId, EditTemplatesRequest request, EditTemplatesListener listener) {

        EditTemplatesTask task = new EditTemplatesTask(layerId, request, listener);
        task.execute();

    }

    public void editTemplateFields(long layerEditId, EditTemplateFieldsRequest request, EditTemplateFieldsListener listener) {

        EditTemplateFieldsTask task = new EditTemplateFieldsTask(layerEditId, request, listener);
        task.execute();

    }


    private class LayersTask extends AsyncTask<Void, Void, HttpUtilResponse> {

        private LayersListener listener;
        private LayersRequest request;
        private long workspaceId;

        public LayersTask(long workspaceId, LayersRequest request, LayersListener listener) {
            this.listener = listener;
            this.request = request;
            this.workspaceId = workspaceId;
        }

        @Override
        protected HttpUtilResponse doInBackground(Void... voids) {
            HttpUtilResponse response = null;

            try {
                Gson gson = new Gson();
                String sReq = gson.toJson(request);
                Log.d(ParameterService.class.getCanonicalName(), sReq);

                String urlStr = Settings.MAPI_PARAMS_URL + "/get/layers/" + workspaceId + "?json=" + URLEncoder.encode(sReq, "UTF-8");
                Log.d(ParameterService.class.getCanonicalName(), urlStr);

                response = HttpUtil.httpGet(urlStr);
            }
            catch(Exception e) {
                Log.e(ParameterService.class.getCanonicalName(), e.getLocalizedMessage(), e);
            }

            return response;
        }

        @Override
        protected void onPostExecute(HttpUtilResponse hres) {

            if (hres.statusCode == StatusCode.SUCCESS) {
                String sRes = hres.content;
                Log.d(ParameterService.class.getCanonicalName(), sRes);
                Gson gson = new Gson();
                LayersResponse response = gson.fromJson(sRes, LayersResponse.class);

                listener.layersCompleted(response);
            }
            else {
                String reason = HttpUtil.getReasonMessage(hres.statusCode, hres.statusMessage);
                listener.layersFailed(reason);
            }

        }
    }


    private class EditTemplatesTask extends AsyncTask<Void, Void, HttpUtilResponse> {

        private EditTemplatesListener listener;
        private EditTemplatesRequest request;
        private long layerId;

        public EditTemplatesTask(long layerId, EditTemplatesRequest request, EditTemplatesListener listener) {
            this.listener = listener;
            this.request = request;
            this.layerId = layerId;
        }

        @Override
        protected HttpUtilResponse doInBackground(Void... voids) {
            HttpUtilResponse response = null;

            try {
                Gson gson = new Gson();
                String sReq = gson.toJson(request);
                Log.d(ParameterService.class.getCanonicalName(), sReq);

                String urlStr = Settings.MAPI_PARAMS_URL + "/get/edittemplates/" + layerId + "?json=" + URLEncoder.encode(sReq, "UTF-8");
                Log.d(ParameterService.class.getCanonicalName(), urlStr);

                response = HttpUtil.httpGet(urlStr);
            }
            catch(Exception e) {
                Log.e(ParameterService.class.getCanonicalName(), e.getLocalizedMessage(), e);
            }

            return response;
        }

        @Override
        protected void onPostExecute(HttpUtilResponse hres) {

            if (hres.statusCode == StatusCode.SUCCESS) {
                String sRes = hres.content;
                Log.d(ParameterService.class.getCanonicalName(), sRes);
                Gson gson = new Gson();
                EditTemplatesResponse response = gson.fromJson(sRes, EditTemplatesResponse.class);

                listener.editTemplatesCompleted(response);
            }
            else {
                String reason = HttpUtil.getReasonMessage(hres.statusCode, hres.statusMessage);
                listener.editTemplatesFailed(reason);
            }

        }
    }



    private class EditTemplateFieldsTask extends AsyncTask<Void, Void, HttpUtilResponse> {

        private EditTemplateFieldsListener listener;
        private EditTemplateFieldsRequest request;
        private long layerEditId;

        public EditTemplateFieldsTask(long layerEditId, EditTemplateFieldsRequest request, EditTemplateFieldsListener listener) {
            this.listener = listener;
            this.request = request;
            this.layerEditId = layerEditId;
        }

        @Override
        protected HttpUtilResponse doInBackground(Void... voids) {
            HttpUtilResponse response = null;

            try {
                Gson gson = new Gson();
                String sReq = gson.toJson(request);
                Log.d(ParameterService.class.getCanonicalName(), sReq);

                String urlStr = Settings.MAPI_PARAMS_URL + "/get/edittemplate/" + layerEditId + "?json=" + URLEncoder.encode(sReq, "UTF-8");
                Log.d(ParameterService.class.getCanonicalName(), urlStr);

                response = HttpUtil.httpGet(urlStr);
            }
            catch(Exception e) {
                Log.e(ParameterService.class.getCanonicalName(), e.getLocalizedMessage(), e);
            }

            return response;
        }

        @Override
        protected void onPostExecute(HttpUtilResponse hres) {

            if (hres.statusCode == StatusCode.SUCCESS) {
                String sRes = hres.content;
                Log.d(ParameterService.class.getCanonicalName(), sRes);
                Gson gson = new Gson();
                EditTemplateFieldsResponse response = gson.fromJson(sRes, EditTemplateFieldsResponse.class);

                listener.editTemplateFieldsCompleted(response);
            }
            else {
                String reason = HttpUtil.getReasonMessage(hres.statusCode, hres.statusMessage);
                listener.editTemplateFieldsFailed(reason);
            }

        }
    }

}
