package org.quidity.demo.mapi.params;

import android.util.Log;

import com.google.gson.annotations.SerializedName;

/**
 * Created by ferdiedanzfuss on 2014/09/01.
 */
public class Layer implements Comparable<Layer> {

    @SerializedName("layerid")
    private long id;

    @SerializedName("layertype")
    private String layerType;

    @SerializedName("layercaption")
    private String caption;

    @SerializedName("layer_description")
    private String description;

    @SerializedName("primaryfield")
    private String primaryField;

    @SerializedName("captionfieldcaption")
    private String captionFieldCaption;

    @SerializedName("isbaselayer")
    private boolean baseLayer;

    @SerializedName("visibility")
    private boolean visibility;

    @SerializedName("opacity")
    private double opacity;

    @SerializedName("minscale")
    private int minScale;

    @SerializedName("maxscale")
    private int maxScale;

    @SerializedName("layerord")
    private int order;

    @SerializedName("layergroup")
    private String group;

    @SerializedName("drawcache")
    private boolean drawCache;

    @SerializedName("layerstyle")
    private String style;

    @SerializedName("layerdefault")
    private boolean layerDefault;

    @SerializedName("attribution")
    private String attribution;

    @SerializedName("can_edit_metadata")
    private boolean editMetadata;

    @SerializedName("can_edit_spatial")
    private boolean editSpatial;

    @SerializedName("dest_type")
    private String destinationType;

    public long getId() {
        return id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public String getLayerType() {
        return layerType;
    }

    public void setLayerType(String layerType) {
        this.layerType = layerType;
    }

    public String getCaption() {
        return caption;
    }

    public void setCaption(String caption) {
        this.caption = caption;
    }

    public String getDescription() {
        return description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getPrimaryField() {
        return primaryField;
    }

    public void setPrimaryField(String primaryField) {
        this.primaryField = primaryField;
    }

    public String getCaptionFieldCaption() {
        return captionFieldCaption;
    }

    public void setCaptionFieldCaption(String captionFieldCaption) {
        this.captionFieldCaption = captionFieldCaption;
    }

    public boolean getBaseLayer() {
        return baseLayer;
    }

    public void setBaseLayer(boolean baseLayer) {
        this.baseLayer = baseLayer;
    }

    public boolean isVisibility() {
        return visibility;
    }

    public void setVisibility(boolean visibility) {
        this.visibility = visibility;
    }

    public double getOpacity() {
        return opacity;
    }

    public void setOpacity(double opacity) {
        this.opacity = opacity;
    }

    public int getMinScale() {
        return minScale;
    }

    public void setMinScale(int minScale) {
        this.minScale = minScale;
    }

    public int getMaxScale() {
        return maxScale;
    }

    public void setMaxScale(int maxScale) {
        this.maxScale = maxScale;
    }

    public int getOrder() {
        return order;
    }

    public void setOrder(int order) {
        this.order = order;
    }

    public String getGroup() {
        return group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public boolean isDrawCache() {
        return drawCache;
    }

    public void setDrawCache(boolean drawCache) {
        this.drawCache = drawCache;
    }

    public String getStyle() {
        return style;
    }

    public void setStyle(String style) {
        this.style = style;
    }

    public boolean isLayerDefault() {
        return layerDefault;
    }

    public void setLayerDefault(boolean layerDefault) {
        this.layerDefault = layerDefault;
    }

    public String getAttribution() {
        //HACK: fix target parameter so that links will open in external browser
        //String fixedAttribution = attribution.replaceAll("_blank", "_system");
        //Log.d(getClass().getCanonicalName(), "Fixed attribution: " + fixedAttribution);
        //return fixedAttribution;
        return attribution;
    }

    public void setAttribution(String attribution) {
        this.attribution = attribution;
    }

    public boolean isEditMetadata() {
        return editMetadata;
    }

    public void setEditMetadata(boolean editMetadata) {
        this.editMetadata = editMetadata;
    }

    public boolean isEditSpatial() {
        return editSpatial;
    }

    public void setEditSpatial(boolean editSpatial) {
        this.editSpatial = editSpatial;
    }

    public String getDestinationType() {
        return destinationType;
    }

    public void setDestinationType(String destinationType) {
        this.destinationType = destinationType;
    }

    @Override
    public String toString() {
        return caption;
    }

    @Override
    public int compareTo(Layer layer) {
        Integer int1 = this.getOrder();
        Integer int2 = layer.getOrder();
        return int1.compareTo(int2);
    }

}
