package org.quidity.demo.mapi.location;

import android.os.AsyncTask;
import android.util.Log;

import com.google.gson.Gson;

import java.net.URLEncoder;

import org.quidity.demo.Settings;
import org.quidity.demo.mapi.StatusCode;
import org.quidity.demo.util.HttpUtil;
import org.quidity.demo.util.HttpUtilResponse;

/**
 * Created by ferdiedanzfuss on 2014/09/17.
 */
public class LocationService {

    public interface SearchAddressListener {
        public void onSearchAddressCompleted(SearchAddressResponse response);
        public void onSearchAddressFailed(String reason);
    }

    public interface SearchErfListener {
        public void onSearchErfCompleted(SearchErfResponse response);
        public void onSearchErfFailed(String reason);
    }

    public void searchAddress(SearchAddressRequest request, SearchAddressListener listener) {

        SearchAddressTask task = new SearchAddressTask(request, listener);
        task.execute();

    }

    public void searchErf(SearchErfRequest request, SearchErfListener listener) {

        SearchErfTask task = new SearchErfTask(request, listener);
        task.execute();

    }


    private class SearchAddressTask extends AsyncTask<Void, Void, HttpUtilResponse> {

        private SearchAddressListener listener;
        private SearchAddressRequest request;

        public SearchAddressTask(SearchAddressRequest request, SearchAddressListener listener) {
            this.listener = listener;
            this.request = request;
        }

        @Override
        protected HttpUtilResponse doInBackground(Void... voids) {
            HttpUtilResponse response = null;

            try {
                Gson gson = new Gson();
                String sReq = gson.toJson(request);
                Log.d(LocationService.class.getCanonicalName(), sReq);

                String urlStr = Settings.MAPI_BASE_URL + "/address/search/?json=" + URLEncoder.encode(sReq, "UTF-8");
                Log.d(LocationService.class.getCanonicalName(), urlStr);

                response = HttpUtil.httpGet(urlStr);
            }
            catch(Exception e) {
                Log.e(LocationService.class.getCanonicalName(), e.getLocalizedMessage(), e);
            }

            return response;
        }

        @Override
        protected void onPostExecute(HttpUtilResponse hres) {

            if (hres.statusCode == StatusCode.SUCCESS) {
                String sRes = hres.content;
                Log.d(LocationService.class.getCanonicalName(), sRes);
                Gson gson = new Gson();
                SearchAddressResponse response = gson.fromJson(sRes, SearchAddressResponse.class);

                listener.onSearchAddressCompleted(response);
            }
            else {
                String reason = HttpUtil.getReasonMessage(hres.statusCode, hres.statusMessage);
                listener.onSearchAddressFailed(reason);
            }

        }
    }


    private class SearchErfTask extends AsyncTask<Void, Void, HttpUtilResponse> {

        private SearchErfListener listener;
        private SearchErfRequest request;

        public SearchErfTask(SearchErfRequest request, SearchErfListener listener) {
            this.listener = listener;
            this.request = request;
        }

        @Override
        protected HttpUtilResponse doInBackground(Void... voids) {
            HttpUtilResponse response = null;

            try {
                Gson gson = new Gson();
                String sReq = gson.toJson(request);
                Log.d(LocationService.class.getCanonicalName(), sReq);

                String urlStr = Settings.MAPI_BASE_URL + "/address/search/erfno?json=" + URLEncoder.encode(sReq, "UTF-8");
                Log.d(LocationService.class.getCanonicalName(), urlStr);

                response = HttpUtil.httpGet(urlStr);
            }
            catch(Exception e) {
                Log.e(LocationService.class.getCanonicalName(), e.getLocalizedMessage(), e);
            }

            return response;
        }

        @Override
        protected void onPostExecute(HttpUtilResponse hres) {

            if (hres.statusCode == StatusCode.SUCCESS) {
                String sRes = hres.content;
                Log.d(LocationService.class.getCanonicalName(), sRes);
                Gson gson = new Gson();
                SearchErfResponse response = gson.fromJson(sRes, SearchErfResponse.class);

                listener.onSearchErfCompleted(response);
            }
            else {
                String reason = HttpUtil.getReasonMessage(hres.statusCode, hres.statusMessage);
                listener.onSearchErfFailed(reason);
            }

        }
    }
}
