package org.quidity.demo.mapi.auth;

import com.google.gson.annotations.SerializedName;

import java.util.List;

import org.quidity.demo.mapi.BaseResponse;

/**
 * Created by ferdiedanzfuss on 2014/08/29.
 */
public class LoginResponse extends BaseResponse {

    private String serial;
    private String token;
    @SerializedName("role_id") private int roleId;

    private List<Workspace> workspaces;

    public String getSerial() {
        return serial;
    }

    public void setSerial(String serial) {
        this.serial = serial;
    }

    public String getToken() {
        return token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public int getRoleId() {
        return roleId;
    }

    public void setRoleId(int roleId) {
        this.roleId = roleId;
    }

    public List<Workspace> getWorkspaces() {
        return workspaces;
    }

    public void setWorkspaces(List<Workspace> workspaces) {
        this.workspaces = workspaces;
    }

    public Workspace getDefaultWorkspace() {
        Workspace defaultWorkspace = null;
        for(Workspace workspace : getWorkspaces()) {
            if (workspace.isDefaultWorkspace()) {
                defaultWorkspace = workspace;
                break;
            }
        }
        return defaultWorkspace;
    }
}
