package org.quidity.demo.mapi.auth;

import android.os.AsyncTask;
import android.util.Log;

import com.google.gson.Gson;

import java.net.URLEncoder;

import org.quidity.demo.Session;
import org.quidity.demo.Settings;
import org.quidity.demo.mapi.StatusCode;
import org.quidity.demo.util.HttpUtil;
import org.quidity.demo.util.HttpUtilResponse;

/**
 * Created by ferdiedanzfuss on 2014/09/01.
 */
public class AuthorizationService {

    public interface LoginListener {
        public void loginCompleted(LoginResponse response);
        public void loginFailed(String reason);
    }

    public  interface LogoutListener {
        public void logoutCompleted(LogoutResponse response);
        public void logoutFailed(String reason);
    }



    public void login(LoginRequest request, LoginListener listener) {

        LoginTask task = new LoginTask(listener);
        task.execute(request);

    }

    public void logout(LogoutRequest request, LogoutListener listener) {

        LogoutTask task = new LogoutTask(listener);
        task.execute(request);

    }



    private class LoginTask extends AsyncTask<LoginRequest, Void, HttpUtilResponse> {

        private LoginListener listener;

        public LoginTask(LoginListener listener) {
            this.listener = listener;
        }

        @Override
        protected HttpUtilResponse doInBackground(LoginRequest... requests) {
            HttpUtilResponse response = null;

            try {
                LoginRequest request = requests[0];

                Gson gson = new Gson();
                String sReq = gson.toJson(request);
                Log.d(AuthorizationService.class.getCanonicalName(), sReq);

                String urlStr = Settings.MAPI_AUTH_URL + "/login?json=" + URLEncoder.encode(sReq, "UTF-8");
                Log.d(AuthorizationService.class.getCanonicalName(), urlStr);

                response = HttpUtil.httpGet(urlStr);
            }
            catch(Exception e) {
                Log.e(AuthorizationService.class.getCanonicalName(), e.getLocalizedMessage(), e);
            }

            return response;
        }

        @Override
        protected void onPostExecute(HttpUtilResponse hres) {

            if (hres.statusCode == StatusCode.SUCCESS || hres.statusCode == StatusCode.ALREADY_LOGGED_IN) {
                String sRes = hres.content;
                Log.d(AuthorizationService.class.getCanonicalName(), sRes);
                Gson gson = new Gson();
                LoginResponse response = gson.fromJson(sRes, LoginResponse.class);

                Session.getSession().setSerial(response.getSerial());
                Session.getSession().setToken(response.getToken());
                Session.getSession().setWorkspaces(response.getWorkspaces());

                listener.loginCompleted(response);
            }
            else {
                String reason = HttpUtil.getReasonMessage(hres.statusCode, hres.statusMessage);
                listener.loginFailed(reason);
            }

        }
    }


    private class LogoutTask extends AsyncTask<LogoutRequest, Void, HttpUtilResponse> {

        private LogoutListener listener;

        public LogoutTask(LogoutListener listener) {
            this.listener = listener;
        }

        @Override
        protected HttpUtilResponse doInBackground(LogoutRequest... requests) {
            HttpUtilResponse response = null;

            try {
                LogoutRequest request = requests[0];

                Gson gson = new Gson();
                String sReq = gson.toJson(request);
                Log.d(AuthorizationService.class.getCanonicalName(), sReq);

                String urlStr = Settings.MAPI_AUTH_URL + "/logout?json=" + URLEncoder.encode(sReq, "UTF-8");
                Log.d(AuthorizationService.class.getCanonicalName(), urlStr);

                response = HttpUtil.httpGet(urlStr);
            }
            catch(Exception e) {
                Log.e(AuthorizationService.class.getCanonicalName(), e.getLocalizedMessage(), e);
            }

            return response;
        }

        @Override
        protected void onPostExecute(HttpUtilResponse hres) {

            if (hres.statusCode == StatusCode.SUCCESS || hres.statusCode == StatusCode.ALREADY_LOGGED_IN) {
                String sRes = hres.content;
                Log.d(AuthorizationService.class.getCanonicalName(), sRes);
                Gson gson = new Gson();
                LogoutResponse response = gson.fromJson(sRes, LogoutResponse.class);

                listener.logoutCompleted(response);
            }
            else {
                String reason = HttpUtil.getReasonMessage(hres.statusCode, hres.statusMessage);
                listener.logoutFailed(reason);
            }

        }
    }

}
