package org.quidity.demo.mapi.attributes;

import android.os.AsyncTask;
import android.util.Log;

import com.cleverua.android.multipart.FilePart;
import com.cleverua.android.multipart.MultipartEntity;
import com.cleverua.android.multipart.StringPart;
import com.google.gson.Gson;

import org.apache.http.HttpEntity;
import org.apache.http.NameValuePair;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.message.BasicNameValuePair;
import org.quidity.demo.Settings;
import org.quidity.demo.mapi.StatusCode;
import org.quidity.demo.mapi.params.LayersRequest;
import org.quidity.demo.mapi.params.LayersResponse;
import org.quidity.demo.util.HttpUtil;
import org.quidity.demo.util.HttpUtilResponse;

import java.io.File;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/**
 * Created by ferdiedanzfuss on 2014/10/21.
 */
public class AttributesService {

    public interface FeaturesListener {
        public void featuresCompleted(FeaturesResponse response);
        public void featuresFailed(String reason);
    }

    public interface AttachmentsListener {
        public void attachmentsCompleted(AttachmentsResponse response);
        public void attachmentsFailed(String reason);
        public void attachmentsDownloadProgress(double progress);
    }

    public interface AddAttachmentListener {
        public void addAttachmentCompleted(AddAttachmentResponse response);
        public void addAttachmentFailed(String reason);
    }

    public interface AddAttributesListener {
        public void addAttributesCompleted(AddAttributesResponse response);
        public void addAttributesFailed(String reason);
    }

    public interface EditAttributesListener {
        public void editAttributesCompleted(EditAttributesResponse response);
        public void editAttributesFailed(String reason);
    }


    public interface DeleteAttachmentListener {
        public void deleteAttachmentCompleted(DeleteAttachmentResponse response);
        public void deleteAttachmentFailed(String reason);
    }

    public void features(FeaturesRequest request, FeaturesListener listener) {

        FeaturesTask task = new FeaturesTask(request, listener);
        task.execute();

    }

    public void getAttributesByPrimaryId(AttributesByPrimaryIdRequest request, FeaturesListener listener) {

        AttributesByPrimaryIdTask task = new AttributesByPrimaryIdTask(request, listener);
        task.execute();

    }


    public void attachments(AttachmentsRequest request, String savePath, AttachmentsListener listener) {

        AttachmentsTask task = new AttachmentsTask(request, listener, savePath);
        task.execute();

    }

    public void addAttachment(AddAttachmentRequest request, Attachment params, String filePath, AddAttachmentListener listener) {

        AddAttachmentTask task = new AddAttachmentTask(request, params, filePath, listener);
        task.execute();

    }

    public void addAttributes(AddAttributesRequest request, Feature feature, AddAttributesListener listener) {

        AddAttributesTask task = new AddAttributesTask(request, feature, listener);
        task.execute();

    }

    public void editAttributes(EditAttributesRequest request, Feature feature, EditAttributesListener listener) {

        EditAttributesTask task = new EditAttributesTask(request, feature, listener);
        task.execute();

    }

    public void deleteAttachment(DeleteAttachmentRequest request, DeleteAttachmentListener listener) {

        DeleteAttachmentTask task = new DeleteAttachmentTask(request, listener);
        task.execute();

    }

    private class FeaturesTask extends AsyncTask<Void, Void, HttpUtilResponse> {

        private FeaturesListener listener;
        private FeaturesRequest request;

        public FeaturesTask(FeaturesRequest request, FeaturesListener listener) {
            this.listener = listener;
            this.request = request;
        }

        @Override
        protected HttpUtilResponse doInBackground(Void... voids) {
            HttpUtilResponse response = null;

            try {
                Gson gson = new Gson();
                String sReq = gson.toJson(request);
                Log.d(AttributesService.class.getCanonicalName(), sReq);

                //String urlStr = Settings.MAPI_ATTRIBUTES_URL + "/contains/point?json=" + URLEncoder.encode(sReq, "UTF-8");
                String urlStr = Settings.MAPI_ATTRIBUTES_URL + "/closest/point?json=" + URLEncoder.encode(sReq, "UTF-8");
                Log.d(AttributesService.class.getCanonicalName(), urlStr);

                response = HttpUtil.httpGet(urlStr);
            }
            catch(Exception e) {
                Log.e(AttributesService.class.getCanonicalName(), e.getLocalizedMessage(), e);
            }

            return response;
        }

        @Override
        protected void onPostExecute(HttpUtilResponse hres) {

            if (hres.statusCode == StatusCode.SUCCESS) {
                String sRes = hres.content;
                Log.d(AttributesService.class.getCanonicalName(), sRes);
                Gson gson = new Gson();
                FeaturesResponse response = gson.fromJson(sRes, FeaturesResponse.class);

                listener.featuresCompleted(response);
            }
            else {
                String reason = HttpUtil.getReasonMessage(hres.statusCode, hres.statusMessage);
                listener.featuresFailed(reason);
            }

        }
    }


    private class AttributesByPrimaryIdTask extends AsyncTask<Void, Void, HttpUtilResponse> {

        private FeaturesListener listener;
        private AttributesByPrimaryIdRequest request;

        public AttributesByPrimaryIdTask(AttributesByPrimaryIdRequest request, FeaturesListener listener) {
            this.listener = listener;
            this.request = request;
        }

        @Override
        protected HttpUtilResponse doInBackground(Void... voids) {
            HttpUtilResponse response = null;

            try {
                Gson gson = new Gson();
                String sReq = gson.toJson(request);
                Log.d(AttributesService.class.getCanonicalName(), sReq);

                String urlStr = Settings.MAPI_ATTRIBUTES_URL + "/get/attributes?json=" + URLEncoder.encode(sReq, "UTF-8");
                Log.d(AttributesService.class.getCanonicalName(), urlStr);

                response = HttpUtil.httpGet(urlStr);
            }
            catch(Exception e) {
                Log.e(AttributesService.class.getCanonicalName(), e.getLocalizedMessage(), e);
            }

            return response;
        }

        @Override
        protected void onPostExecute(HttpUtilResponse hres) {

            if (hres.statusCode == StatusCode.SUCCESS) {
                String sRes = hres.content;
                Log.d(AttributesService.class.getCanonicalName(), sRes);
                Gson gson = new Gson();
                FeaturesResponse response = gson.fromJson(sRes, FeaturesResponse.class);

                listener.featuresCompleted(response);
            }
            else {
                String reason = HttpUtil.getReasonMessage(hres.statusCode, hres.statusMessage);
                listener.featuresFailed(reason);
            }

        }
    }



    private class AttachmentsTask extends AsyncTask<Void, Void, HttpUtilResponse> implements HttpUtil.DownloadProgressListener {

        private AttachmentsListener listener;
        private AttachmentsRequest request;
        private String savePath;

        public AttachmentsTask(AttachmentsRequest request, AttachmentsListener listener, String savePath) {
            this.listener = listener;
            this.request = request;
            this.savePath = savePath;
        }

        @Override
        protected HttpUtilResponse doInBackground(Void... voids) {
            HttpUtilResponse response = null;

            try {
                Gson gson = new Gson();
                String sReq = gson.toJson(request);
                Log.d(AttributesService.class.getCanonicalName(), sReq);

                //String urlStr = Settings.MAPI_ATTRIBUTES_URL + "/contains/point?json=" + URLEncoder.encode(sReq, "UTF-8");
                String urlStr = Settings.MAPI_ATTRIBUTES_URL + "/get/attachments?json=" + URLEncoder.encode(sReq, "UTF-8");
                Log.d(AttributesService.class.getCanonicalName(), urlStr);

                response = HttpUtil.httpDownload(urlStr, savePath, AttachmentsTask.this);
            }
            catch(Exception e) {
                Log.e(AttributesService.class.getCanonicalName(), e.getLocalizedMessage(), e);
            }

            return response;
        }

        @Override
        protected void onPostExecute(HttpUtilResponse hres) {

            if (hres.statusCode == StatusCode.SUCCESS) {
                //String sRes = hres.content;
                //Log.d(AttributesService.class.getCanonicalName(), sRes);

                //Gson gson = new Gson();
                //AttachmentsResponse response = gson.fromJson(sRes, AttachmentsResponse.class);
                AttachmentsResponse response = new AttachmentsResponse();

                listener.attachmentsCompleted(response);
            }
            else {
                String reason = HttpUtil.getReasonMessage(hres.statusCode, hres.statusMessage);
                listener.attachmentsFailed(reason);
            }

        }

        @Override
        public void downloadProgress(double percentage) {
            //pass it on to the listener
            listener.attachmentsDownloadProgress(percentage);
        }
    }



    private class AddAttachmentTask extends AsyncTask<Void, Void, HttpUtilResponse> {

        private AddAttachmentListener listener;
        private Attachment params;
        private String filePath;
        private AddAttachmentRequest request;


        public AddAttachmentTask(AddAttachmentRequest request, Attachment params, String filePath, AddAttachmentListener listener) {
            this.listener = listener;
            this.params = params;
            this.filePath = filePath;
            this.request = request;
        }

        @Override
        protected HttpUtilResponse doInBackground(Void... voids) {
            HttpUtilResponse response = null;

            try {
                Gson gson = new Gson();
                String sReq = gson.toJson(request);
                Log.d(AttributesService.class.getCanonicalName(), sReq);

                String urlStr = Settings.MAPI_ATTRIBUTES_URL + "/add/attachments?json=" + URLEncoder.encode(sReq, "UTF-8");
                Log.d(AttributesService.class.getCanonicalName(), urlStr);

                MultipartEntity entity = new MultipartEntity();
                //entity.setContentType("multipart/form-data");
                //entity.setMode(HttpMultipartMode.BROWSER_COMPATIBLE);

                entity.addPart(new StringPart("attachment_type", params.getType()));
                entity.addPart(new StringPart("header", params.getHeader()));
                entity.addPart(new StringPart("caption", params.getCaption()));

                String description = params.getDescription();
                if ((description != null) && (description.length() > 0)) {
                    entity.addPart(new StringPart("description", params.getDescription()));
                }

                if (params.getCameraPosition() != null) {
                    AttachmentCameraPosition pos = params.getCameraPosition();
                    entity.addPart(new StringPart("camera_lat", Double.toString(pos.getLatitude())));
                    entity.addPart(new StringPart("camera_lon", Double.toString(pos.getLongitude())));
                    entity.addPart(new StringPart("camera_alt", Double.toString(pos.getAltitude())));
                    entity.addPart(new StringPart("camera_angle", Double.toString(pos.getAngle())));
                }

                File file = new File(filePath);
                entity.addPart(new FilePart("attachment", file, file.getName(), params.getHeader()));

                response = HttpUtil.httpPost(urlStr, entity);
            }
            catch(Exception e) {
                Log.e(AttributesService.class.getCanonicalName(), e.getLocalizedMessage(), e);
            }

            return response;
        }

        @Override
        protected void onPostExecute(HttpUtilResponse hres) {

            if (hres.statusCode == StatusCode.SUCCESS) {
                String sRes = hres.content;
                Log.d(AttributesService.class.getCanonicalName(), sRes);

                Gson gson = new Gson();
                AddAttachmentResponse response = gson.fromJson(sRes, AddAttachmentResponse.class);

                listener.addAttachmentCompleted(response);
            }
            else {
                String reason = HttpUtil.getReasonMessage(hres.statusCode, hres.statusMessage);
                listener.addAttachmentFailed(reason);
            }

        }

    }


    private class AddAttributesTask extends AsyncTask<Void, Void, HttpUtilResponse> {

        private AddAttributesListener listener;
        private Feature feature;
        private AddAttributesRequest request;


        public AddAttributesTask(AddAttributesRequest request, Feature feature, AddAttributesListener listener) {
            this.listener = listener;
            this.feature = feature;
            this.request = request;
        }

        @Override
        protected HttpUtilResponse doInBackground(Void... voids) {
            HttpUtilResponse response = null;

            try {
                Gson gson = new Gson();
                String sReq = gson.toJson(request);
                Log.d(AttributesService.class.getCanonicalName(), sReq);

                String urlStr = Settings.MAPI_ATTRIBUTES_URL + "/add/attributes?json=" + URLEncoder.encode(sReq, "UTF-8");
                Log.d(AttributesService.class.getCanonicalName(), urlStr);

                List<NameValuePair> parameters = new ArrayList<NameValuePair>();

                for (String key : feature.getProperties().keySet()) {
                    String value = (String)feature.getProperties().get(key);

                    NameValuePair pair = new BasicNameValuePair(key, value);
                    parameters.add(pair);
                }

                UrlEncodedFormEntity entity = new UrlEncodedFormEntity(parameters);

                response = HttpUtil.httpPost(urlStr, entity);
            }
            catch(Exception e) {
                Log.e(AttributesService.class.getCanonicalName(), e.getLocalizedMessage(), e);
            }

            return response;
        }

        @Override
        protected void onPostExecute(HttpUtilResponse hres) {

            if (hres.statusCode == StatusCode.SUCCESS) {
                String sRes = hres.content;
                Log.d(AttributesService.class.getCanonicalName(), sRes);

                Gson gson = new Gson();
                AddAttributesResponse response = gson.fromJson(sRes, AddAttributesResponse.class);

                listener.addAttributesCompleted(response);
            }
            else {
                String reason = HttpUtil.getReasonMessage(hres.statusCode, hres.statusMessage);
                listener.addAttributesFailed(reason);
            }

        }

    }

    private class EditAttributesTask extends AsyncTask<Void, Void, HttpUtilResponse> {

        private EditAttributesListener listener;
        private Feature feature;
        private EditAttributesRequest request;


        public EditAttributesTask(EditAttributesRequest request, Feature feature, EditAttributesListener listener) {
            this.listener = listener;
            this.feature = feature;
            this.request = request;
        }

        @Override
        protected HttpUtilResponse doInBackground(Void... voids) {
            HttpUtilResponse response = null;

            try {
                Gson gson = new Gson();
                String sReq = gson.toJson(request);
                Log.d(AttributesService.class.getCanonicalName(), sReq);

                String urlStr = Settings.MAPI_ATTRIBUTES_URL + "/edit/attributes?json=" + URLEncoder.encode(sReq, "UTF-8");
                Log.d(AttributesService.class.getCanonicalName(), urlStr);

                List<NameValuePair> parameters = new ArrayList<NameValuePair>();

                for (String key : feature.getProperties().keySet()) {
                    Object oValue = feature.getProperties().get(key);
                    if (oValue instanceof String) {
                        String value = (String) feature.getProperties().get(key);

                        NameValuePair pair = new BasicNameValuePair(key, value);
                        parameters.add(pair);
                    }
                }

                UrlEncodedFormEntity entity = new UrlEncodedFormEntity(parameters);

                response = HttpUtil.httpPost(urlStr, entity);
            }
            catch(Exception e) {
                Log.e(AttributesService.class.getCanonicalName(), e.getLocalizedMessage(), e);
            }

            return response;
        }

        @Override
        protected void onPostExecute(HttpUtilResponse hres) {

            if (hres.statusCode == StatusCode.SUCCESS) {
                String sRes = hres.content;
                Log.d(AttributesService.class.getCanonicalName(), sRes);

                Gson gson = new Gson();
                EditAttributesResponse response = gson.fromJson(sRes, EditAttributesResponse.class);

                listener.editAttributesCompleted(response);
            }
            else {
                String reason = HttpUtil.getReasonMessage(hres.statusCode, hres.statusMessage);
                listener.editAttributesFailed(reason);
            }

        }

    }


    private class DeleteAttachmentTask extends AsyncTask<Void, Void, HttpUtilResponse> {

        private DeleteAttachmentListener listener;
        private DeleteAttachmentRequest request;

        public DeleteAttachmentTask(DeleteAttachmentRequest request, DeleteAttachmentListener listener) {
            this.listener = listener;
            this.request = request;
        }

        @Override
        protected HttpUtilResponse doInBackground(Void... voids) {
            HttpUtilResponse response = null;

            try {
                Gson gson = new Gson();
                String sReq = gson.toJson(request);
                Log.d(AttributesService.class.getCanonicalName(), sReq);

                String urlStr = Settings.MAPI_ATTRIBUTES_URL + "/delete/attachments?json=" + URLEncoder.encode(sReq, "UTF-8");
                Log.d(AttributesService.class.getCanonicalName(), urlStr);

                response = HttpUtil.httpGet(urlStr);
            }
            catch(Exception e) {
                Log.e(AttributesService.class.getCanonicalName(), e.getLocalizedMessage(), e);
            }

            return response;
        }

        @Override
        protected void onPostExecute(HttpUtilResponse hres) {

            if (hres.statusCode == StatusCode.SUCCESS) {
                String sRes = hres.content;
                Log.d(AttributesService.class.getCanonicalName(), sRes);

                Gson gson = new Gson();
                DeleteAttachmentResponse response = gson.fromJson(sRes, DeleteAttachmentResponse.class);

                listener.deleteAttachmentCompleted(response);
            }
            else {
                String reason = HttpUtil.getReasonMessage(hres.statusCode, hres.statusMessage);
                listener.deleteAttachmentFailed(reason);
            }

        }

    }

}
