package org.quidity.demo.helper;

import java.util.ArrayList;
import java.util.List;

import org.quidity.demo.Session;
import org.quidity.demo.Settings;
import org.quidity.demo.mapi.auth.Workspace;
import org.quidity.demo.mapi.params.Layer;
import org.quidity.demo.mapi.params.LayersRequest;
import org.quidity.demo.mapi.params.LayersResponse;
import org.quidity.demo.mapi.params.ParameterService;

/**
 * Created by ferdiedanzfuss on 2014/09/03.
 */
public class WorkspaceHelper implements ParameterService.LayersListener {

    public interface WorkspaceListener {
        public void onSwitchToWorkspaceCompleted(Workspace newWorkspace);
        public void onSwitchToWorkspaceFailed(String reason);
    }


    private WorkspaceListener listener;
    private Workspace newWorkspace;

    public void switchToWorkspace(Workspace newWorkspace, WorkspaceListener listener) {
        this.listener = listener;
        this.newWorkspace = newWorkspace;

        ParameterService parameterService = new ParameterService();
        parameterService.layers(newWorkspace.getWorkspaceId(), new LayersRequest(), this);
    }


    @Override
    public void layersCompleted(LayersResponse response) {

        List<Layer> layers = response.getLayers();

        //remove Google layers if disabled
        if (Settings.DISABLE_GOOGLE_LAYERS) {
            List<Layer> layersToBeRemoved = new ArrayList<Layer>();
            for (Layer layer : layers) {
                if (layer.getLayerType().toLowerCase().startsWith("google")) {
                    layersToBeRemoved.add(layer);
                }
            }
            for (Layer layerToBeRemoved : layersToBeRemoved) {
                layers.remove(layerToBeRemoved);
            }
        }

        //Add the None base layer
        Layer noneLayer = new Layer();
        noneLayer.setCaption("None");
        noneLayer.setId(-1);
        noneLayer.setBaseLayer(true);
        layers.add(0, noneLayer);

        Session.getSession().setLayers(layers);
        Session.getSession().setCurrentWorkspace(newWorkspace);

        //determine default base layer
        Session.getSession().setCurrentBaseLayer(noneLayer);    //None by default
        for (Layer layer : Session.getSession().getLayers()) {
            if (layer.getBaseLayer()) {
                if (layer.isLayerDefault()) {
                    Session.getSession().setCurrentBaseLayer(layer);
                    break;
                }
            }
        }


        if (listener != null) {
            listener.onSwitchToWorkspaceCompleted(newWorkspace);
        }
    }

    @Override
    public void layersFailed(String reason) {
        if (listener != null) {
            listener.onSwitchToWorkspaceFailed(reason);
        }
    }
}
