package org.quidity.demo.helper;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.DialogInterface;

import org.quidity.demo.mapi.auth.AuthorizationService;
import org.quidity.demo.mapi.auth.LogoutRequest;
import org.quidity.demo.mapi.auth.LogoutResponse;

/**
 * Created by ferdiedanzfuss on 2014/09/14.
 */
public class LogoutHelper implements AuthorizationService.LogoutListener {

    Activity activity;

    public LogoutHelper(Activity activity) {
        this.activity = activity;
    }

    public void initiateLogoutProcess() {
        AlertDialog confirmDialog = confirmLogoutDialog();
        confirmDialog.show();
    }

    private AlertDialog confirmLogoutDialog() {
        AlertDialog.Builder builder = new AlertDialog.Builder(activity);
        builder.setMessage("Are you sure you want to logout and exit 1Map Mobile?");
        builder.setTitle("Confirm Logout");

        builder.setPositiveButton("Yes", new DialogInterface.OnClickListener() {
            @Override
            public void onClick(DialogInterface dialogInterface, int i) {
                performLogout();
            }
        });

        builder.setNegativeButton("Cancel", new DialogInterface.OnClickListener() {
            @Override
            public void onClick(DialogInterface dialogInterface, int i) {
                //do nothing
            }
        });

        return builder.create();

    }

    private void performLogout() {
        AuthorizationService authorizationService = new AuthorizationService();
        LogoutRequest request = new LogoutRequest();
        authorizationService.logout(request, this);
    }

    @Override
    public void logoutCompleted(LogoutResponse response) {
        activity.finish();
    }

    @Override
    public void logoutFailed(String reason) {
        //Does not matter if logout fails
        activity.finish();
    }
}
