package org.quidity.demo.helper;

import android.content.Context;
import android.content.Intent;

import org.quidity.demo.Session;
import org.quidity.demo.activity.EditTemplateActivity;
import org.quidity.demo.mapi.attributes.AttributesService;
import org.quidity.demo.mapi.attributes.FeaturesRequest;
import org.quidity.demo.mapi.attributes.FeaturesResponse;
import org.quidity.demo.mapi.params.EditTemplateFieldsRequest;
import org.quidity.demo.mapi.params.EditTemplateFieldsResponse;
import org.quidity.demo.mapi.params.Layer;
import org.quidity.demo.mapi.params.ParameterService;
import org.quidity.demo.util.GuiUtil;

/**
 * Created by ferdiedanzfuss on 14/11/12.
 */
public class FeatureEditTestHelper implements AttributesService.FeaturesListener {

    private Context context;

    public FeatureEditTestHelper(Context context) {
        this.context = context;
    }

    public void test() {

        FeaturesRequest req = new FeaturesRequest();
        req.setLayerId(330);
        req.setLatitude(-33);
        req.setLongitude(19);
        req.setShowAttachments(true);

        AttributesService service = new AttributesService();
        service.features(req, this);

    }

    @Override
    public void featuresCompleted(FeaturesResponse response) {
        Session.getSession().setSelectedFeatures(response.getItems().getFeatures());
        Session.getSession().setSelectedFeatureIndex(0);

        Layer layer = new Layer();
        layer.setId(330);
        layer.setPrimaryField("primid");
        Session.getSession().setCurrentActiveLayer(layer);

        Intent intent = new Intent(context, EditTemplateActivity.class);
        context.startActivity(intent);
    }

    @Override
    public void featuresFailed(String reason) {
        GuiUtil.showError(context, reason);
    }

}
