package org.quidity.demo.helper;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.widget.Toast;

import org.quidity.demo.mapi.attributes.AttributesService;
import org.quidity.demo.mapi.attributes.DeleteAttachmentRequest;
import org.quidity.demo.mapi.attributes.DeleteAttachmentResponse;
import org.quidity.demo.util.GuiUtil;

/**
 * Created by ferdiedanzfuss on 14/12/03.
 */
public class AttachmentHelper implements DialogInterface.OnClickListener, AttributesService.DeleteAttachmentListener {

    private Activity context;
    private AlertDialog deleteDialog;
    private long layerId;
    private long primaryId;
    private long attachmentId;

    public AttachmentHelper(Activity context) {
        this.context = context;
    }

    public void promptDelete(long layerId, long primaryId, long attachmentId) {
        this.layerId = layerId;
        this.primaryId = primaryId;
        this.attachmentId = attachmentId;

        AlertDialog.Builder builder = new AlertDialog.Builder(context);
        builder.setTitle("Delete Attachment");
        builder.setMessage("Are you sure you want to delete this attachment?");
        builder.setPositiveButton("Yes", this);
        builder.setNegativeButton("Cancel", this);
        deleteDialog = builder.create();
        deleteDialog.show();
    }

    private void delete() {
        DeleteAttachmentRequest request = new DeleteAttachmentRequest();
        request.setLayerId(layerId);
        request.setPrimaryId(primaryId);
        request.setAttachmentId(attachmentId);

        AttributesService service = new AttributesService();
        service.deleteAttachment(request, this);
    }

    @Override
    public void deleteAttachmentCompleted(DeleteAttachmentResponse response) {
        String message = response.getMessage();
        if (message.equalsIgnoreCase("Success")) {
            Toast.makeText(context, "Attachment deleted.", Toast.LENGTH_SHORT);
            context.setResult(Activity.RESULT_OK);
            context.finish();
        }
        else {
            GuiUtil.showWarning(context, message);
        }
    }

    @Override
    public void deleteAttachmentFailed(String reason) {
        GuiUtil.showError(context, reason);
    }

    @Override
    public void onClick(DialogInterface dialogInterface, int buttonIndex) {
        if (dialogInterface == deleteDialog) {
            if (buttonIndex == AlertDialog.BUTTON_POSITIVE) {
                delete();
            }
        }
    }
}
