package org.quidity.demo.activity.adapter;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseExpandableListAdapter;
import android.widget.CheckBox;
import android.widget.ImageView;
import android.widget.TextView;

import java.util.List;

import org.quidity.demo.R;
import org.quidity.demo.mapi.params.Layer;

/**
 * Created by ferdiedanzfuss on 2014/09/30.
 */
public class OtherLayerAdapter extends BaseExpandableListAdapter {

    private List<LayerGroup> groups;
    private Context context;

    public OtherLayerAdapter(Context context, List<LayerGroup> groups) {
        this.context = context;
        this.groups = groups;
    }

    @Override
    public int getGroupCount() {
        return groups.size();
    }

    @Override
    public int getChildrenCount(int i) {
        return groups.get(i).getLayers().size();
    }

    @Override
    public Object getGroup(int i) {
        return groups.get(i);
    }

    @Override
    public Object getChild(int i, int i2) {
        return groups.get(i).getLayers().get(i2);
    }

    @Override
    public long getGroupId(int i) {
        return groups.get(i).getId();
    }

    @Override
    public long getChildId(int i, int i2) {
        return groups.get(i).getLayers().get(i2).getId();
    }

    @Override
    public boolean hasStableIds() {
        return true;
    }

    @Override
    public View getGroupView(int groupPosition, boolean isExpanded, View convertView, ViewGroup parent) {
        View view = convertView;

        if (view == null) {
            LayoutInflater inflater = (LayoutInflater)context.getSystemService(Context.LAYOUT_INFLATER_SERVICE);
            view = inflater.inflate(R.layout.other_layer_group, null);
        }

        LayerGroup group = groups.get(groupPosition);
        TextView nameView = (TextView)view.findViewById(R.id.group_name);
        nameView.setText(group.getName());
        ImageView statusImage = (ImageView)view.findViewById(R.id.status_image);
        if (isExpanded) {
            statusImage.setImageResource(R.drawable.expander_ic_maximized);
        }
        else {
            statusImage.setImageResource(R.drawable.expander_ic_minimized);
        }
        return view;
    }

    @Override
    public View getChildView(int groupPosition, int childPosition, boolean isLastChild, View convertView, ViewGroup parent) {
        View view = convertView;

        if (view == null) {
            LayoutInflater inflater = (LayoutInflater)context.getSystemService(Context.LAYOUT_INFLATER_SERVICE);
            view = inflater.inflate(R.layout.other_layer_item, null);
        }

        LayerGroup group = groups.get(groupPosition);
        Layer layer = group.getLayers().get(childPosition);
        TextView nameView = (TextView)view.findViewById(R.id.layer_name);
        nameView.setText(layer.getCaption());
        CheckBox checkBox = (CheckBox)view.findViewById(R.id.layer_selected);
        checkBox.setChecked(layer.isVisibility());

        return view;
    }

    @Override
    public boolean isChildSelectable(int i, int i2) {
        return true;
    }
}
