package org.quidity.demo.activity.adapter;

import android.support.v7.widget.RecyclerView;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.CheckBox;
import android.widget.ImageView;
import android.widget.TextView;

import com.oissela.software.multilevelexpindlistview.MultiLevelExpIndListAdapter;

import org.quidity.demo.R;

/**
 * Created by ferdiedanzfuss on 14/12/16.
 */
public class LayerAdapter extends MultiLevelExpIndListAdapter {

    private static final int VIEW_TYPE_LAYER_GROUP = 100;
    private static final int VIEW_TYPE_LAYER = 200;
    private static final int INDENTION_DP = 15;

    private View.OnClickListener onClickListener;
    private View.OnCreateContextMenuListener onCreateContextMenuListener;

    @Override
    public RecyclerView.ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {

        RecyclerView.ViewHolder viewHolder = null;
        View itemView = null;
        LayoutInflater inflater = LayoutInflater.from(parent.getContext());


        if (viewType == VIEW_TYPE_LAYER_GROUP) {
            itemView = inflater.inflate(R.layout.other_layer_group, parent, false);
            viewHolder = new LayerGroupViewHolder(itemView);
        }
        else if(viewType == VIEW_TYPE_LAYER) {
            itemView = inflater.inflate(R.layout.other_layer_item, parent, false);
            viewHolder = new LayerViewHolder(itemView);

            itemView.setOnCreateContextMenuListener(onCreateContextMenuListener);

        }

        itemView.setOnClickListener(onClickListener);

        return viewHolder;
    }

    @Override
    public void onBindViewHolder(RecyclerView.ViewHolder holder, int position) {

        Object item = getItemAt(position);

        if (item instanceof LayerGroupData) {
            LayerGroupData layerGroup = (LayerGroupData)item;
            LayerGroupViewHolder lgHolder = (LayerGroupViewHolder)holder;

            lgHolder.getNameView().setText(layerGroup.getName());

            View itemView = lgHolder.getItemView();
            int leftPadding = (INDENTION_DP * layerGroup.getIndentation()-1);
            itemView.setPadding(leftPadding, itemView.getPaddingTop(), itemView.getPaddingRight(), itemView.getPaddingBottom());

            if (layerGroup.isGroup()) {
                lgHolder.getStatusView().setImageResource(R.drawable.expander_ic_minimized);
            }
            else {
                lgHolder.getStatusView().setImageResource(R.drawable.expander_ic_maximized);
            }
        }
        else if (item instanceof LayerData) {
            LayerData layerData = (LayerData)item;
            LayerViewHolder lHolder = (LayerViewHolder)holder;

            lHolder.getNameView().setText(layerData.getLayer().getCaption());
            lHolder.getSelectedView().setChecked(layerData.getLayer().isVisibility());

            View itemView = lHolder.getItemView();
            int leftPadding = (INDENTION_DP * layerData.getIndentation()-1);
            itemView.setPadding(leftPadding, itemView.getPaddingTop(), itemView.getPaddingRight(), itemView.getPaddingBottom());
        }

    }

    @Override
    public int getItemViewType(int position) {
        int type = 0;

        Object item = getItemAt(position);
        if (item instanceof LayerGroupData) {
            type = VIEW_TYPE_LAYER_GROUP;
        }
        else if (item instanceof LayerData) {
            type = VIEW_TYPE_LAYER;
        }

        return type;
    }

    public View.OnClickListener getOnClickListener() {
        return onClickListener;
    }

    public void setOnClickListener(View.OnClickListener onClickListener) {
        this.onClickListener = onClickListener;
    }

    public View.OnCreateContextMenuListener getOnCreateContextMenuListener() {
        return onCreateContextMenuListener;
    }

    public void setOnCreateContextMenuListener(View.OnCreateContextMenuListener onCreateContextMenuListener) {
        this.onCreateContextMenuListener = onCreateContextMenuListener;
    }

    private class LayerGroupViewHolder extends RecyclerView.ViewHolder {

        private View itemView;
        private TextView nameView;
        private ImageView statusView;


        public LayerGroupViewHolder(View itemView) {
            super(itemView);

            this.itemView = itemView;
            nameView = (TextView)itemView.findViewById(R.id.group_name);
            statusView = (ImageView)itemView.findViewById(R.id.status_image);
        }

        public View getItemView() {
            return itemView;
        }

        public TextView getNameView() {
            return nameView;
        }

        public ImageView getStatusView() {
            return statusView;
        }
    }

    private class LayerViewHolder extends RecyclerView.ViewHolder {

        private View itemView;
        private TextView nameView;
        private CheckBox selectedView;

        public LayerViewHolder(View itemView) {
            super(itemView);

            this.itemView = itemView;
            nameView = (TextView)itemView.findViewById(R.id.layer_name);
            selectedView = (CheckBox)itemView.findViewById(R.id.layer_selected);
        }

        public View getItemView() {
            return itemView;
        }

        public TextView getNameView() {
            return nameView;
        }

        public CheckBox getSelectedView() {
            return selectedView;
        }
    }
}
