package org.quidity.demo.activity;

import android.app.ListActivity;
import android.os.Bundle;
import android.view.View;
import android.widget.ArrayAdapter;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.Toast;

import org.quidity.demo.Session;

import org.quidity.demo.helper.WorkspaceHelper;
import org.quidity.demo.mapi.auth.Workspace;
import org.quidity.demo.util.AppUtil;
import org.quidity.demo.util.GuiUtil;


public class WorkspacesActivity extends ListActivity implements WorkspaceHelper.WorkspaceListener {

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        //setContentView(R.layout.activity_workspaces);

        AppUtil.initActivity(this);

        ListAdapter adapter = new ArrayAdapter<Workspace>(this, android.R.layout.simple_list_item_single_choice, Session.getSession().getWorkspaces());
        getListView().setAdapter(adapter);

        getListView().setChoiceMode(ListView.CHOICE_MODE_SINGLE);

        //show current workspace as selected
        Session session = Session.getSession();
        int currentWorkspaceIndex = session.getWorkspaces().indexOf(session.getCurrentWorkspace());
        getListView().setItemChecked(currentWorkspaceIndex, true);
    }


    @Override
    protected void onListItemClick(ListView l, View v, int position, long id) {
        //Toast.makeText(this, "Clicked on item " + position, Toast.LENGTH_LONG).show();
        Workspace selectedWorkspace = Session.getSession().getWorkspaces().get(position);
        WorkspaceHelper helper = new WorkspaceHelper();
        helper.switchToWorkspace(selectedWorkspace, this);
    }

    @Override
    public void onSwitchToWorkspaceCompleted(Workspace newWorkspace) {
        Toast.makeText(this, "Switched to workspace: " + newWorkspace.getWorkspace(), Toast.LENGTH_LONG).show();
        finish();   //go back to previous activity
    }

    @Override
    public void onSwitchToWorkspaceFailed(String reason) {
        GuiUtil.showError(this, "Could not switch workspaces. " + reason);
    }
}
