package org.quidity.demo.activity;

import android.app.Activity;
import android.app.ProgressDialog;
import android.graphics.Bitmap;
import android.media.MediaPlayer;
import android.support.v7.app.ActionBarActivity;
import android.os.Bundle;
import android.util.Log;
import android.view.Menu;
import android.view.MenuItem;
import android.widget.ImageView;
import android.widget.MediaController;
import android.widget.VideoView;

import org.quidity.demo.R;
import org.quidity.demo.Session;
import org.quidity.demo.helper.AttachmentHelper;
import org.quidity.demo.mapi.attributes.Attachment;
import org.quidity.demo.mapi.attributes.AttachmentsRequest;
import org.quidity.demo.mapi.attributes.AttachmentsResponse;
import org.quidity.demo.mapi.attributes.AttributesService;
import org.quidity.demo.mapi.attributes.Feature;
import org.quidity.demo.mapi.params.Layer;
import org.quidity.demo.util.AppUtil;
import org.quidity.demo.util.GuiUtil;

import java.io.File;

public class VideoAttachmentActivity extends Activity
        implements MediaPlayer.OnPreparedListener,
        AttributesService.AttachmentsListener,
        MediaPlayer.OnCompletionListener {

    //private MediaPlayer mediaPlayer;
    private VideoView videoView;
    private MediaController mediaController;

    private Attachment attachment;
    private ProgressDialog progressDialog;
    private String filePath;
    private long layerId;
    private long primaryId;


    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_video_attachment);

        videoView = (VideoView)findViewById(R.id.video);

        AppUtil.initActivity(this);
    }

    @Override
    protected void onStart() {
        super.onStart();

        loadAttachment();
    }

    private void loadAttachment() {
        Session session = Session.getSession();
        Layer layer = session.getCurrentActiveLayer();
        layerId = layer.getId();
        Feature feature = session.getSelectedFeatures().get(session.getSelectedFeatureIndex());
        attachment = feature.getAttachments().get(session.getSelectedAttachmentIndex());

        String primaryField = layer.getPrimaryField();
        primaryId = getPrimaryId(feature, primaryField);

        filePath = AppUtil.pathForAttachment(this, attachment.getId(), attachment.getHeader());
        Log.d(getClass().getCanonicalName(), filePath);

        //check if the file already exists in cache
        File file = new File(filePath);
        if (file.exists()) {
            Log.d(getClass().getCanonicalName(), "Loading file from cache.");
            initMediaPlayer();
        }
        else {
            progressDialog = new ProgressDialog(this);
            progressDialog.setProgressStyle(ProgressDialog.STYLE_HORIZONTAL);
            progressDialog.setIndeterminate(false);
            progressDialog.setProgressNumberFormat(null);
            progressDialog.setMax(10000);
            progressDialog.setProgress(0);
            progressDialog.setMessage("Downloading...");
            progressDialog.show();

            AttachmentsRequest request = new AttachmentsRequest();
            request.setAttachmentId(attachment.getId());
            request.setLayerId(layer.getId());
            request.setPrimaryId(primaryId);

            AttributesService service = new AttributesService();
            service.attachments(request, filePath, this);
        }
    }

    private long getPrimaryId(Feature feature, String primaryField) {
        String primaryIdStr = (String)feature.getProperties().get(primaryField);
        long primaryId = Long.parseLong(primaryIdStr);

        return primaryId;
    }

    @Override
    public void attachmentsCompleted(AttachmentsResponse response) {
        progressDialog.hide();

        initMediaPlayer();
    }

    @Override
    public void attachmentsFailed(String reason) {
        progressDialog.hide();

        GuiUtil.showError(this, reason);
    }

    @Override
    public void attachmentsDownloadProgress(final double progress) {
        //Log.v(getClass().getCanonicalName(), "Download progress: " + progress);

        final int iProgress = (int)(progress * 100);

        runOnUiThread(new Runnable() {
            @Override
            public void run() {
                progressDialog.setProgress(iProgress);
            }
        });
    }

    private void initMediaPlayer() {
        try {
            videoView.setVideoPath(filePath);
            videoView.setKeepScreenOn(true);
            videoView.setOnPreparedListener(this);
            videoView.setOnCompletionListener(this);

            mediaController = new MediaController(this);
            mediaController.setAnchorView(videoView);

            videoView.setMediaController(mediaController);
        }
        catch (Exception e) {
            GuiUtil.showError(this, e.getLocalizedMessage());
        }


    }

    @Override
    public void onPrepared(MediaPlayer mediaPlayer) {
        videoView.requestFocus();
        videoView.start();
    }

    @Override
    public void onCompletion(MediaPlayer mediaPlayer) {
        mediaController.show();
    }

    @Override
    protected void onStop() {
        super.onStop();


    }

    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        // Inflate the menu; this adds items to the action bar if it is present.
        getMenuInflater().inflate(R.menu.menu_video_attachment, menu);
        return true;
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        // Handle action bar item clicks here. The action bar will
        // automatically handle clicks on the Home/Up button, so long
        // as you specify a parent activity in AndroidManifest.xml.
        int id = item.getItemId();

        //noinspection SimplifiableIfStatement
        if (id == R.id.action_delete) {
            AttachmentHelper helper = new AttachmentHelper(this);
            helper.promptDelete(layerId, primaryId, attachment.getId());
            return true;
        }

        return super.onOptionsItemSelected(item);
    }

}
