package org.quidity.demo.activity;

import android.app.Activity;
import android.app.ProgressDialog;
import android.content.Context;
import android.graphics.Bitmap;
import android.os.Environment;
import android.support.v7.app.ActionBarActivity;
import android.os.Bundle;
import android.util.Log;
import android.view.Menu;
import android.view.MenuItem;
import android.view.WindowManager;
import android.widget.EditText;
import android.widget.ImageView;

import org.apache.commons.io.IOUtils;
import org.quidity.demo.R;
import org.quidity.demo.Session;
import org.quidity.demo.helper.AttachmentHelper;
import org.quidity.demo.mapi.attributes.Attachment;
import org.quidity.demo.mapi.attributes.AttachmentsRequest;
import org.quidity.demo.mapi.attributes.AttachmentsResponse;
import org.quidity.demo.mapi.attributes.AttributesService;
import org.quidity.demo.mapi.attributes.Feature;
import org.quidity.demo.mapi.params.Layer;
import org.quidity.demo.util.AppUtil;
import org.quidity.demo.util.GuiUtil;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;

public class TextAttachmentActivity extends Activity implements AttributesService.AttachmentsListener {

    private EditText textField;
    private Attachment attachment;
    private ProgressDialog progressDialog;
    private String filePath;
    private long layerId;
    private long primaryId;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_text_attachment);

        textField = (EditText)findViewById(R.id.text);

        textField.requestFocus();
        //getWindow().setSoftInputMode(WindowManager.LayoutParams.SOFT_INPUT_STATE_VISIBLE);

        loadAttachment();
    }


    private void loadAttachment() {
        Session session = Session.getSession();
        Layer layer = session.getCurrentActiveLayer();
        layerId = layer.getId();
        Feature feature = session.getSelectedFeatures().get(session.getSelectedFeatureIndex());
        attachment = feature.getAttachments().get(session.getSelectedAttachmentIndex());

        String primaryField = layer.getPrimaryField();
        long primaryId = getPrimaryId(feature, primaryField);

        filePath = AppUtil.pathForAttachment(this, attachment.getId(), attachment.getHeader());
        Log.d(getClass().getCanonicalName(), filePath);

        //check if the file already exists in cache
        File file = new File(filePath);
        if (file.exists()) {
            Log.d(getClass().getCanonicalName(), "Loading file from cache.");
            showAttachment();
        }
        else {
            progressDialog = new ProgressDialog(this);
            progressDialog.setProgressStyle(ProgressDialog.STYLE_HORIZONTAL);
            progressDialog.setIndeterminate(false);
            progressDialog.setProgressNumberFormat(null);
            progressDialog.setMax(10000);
            progressDialog.setProgress(0);
            progressDialog.setMessage("Downloading...");
            progressDialog.show();

            AttachmentsRequest request = new AttachmentsRequest();
            request.setAttachmentId(attachment.getId());
            request.setLayerId(layer.getId());
            request.setPrimaryId(primaryId);

            AttributesService service = new AttributesService();
            service.attachments(request, filePath, this);
        }
    }

    private long getPrimaryId(Feature feature, String primaryField) {
        String primaryIdStr = (String)feature.getProperties().get(primaryField);
        long primaryId = Long.parseLong(primaryIdStr);

        return primaryId;
    }

    @Override
    public void attachmentsCompleted(AttachmentsResponse response) {
        progressDialog.hide();

        showAttachment();
    }


    @Override
    public void attachmentsFailed(String reason) {
        progressDialog.hide();

        GuiUtil.showError(this, reason);
    }

    @Override
    public void attachmentsDownloadProgress(final double progress) {
        //Log.v(getClass().getCanonicalName(), "Download progress: " + progress);

        final int iProgress = (int)(progress * 100);

        runOnUiThread(new Runnable() {
            @Override
            public void run() {
                progressDialog.setProgress(iProgress);
            }
        });
    }

    private void showAttachment() {
        try {
            FileInputStream fis = new FileInputStream(filePath);
            String str = IOUtils.toString(fis);
            fis.close();

            textField.setText(str);
        }
        catch(Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        // Inflate the menu; this adds items to the action bar if it is present.
        getMenuInflater().inflate(R.menu.menu_image_attachment, menu);
        return true;
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        // Handle action bar item clicks here. The action bar will
        // automatically handle clicks on the Home/Up button, so long
        // as you specify a parent activity in AndroidManifest.xml.
        int id = item.getItemId();

        //noinspection SimplifiableIfStatement
        if (id == R.id.action_delete) {
            AttachmentHelper helper = new AttachmentHelper(this);
            helper.promptDelete(layerId, primaryId, attachment.getId());
            return true;
        }

        return super.onOptionsItemSelected(item);
    }

    /*
    private void save() {

        try {
            File file = File.createTempFile("OneMap", ".txt", Environment.getExternalStoragePublicDirectory(Environment.DIRECTORY_PICTURES));
            Log.d(getClass().getCanonicalName(), file.getAbsolutePath());

            FileWriter writer = new FileWriter(file, false);
            writer.write(textField.getText().toString());
            writer.flush();
            writer.close();

            finish();
        }
        catch (IOException e) {
            GuiUtil.showError(this, e.getLocalizedMessage());
        }


    }
    */
}
