package org.quidity.demo.activity;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.DialogInterface;
import android.os.Bundle;
import android.util.Log;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.webkit.WebView;
import android.widget.Button;
import android.widget.CompoundButton;
import android.widget.EditText;
import android.widget.Switch;
import android.widget.Toast;


import org.quidity.demo.R;
import org.quidity.demo.Settings;
import org.quidity.demo.mapi.params.EditTemplate;
import org.quidity.demo.util.AppUtil;
import org.quidity.demo.util.GuiUtil;

import java.io.File;

public class SettingsActivity extends Activity {

    private Switch autoZoomSwitch;
    private Switch keepScreenOnSwitch;
    private Switch captureImageLocationSwitch;
    private EditText desiredAccuracyField;
    private Switch logLocationSwitch;
    private EditText logLocationIntervalField;
    private Button saveButton;
    private Button clearCacheButton;


    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_settings);

        AppUtil.initActivity(this);

        autoZoomSwitch = (Switch)findViewById(R.id.auto_zoom);
        keepScreenOnSwitch = (Switch)findViewById(R.id.keep_screen_on);
        logLocationSwitch = (Switch)findViewById(R.id.log_location);
        logLocationIntervalField = (EditText)findViewById(R.id.log_location_interval);
        captureImageLocationSwitch = (Switch)findViewById(R.id.capture_image_location);
        desiredAccuracyField = (EditText)findViewById(R.id.desired_accuracy);
        saveButton = (Button)findViewById(R.id.save);
        clearCacheButton = (Button)findViewById(R.id.clear_cache);

        Settings settings = Settings.getSettings(this);
        autoZoomSwitch.setChecked(settings.isAutoZoomEnabled());
        keepScreenOnSwitch.setChecked(settings.isKeepScreenOn());

        logLocationSwitch.setChecked(settings.isLogLocation());
        String intervalStr = Integer.toString(settings.getLogLocationInterval());
        logLocationIntervalField.setText(intervalStr);

        captureImageLocationSwitch.setChecked(settings.isCaptureImageLocation());
        String accuracyStr = Integer.toString(settings.getDesiredAccuracy());
        desiredAccuracyField.setText(accuracyStr);

        clearCacheButton.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                promptClearCache();
            }
        });

        saveButton.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                save();
            }
        });

    }

    private void save() {

        int logLocationInterval = -1;
        try {
            logLocationInterval = Integer.parseInt(logLocationIntervalField.getText().toString());
        }
        catch (Exception e) {
            GuiUtil.showWarning(this, "Invalid log interval.");
            logLocationIntervalField.requestFocus();
            return;
        }

        if (logLocationInterval < 5) {
            GuiUtil.showWarning(this, "Log interval should be at least 5 seconds.");
            return;
        }

        int desiredAccuracy = -1;
        try {
            desiredAccuracy = Integer.parseInt(desiredAccuracyField.getText().toString());
        }
        catch (Exception e) {
            GuiUtil.showWarning(this, "Invalid desired accuracy.");
            desiredAccuracyField.requestFocus();
            return;
        }

        if (logLocationInterval < 5) {
            GuiUtil.showWarning(this, "Log interval should be at least 5 seconds.");
            return;
        }

        Settings settings = Settings.getSettings(this);
        settings.setLogLocationInterval(logLocationInterval);
        settings.setAutoZoomEnabled(autoZoomSwitch.isChecked());
        settings.setKeepScreenOn(keepScreenOnSwitch.isChecked());
        settings.setLogLocation(logLocationSwitch.isChecked());
        settings.setCaptureImageLocation(captureImageLocationSwitch.isChecked());
        settings.setDesiredAccuracy(desiredAccuracy);

        Toast.makeText(this, "Settings saved.", Toast.LENGTH_SHORT).show();
        finish();
    }

    private void promptClearCache() {
        AlertDialog.Builder builder = new AlertDialog.Builder(this);
        builder.setTitle("Clear Cache")
                .setMessage("Are you sure you want to clear the cache?")
                .setPositiveButton("Yes", new DialogInterface.OnClickListener() {
                    @Override
                    public void onClick(DialogInterface dialogInterface, int i) {
                        clearCache();
                    }
                })
                .setNegativeButton("No", null);
        AlertDialog dialog = builder.create();
        dialog.show();
    }

    private void clearCache() {
        clearAttachmentsCache();
        clearWebViewCache();

        Toast.makeText(this, "Cache cleared.", Toast.LENGTH_SHORT).show();
    }

    private void clearAttachmentsCache() {
        Log.d(getClass().getCanonicalName(), "Clearing attachments cache.");

        File cacheDir = this.getCacheDir();
        for (File file : cacheDir.listFiles()) {
            boolean deleted = file.delete();

            String className = getClass().getCanonicalName();
            if (deleted) {
                Log.d(className, "Deleted " + file.getAbsolutePath());
            }
            else {
                Log.d(className, "Could NOT delete " + file.getAbsolutePath());
            }
        }

    }

    private void clearWebViewCache() {
        Log.d(getClass().getCanonicalName(), "Clearing WebView cache.");
        WebView webView = new WebView(this);
        webView.clearCache(true);
    }


    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        // Inflate the menu; this adds items to the action bar if it is present.
        getMenuInflater().inflate(R.menu.settings, menu);
        return true;
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        // Handle action bar item clicks here. The action bar will
        // automatically handle clicks on the Home/Up button, so long
        // as you specify a parent activity in AndroidManifest.xml.
        int id = item.getItemId();
        if (id == R.id.action_settings) {
            return true;
        }
        return super.onOptionsItemSelected(item);
    }
}
