package org.quidity.demo.activity;

import android.app.Activity;
import android.app.ListActivity;
import android.content.Intent;
import android.os.Bundle;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.widget.ArrayAdapter;
import android.widget.ListAdapter;
import android.widget.ListView;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;

import java.lang.reflect.Type;
import java.util.List;

import org.quidity.demo.R;
import org.quidity.demo.mapi.location.StreetAddress;
import org.quidity.demo.util.AppUtil;

public class SearchResultsActivity extends ListActivity {

    List<StreetAddress> items;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        //setContentView(R.layout.activity_search_results);

        AppUtil.initActivity(this);

        //deserialize items
        String itemsStr = getIntent().getStringExtra("items");
        Gson gson = new Gson();
        Type itemsType = new TypeToken<List<StreetAddress>>(){}.getType();
        items = gson.fromJson(itemsStr, itemsType);

        ListAdapter adapter = new ArrayAdapter<StreetAddress>(this, android.R.layout.simple_list_item_1, items);
        getListView().setAdapter(adapter);

        //getListView().setChoiceMode(ListView.CHOICE_MODE_SINGLE);

    }

    @Override
    protected void onListItemClick(ListView l, View v, int position, long id) {
        StreetAddress address = items.get(position);

        Intent intent = new Intent(this, OpenLayersMapActivity.class);
        //intent.putExtra(OpenLayersMapActivity.EXTRA_ACTION, OpenLayersMapActivity.ACTION_MOVE_TO_POINT);
        intent.putExtra(OpenLayersMapActivity.EXTRA_LATITUDE, address.getCentLat());
        intent.putExtra(OpenLayersMapActivity.EXTRA_LONGITUDE, address.getCentLong());

        //intent.setFlags(Intent.FLAG_ACTIVITY_CLEAR_TOP);
        //startActivity(intent);
        setResult(Activity.RESULT_OK, intent);
        finish();
    }

    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        // Inflate the menu; this adds items to the action bar if it is present.
        getMenuInflater().inflate(R.menu.search_results, menu);
        return true;
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        // Handle action bar item clicks here. The action bar will
        // automatically handle clicks on the Home/Up button, so long
        // as you specify a parent activity in AndroidManifest.xml.
        int id = item.getItemId();
        if (id == R.id.action_settings) {
            return true;
        }
        return super.onOptionsItemSelected(item);
    }
}
