package org.quidity.demo.activity;

import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.EditText;
import android.widget.Spinner;

import com.google.gson.Gson;

import java.util.ArrayList;
import java.util.List;

import org.quidity.demo.R;
import org.quidity.demo.mapi.location.LocationService;
import org.quidity.demo.mapi.location.SearchAddressRequest;
import org.quidity.demo.mapi.location.SearchAddressResponse;
import org.quidity.demo.mapi.location.SearchErfRequest;
import org.quidity.demo.mapi.location.SearchErfResponse;
import org.quidity.demo.util.AppUtil;
import org.quidity.demo.util.GuiUtil;

public class SearchActivity extends Activity implements LocationService.SearchAddressListener, LocationService.SearchErfListener {

    private ViewGroup addressLayout;
    private ViewGroup erfLayout;

    private Spinner searchTypeSpinner;
    private EditText addressField;
    private Button searchButton;

    private EditText cityField;
    private EditText erfField;

    private static final String SEARCH_TYPE_STREET_ADDRESS = "Street Address";
    private static final String SEARCH_TYPE_ERF_NO = "Erf No";
    private List<String> searchTypes;
    private String currentSearchType = SEARCH_TYPE_STREET_ADDRESS;  //default

    public SearchActivity() {
        searchTypes = new ArrayList<String>();
        searchTypes.add(SEARCH_TYPE_STREET_ADDRESS);
        searchTypes.add(SEARCH_TYPE_ERF_NO);
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_search);

        AppUtil.initActivity(this);

        addressLayout = (ViewGroup)findViewById(R.id.address_layout);
        erfLayout = (ViewGroup)findViewById(R.id.erf_layout);

        searchTypeSpinner = (Spinner)findViewById(R.id.search_type);
        addressField = (EditText)findViewById(R.id.address_field);
        searchButton = (Button)findViewById(R.id.search_button);

        cityField = (EditText)findViewById(R.id.city_field);
        erfField = (EditText)findViewById(R.id.erf_field);

        searchButton.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                search();
            }
        });

        ArrayAdapter<String> adapter = new ArrayAdapter<String>(this, android.R.layout.simple_spinner_dropdown_item, searchTypes);
        searchTypeSpinner.setAdapter(adapter);
        searchTypeSpinner.setOnItemSelectedListener(new AdapterView.OnItemSelectedListener() {
            @Override
            public void onItemSelected(AdapterView<?> parent, View view, int position, long id) {
                searchTypeChanged(searchTypes.get(position));
            }

            @Override
            public void onNothingSelected(AdapterView<?> adapterView) {

            }
        });
    }

    private void searchTypeChanged(String searchType) {

        addressLayout.setVisibility(View.GONE);
        erfLayout.setVisibility(View.GONE);

        if (searchType.equalsIgnoreCase(SEARCH_TYPE_STREET_ADDRESS)) {
            addressLayout.setVisibility(View.VISIBLE);
            GuiUtil.focus(this, addressField);
        }
        else if(searchType.equalsIgnoreCase(SEARCH_TYPE_ERF_NO)) {
            erfLayout.setVisibility(View.VISIBLE);
            GuiUtil.focus(this, cityField);
        }

        currentSearchType = searchType;
    }

    private void search() {

        if (currentSearchType.equalsIgnoreCase(SEARCH_TYPE_STREET_ADDRESS)) {
            String address = addressField.getText().toString();
            if (address.trim().length() == 0) {
                GuiUtil.showWarning(this, "Please enter an address.");
                return;
            }

            LocationService service = new LocationService();
            SearchAddressRequest request = new SearchAddressRequest();
            request.setAddress(address);
            request.setStart(0);
            request.setLimit(50);
            service.searchAddress(request, this);
        }
        else if (currentSearchType.equalsIgnoreCase(SEARCH_TYPE_ERF_NO)) {
            String city = cityField.getText().toString();
            String erfNo = erfField.getText().toString();

            if (city.trim().length() == 0) {
                GuiUtil.showWarning(this, "Please enter a city or township.");
                return;
            }
            if (erfNo.trim().length() == 0) {
                GuiUtil.showWarning(this, "Please enter erf no.");
                return;
            }

            LocationService service = new LocationService();
            SearchErfRequest request = new SearchErfRequest();
            String searchString = city + " " + erfNo;
            request.setSearchString(searchString);
            request.setStart(0);
            request.setLimit(50);
            service.searchErf(request, this);
        }
    }


    @Override
    public void onSearchAddressCompleted(SearchAddressResponse response) {

        Intent intent = new Intent(this, SearchResultsActivity.class);

        //serialize the response items so we can pass them to the results activity
        Gson gson = new Gson();
        String itemsStr = gson.toJson(response.getItems());
        intent.putExtra("items", itemsStr);

        intent.setFlags(Intent.FLAG_ACTIVITY_FORWARD_RESULT);

        startActivity(intent);

        //Toast.makeText(this, "Under construction. Number of results " + response.getItems().size(), Toast.LENGTH_SHORT);
    }

    @Override
    public void onSearchAddressFailed(String reason) {
        GuiUtil.showError(this, reason);
    }

    @Override
    public void onSearchErfCompleted(SearchErfResponse response) {

        Intent intent = new Intent(this, SearchResultsActivity.class);

        //serialize the response items so we can pass them to the results activity
        Gson gson = new Gson();
        String itemsStr = gson.toJson(response.getItems());
        intent.putExtra("items", itemsStr);

        startActivity(intent);

    }

    @Override
    public void onSearchErfFailed(String reason) {
        GuiUtil.showError(this, reason);
    }

    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        // Inflate the menu; this adds items to the action bar if it is present.
        getMenuInflater().inflate(R.menu.search, menu);
        return true;
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        // Handle action bar item clicks here. The action bar will
        // automatically handle clicks on the Home/Up button, so long
        // as you specify a parent activity in AndroidManifest.xml.
        int id = item.getItemId();
        if (id == R.id.action_settings) {
            return true;
        }
        return super.onOptionsItemSelected(item);
    }
}
