package org.quidity.demo.activity;

import android.app.Activity;
import android.content.Intent;
import android.support.v7.app.ActionBarActivity;
import android.os.Bundle;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.view.ContextMenu;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.widget.AdapterView;
import android.widget.CheckBox;
import android.widget.Toast;

import com.oissela.software.multilevelexpindlistview.MultiLevelExpIndListAdapter;

import org.quidity.demo.R;
import org.quidity.demo.Session;
import org.quidity.demo.activity.adapter.LayerAdapter;
import org.quidity.demo.activity.adapter.LayerData;
import org.quidity.demo.activity.adapter.LayerGroupData;
import org.quidity.demo.mapi.params.Layer;
import org.quidity.demo.util.AppUtil;

public class OtherLayersMultiExpandableActivity extends Activity {


    private LayerGroupData rootGroup;
    private RecyclerView recyclerView;
    private LinearLayoutManager layoutManager;
    private LayerAdapter adapter;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_other_layers_multi_expandable);

        AppUtil.initActivity(this);

        recyclerView = (RecyclerView)findViewById(R.id.recycler);

        layoutManager = new LinearLayoutManager(this);
        recyclerView.setLayoutManager(layoutManager);

        loadData();

        adapter = new LayerAdapter();
        adapter.addAll(rootGroup.getChildren());
        recyclerView.setHasFixedSize(true);
        recyclerView.setAdapter(adapter);

        adapter.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                int position = recyclerView.getChildPosition(view);

                MultiLevelExpIndListAdapter.ExpIndData data = adapter.getItemAt(position);
                if (data instanceof LayerData) {
                    LayerData layerData = (LayerData)data;
                    Layer layer = layerData.getLayer();
                    layer.setVisibility(!layer.isVisibility()); //toggle
                    CheckBox checkBox = (CheckBox)view.findViewById(R.id.layer_selected);
                    checkBox.setChecked(layer.isVisibility());
                }
                else {
                    adapter.toggleGroup(position);
                    adapter.toggleGroup(position);
                    adapter.toggleGroup(position);
                }
            }
        });

        adapter.expandGroup(0);
        adapter.collapseGroup(0);
        adapter.expandGroup(0);

        adapter.setOnCreateContextMenuListener(new View.OnCreateContextMenuListener() {
            @Override
            public void onCreateContextMenu(ContextMenu contextMenu, View view, ContextMenu.ContextMenuInfo contextMenuInfo) {
                int position = recyclerView.getChildPosition(view);

                MultiLevelExpIndListAdapter.ExpIndData data = adapter.getItemAt(position);
                if (data instanceof LayerData) {
                    LayerData layerData = (LayerData)data;
                    final Layer layer = layerData.getLayer();

                    contextMenu.setHeaderTitle(layer.getCaption());
                    MenuItem menuItem = contextMenu.add("Change Opacity");
                    menuItem.setOnMenuItemClickListener(new MenuItem.OnMenuItemClickListener() {
                        @Override
                        public boolean onMenuItemClick(MenuItem menuItem) {
                            showOpacityScreen(layer);
                            return true;
                        }
                    });
                }
            }
        });
    }

    private void showOpacityScreen(Layer layer) {
        Session.getSession().setSelectedLayer(layer);

        Intent intent = new Intent(this, OpacityActivity.class);
        startActivity(intent);
    }

    private void loadData() {
        //Build a layer tree
        rootGroup = new LayerGroupData("Other Layers");
        for (Layer layer : Session.getSession().getLayers()) {
            //ignore base layers
            if(!layer.getBaseLayer()) {
                String rawGroup = layer.getGroup();
                String[] groupArr = rawGroup.split("/");
                LayerGroupData group = rootGroup;
                for (String groupStr : groupArr) {
                    group = getSubGroup(group, groupStr);
                }
                LayerData layerData = new LayerData(layer);

                group.addChild(layerData);
            }
        }
    }

    private LayerGroupData getSubGroup(LayerGroupData baseGroup, String groupName) {
        LayerGroupData subGroup = null;

        for (MultiLevelExpIndListAdapter.ExpIndData data : baseGroup.getChildren()) {
            if (data instanceof LayerGroupData) {
                LayerGroupData groupData = (LayerGroupData)data;
                if (groupData.getName().equalsIgnoreCase(groupName)) {
                    subGroup = groupData;
                }
            }
        }

        if (subGroup == null) {
            subGroup = new LayerGroupData(groupName);
            baseGroup.addChild(subGroup);
        }

        return subGroup;
    }



    /*
    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        // Inflate the menu; this adds items to the action bar if it is present.
        getMenuInflater().inflate(R.menu.menu_other_layers_multi_expandable, menu);
        return true;
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        // Handle action bar item clicks here. The action bar will
        // automatically handle clicks on the Home/Up button, so long
        // as you specify a parent activity in AndroidManifest.xml.
        int id = item.getItemId();

        //noinspection SimplifiableIfStatement
        if (id == R.id.action_settings) {
            return true;
        }

        return super.onOptionsItemSelected(item);
    }
    */
}
