package org.quidity.demo.activity;

import android.app.Activity;
import android.os.Bundle;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.widget.CheckBox;
import android.widget.ExpandableListView;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

import org.quidity.demo.R;
import org.quidity.demo.Session;
import org.quidity.demo.activity.adapter.LayerGroup;
import org.quidity.demo.activity.adapter.OtherLayerAdapter;
import org.quidity.demo.mapi.params.Layer;
import org.quidity.demo.util.AppUtil;

public class OtherLayersExpandableActivity extends Activity {

    private List<LayerGroup> groups;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_other_layers_expandable);

        AppUtil.initActivity(this);

        determineLayerGroups();

        ExpandableListView listView = (ExpandableListView)findViewById(R.id.list);
        OtherLayerAdapter adapter = new OtherLayerAdapter(this, groups);
        listView.setAdapter(adapter);

        listView.setOnChildClickListener(new ExpandableListView.OnChildClickListener() {
            @Override
            public boolean onChildClick(ExpandableListView parent, View view, int groupPosition, int childPosition, long id) {
                Layer layer = groups.get(groupPosition).getLayers().get(childPosition);
                layer.setVisibility(!layer.isVisibility()); //toggle
                CheckBox checkBox = (CheckBox)view.findViewById(R.id.layer_selected);
                checkBox.setChecked(layer.isVisibility());

                return true;
            }
        });

    }

    private void determineLayerGroups() {
        groups = new ArrayList<LayerGroup>();

        for (Layer layer : Session.getSession().getLayers()) {
            if (!layer.getBaseLayer()) {
                LayerGroup group = getLayerGroup(layer.getGroup());
                group.getLayers().add(layer);
            }
        }

        //sort
        for (LayerGroup group : groups) {
            Collections.sort(group.getLayers());
        }
    }

    private LayerGroup getLayerGroup(String groupName) {
        for (LayerGroup group : groups) {
            if (group.getName().equalsIgnoreCase(groupName)) {
                return group;
            }
        }

        //Not found, create a new group
        LayerGroup group = new LayerGroup();
        group.setName(groupName);
        groups.add(group);

        return group;
    }


    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        // Inflate the menu; this adds items to the action bar if it is present.
        getMenuInflater().inflate(R.menu.other_layers_expandable, menu);
        return true;
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        // Handle action bar item clicks here. The action bar will
        // automatically handle clicks on the Home/Up button, so long
        // as you specify a parent activity in AndroidManifest.xml.
        int id = item.getItemId();
        if (id == R.id.action_settings) {
            return true;
        }
        return super.onOptionsItemSelected(item);
    }
}
