package org.quidity.demo.activity;

import android.app.ListActivity;
import android.os.Bundle;
import android.view.View;
import android.widget.ArrayAdapter;
import android.widget.ListAdapter;
import android.widget.ListView;

import java.util.ArrayList;
import java.util.List;

import org.quidity.demo.Session;

import org.quidity.demo.mapi.params.Layer;
import org.quidity.demo.util.AppUtil;


public class OtherLayersActivity extends ListActivity {

    private List<Layer> otherLayers;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);

        AppUtil.initActivity(this);

        determineOtherLayers();

        ListAdapter adapter = new ArrayAdapter<Layer>(this, android.R.layout.simple_list_item_multiple_choice, otherLayers);
        getListView().setAdapter(adapter);

        getListView().setChoiceMode(ListView.CHOICE_MODE_MULTIPLE);

        checkVisibleLayers();
    }

    private void checkVisibleLayers() {
        //set currently selected layers
        for (Layer layer : otherLayers) {
            int index = otherLayers.indexOf(layer);
            getListView().setItemChecked(index, layer.isVisibility());
        }
    }

    private void determineOtherLayers() {
        otherLayers = new ArrayList<Layer>();
        for(Layer layer : Session.getSession().getLayers()) {
            if (!layer.getBaseLayer()) {
                otherLayers.add(layer);
            }
        }
    }

    @Override
    protected void onListItemClick(ListView l, View v, int position, long id) {
        //Toast.makeText(this, "Under Construction", Toast.LENGTH_SHORT).show();
        boolean selected = getListView().isItemChecked(position);
        otherLayers.get(position).setVisibility(selected);
    }
}
