package org.quidity.demo.activity;

import android.app.Activity;
import android.support.v7.app.ActionBarActivity;
import android.os.Bundle;
import android.util.Log;
import android.view.Menu;
import android.view.MenuItem;
import android.view.ViewGroup;
import android.widget.SeekBar;
import android.widget.TextView;

import org.quidity.demo.R;
import org.quidity.demo.Session;
import org.quidity.demo.mapi.params.Layer;
import org.quidity.demo.util.AppUtil;
import org.w3c.dom.Text;

public class OpacityActivity extends Activity implements SeekBar.OnSeekBarChangeListener {

    private ViewGroup containerView;
    private TextView headerView;
    private SeekBar sliderView;
    private TextView statusView;
    private int opacityPerc;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_opacity);

        AppUtil.initActivity(this);

        containerView = (ViewGroup)findViewById(R.id.container);
        headerView = (TextView)findViewById(R.id.header);
        sliderView = (SeekBar)findViewById(R.id.slider);
        statusView = (TextView)findViewById(R.id.status);

        Layer layer = Session.getSession().getSelectedLayer();
        headerView.setText("Opacity for " + layer.getCaption());

        sliderView.setMax(100);
        opacityPerc = percentage(layer.getOpacity());
        sliderView.setProgress(opacityPerc);
        sliderView.setOnSeekBarChangeListener(this);

        statusView.setText(opacityPerc + "%");
    }

    private int percentage(double value) {
        return (int)Math.round(value * 100);
    }

    private void updateStatus() {
        statusView.setText(opacityPerc + "%");

        /*
        float alpha = (float)opacityPerc / 100.0f;
        containerView.setAlpha(alpha);
        */
    }

    @Override
    public void onProgressChanged(SeekBar seekBar, int progress, boolean fromUser) {
        opacityPerc = progress;

        updateStatus();
        saveOpacity();
    }

    @Override
    public void onStartTrackingTouch(SeekBar seekBar) {

    }

    @Override
    public void onStopTrackingTouch(SeekBar seekBar) {

    }


    private void saveOpacity() {
        Layer layer = Session.getSession().getSelectedLayer();
        double opacity = (double)opacityPerc / 100.0;
        //Log.d(getClass().getCanonicalName(), "Saving new opacity value " + opacity);
        layer.setOpacity(opacity);
    }



/*
    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        // Inflate the menu; this adds items to the action bar if it is present.
        getMenuInflater().inflate(R.menu.menu_opacity, menu);
        return true;
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        // Handle action bar item clicks here. The action bar will
        // automatically handle clicks on the Home/Up button, so long
        // as you specify a parent activity in AndroidManifest.xml.
        int id = item.getItemId();

        //noinspection SimplifiableIfStatement
        if (id == R.id.action_save) {
            saveOpacity();
            return true;
        }

        return super.onOptionsItemSelected(item);
    }
*/

}
