package org.quidity.demo.activity;

import android.widget.Toast;

/**
 * Created by ferdiedanzfuss on 2014/10/02.
 */
public class OneMapJavascriptInterface {

    private int currentZoomLevel;
    private double currentLatitude;
    private double currentLongitude;
    private OpenLayersMapActivity mapActivity;

    public OneMapJavascriptInterface(OpenLayersMapActivity mapActivity) {
        this.mapActivity = mapActivity;
    }

    public int getCurrentZoomLevel() {
        return currentZoomLevel;
    }


    @android.webkit.JavascriptInterface
    public void setCurrentZoomLevel(int currentZoomLevel) {
        this.currentZoomLevel = currentZoomLevel;
    }

    public double getCurrentLatitude() {
        return currentLatitude;
    }

    @android.webkit.JavascriptInterface
    public void setCurrentLatitude(double currentLatitude) {
        this.currentLatitude = currentLatitude;
    }

    public double getCurrentLongitude() {
        return currentLongitude;
    }

    @android.webkit.JavascriptInterface
    public void setCurrentLongitude(double currentLongitude) {
        this.currentLongitude = currentLongitude;
    }


    @android.webkit.JavascriptInterface
    public void mapClicked(double latitude, double longitude) {

        //String msg = "Map clicked at " + latitude + ", " + longitude;
        //Toast.makeText(mapActivity, msg, Toast.LENGTH_SHORT).show();

        //forward event to the map activity
        if (mapActivity != null) {
            mapActivity.mapClicked(latitude, longitude);
        }

    }

}
