package org.quidity.demo.activity;

import android.app.ProgressDialog;
import android.app.Activity;
import android.content.Intent;
import android.hardware.Camera;
import android.os.Bundle;
import android.text.Html;
import android.text.TextUtils;
import android.text.method.LinkMovementMethod;
import android.util.Log;
import android.view.Display;
import android.view.Menu;
import android.view.MenuItem;
import android.view.Surface;
import android.view.View;
import android.widget.Button;
import android.widget.EditText;
import android.widget.TextView;

import com.google.android.gms.analytics.Tracker;

import org.quidity.demo.OneMapApplication;
import org.quidity.demo.R;
import org.quidity.demo.Session;
import org.quidity.demo.Settings;
import org.quidity.demo.helper.WorkspaceHelper;
import org.quidity.demo.mapi.auth.AuthorizationService;
import org.quidity.demo.mapi.auth.LoginRequest;
import org.quidity.demo.mapi.auth.LoginResponse;
import org.quidity.demo.mapi.auth.Workspace;
import org.quidity.demo.util.AppUtil;
import org.quidity.demo.util.GuiUtil;

public class Login2Activity extends Activity implements AuthorizationService.LoginListener, WorkspaceHelper.WorkspaceListener {

    private EditText usernameField;
    private EditText passwordField;
    private Button submitButton;
    private TextView registerView;
    private TextView forgotPasswordView;
    private ProgressDialog progressDialog;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_login2);

        int orientation = GuiUtil.getScreenOrientation(this);
        Session.getSession().setOrientation(orientation);

        AppUtil.initActivity(this);

        usernameField = (EditText)findViewById(R.id.username);
        passwordField = (EditText)findViewById(R.id.password);
        submitButton = (Button)findViewById(R.id.submit_button);
        registerView = (TextView)findViewById(R.id.register);
        forgotPasswordView = (TextView)findViewById(R.id.forgot_password);

        registerView.setText(Html.fromHtml("<a href='http://www.1map.co.za/register'>Register</a>"));
        registerView.setMovementMethod(LinkMovementMethod.getInstance());

        forgotPasswordView.setText(Html.fromHtml("<a href='http://www.1map.co.za/forgot_password'>Forgot Password</a>"));
        forgotPasswordView.setMovementMethod(LinkMovementMethod.getInstance());

        String username = Settings.getSettings(this).getPreviousUsername();
        usernameField.setText(username);
        if (username.trim().length() > 0) {
            passwordField.requestFocus();
        }

        submitButton.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View view) {
                attemptLogin();
            }
        });


    }



    /**
     * Attempts to sign in or register the account specified by the login form.
     * If there are form errors (invalid email, missing fields, etc.), the
     * errors are presented and no actual login attempt is made.
     */
    public void attemptLogin() {

        // Reset errors.
        usernameField.setError(null);
        passwordField.setError(null);

        // Store values at the time of the login attempt.
        String email = usernameField.getText().toString();
        String password = passwordField.getText().toString();

        boolean cancel = false;
        View focusView = null;


        // Check for a valid password, if the user entered one.
        if (!TextUtils.isEmpty(password) && !isPasswordValid(password)) {
            passwordField.setError(getString(R.string.error_invalid_password));
            focusView = passwordField;
            cancel = true;
        }

        // Check for a valid email address.
        if (TextUtils.isEmpty(email)) {
            usernameField.setError(getString(R.string.error_field_required));
            focusView = usernameField;
            cancel = true;
        } else if (!isEmailValid(email)) {
            usernameField.setError(getString(R.string.error_invalid_email));
            focusView = usernameField;
            cancel = true;
        }

        if (cancel) {
            // There was an error; don't attempt login and focus the first
            // form field with an error.
            focusView.requestFocus();
        } else {
            // Show a progress spinner, and kick off a background task to
            // perform the user login attempt.
            showProgress(true);


            AuthorizationService authorizationService = new AuthorizationService();
            LoginRequest req = new LoginRequest(email, password);
            authorizationService.login(req, this);
        }
    }

    private boolean isEmailValid(String email) {
        //TODO: Replace this with your own logic
        //return email.contains("@");
        return true;
    }

    private boolean isPasswordValid(String password) {
        //TODO: Replace this with your own logic
        //return password.length() > 4;
        return true;
    }

    private void showProgress(boolean show) {

        if (progressDialog == null) {
            progressDialog = new ProgressDialog(this);
            progressDialog.setIndeterminate(true);
            progressDialog.setMessage("Loading");
        }

        if (show) {
            progressDialog.show();
        }
        else {
            progressDialog.hide();
        }

    }

    @Override
    public void loginCompleted(LoginResponse response) {

        //pass user id to tracker
        int userId = Integer.parseInt(response.getSerial()) - 1000;
        Tracker tracker = ((OneMapApplication)getApplication()).getTracker();
        tracker.set("&uid", Integer.toString(userId));

        //remember username so we can auto populate it next time
        String username = usernameField.getText().toString();
        Settings.getSettings(this).setPreviousUsername(username);

        WorkspaceHelper helper = new WorkspaceHelper();
        helper.switchToWorkspace(response.getDefaultWorkspace(), this);

    }

    @Override
    public void loginFailed(String reason) {

        showProgress(false);

        GuiUtil.showError(this, "Could not log you in. " + reason);
    }

    @Override
    public void onSwitchToWorkspaceCompleted(Workspace newWorkspace) {
        showProgress(false);

        Intent intent = new Intent(Login2Activity.this, OpenLayersMapActivity.class);
        intent.setFlags(Intent.FLAG_ACTIVITY_NEW_TASK | Intent.FLAG_ACTIVITY_CLEAR_TASK);
        startActivity(intent);
    }

    @Override
    public void onSwitchToWorkspaceFailed(String reason) {
        showProgress(false);

        GuiUtil.showError(this, "Could not switch to default workspace. " + reason);
    }

    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        // Inflate the menu; this adds items to the action bar if it is present.
        getMenuInflater().inflate(R.menu.login2, menu);
        return true;
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        // Handle action bar item clicks here. The action bar will
        // automatically handle clicks on the Home/Up button, so long
        // as you specify a parent activity in AndroidManifest.xml.
        int id = item.getItemId();
        if (id == R.id.action_settings) {
            return true;
        }
        return super.onOptionsItemSelected(item);
    }
}
