package org.quidity.demo.activity;

import android.app.Activity;
import android.location.Location;
import android.location.LocationListener;
import android.location.LocationManager;
import android.os.Bundle;
import android.view.Menu;
import android.view.MenuItem;
import android.widget.TextView;

import org.quidity.demo.R;
import org.quidity.demo.util.AppUtil;

public class GPSInfoActivity extends Activity implements LocationListener {

    private TextView latitudeView;
    private TextView longitudeView;
    private TextView altitudeView;
    private TextView accuracyView;
    private TextView speedView;
    private TextView bearingView;

    private LocationManager locationManager;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_gpsinfo);

        AppUtil.initActivity(this);

        latitudeView = (TextView)findViewById(R.id.latitude);
        longitudeView = (TextView)findViewById(R.id.longitude);
        altitudeView = (TextView)findViewById(R.id.altitude);
        accuracyView = (TextView)findViewById(R.id.accuracy);
        speedView = (TextView)findViewById(R.id.speed);
        bearingView = (TextView)findViewById(R.id.bearing);

        locationManager = (LocationManager)getSystemService(LOCATION_SERVICE);
    }

    private void startGPS() {
        locationManager.requestLocationUpdates(LocationManager.GPS_PROVIDER, 0, 0, this);
    }

    private void stopGPS() {
        locationManager.removeUpdates(this);
    }

    @Override
    protected void onPause() {
        stopGPS();
        super.onPause();
    }

    @Override
    protected void onResume() {
        super.onResume();
        startGPS();
    }

    @Override
    public void onLocationChanged(Location location) {
        latitudeView.setText(Double.toString(location.getLatitude()));
        longitudeView.setText(Double.toString(location.getLongitude()));
        if (location.hasAltitude()) {
            altitudeView.setText(Double.toString(location.getAltitude()) + "m");
        }
        if (location.hasAccuracy()) {
            accuracyView.setText(Double.toString(location.getAccuracy()) + "m");
        }
        if (location.hasSpeed()) {
            float speedMps = location.getSpeed();
            float speedKmph = speedMps * 3.6f;
            speedView.setText(Float.toString(speedKmph) + "km/h");
        }
        if (location.hasBearing()) {
            bearingView.setText(Float.toString(location.getBearing()));
        }
    }

    @Override
    public void onStatusChanged(String s, int i, Bundle bundle) {

    }

    @Override
    public void onProviderEnabled(String s) {

    }

    @Override
    public void onProviderDisabled(String s) {

    }

    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        // Inflate the menu; this adds items to the action bar if it is present.
        getMenuInflater().inflate(R.menu.gpsinfo, menu);
        return true;
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        // Handle action bar item clicks here. The action bar will
        // automatically handle clicks on the Home/Up button, so long
        // as you specify a parent activity in AndroidManifest.xml.
        int id = item.getItemId();
        if (id == R.id.action_settings) {
            return true;
        }
        return super.onOptionsItemSelected(item);
    }
}
