package org.quidity.demo.activity;

import android.content.Intent;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentActivity;
import android.support.v4.app.FragmentManager;
import android.support.v4.app.FragmentStatePagerAdapter;
import android.support.v4.view.ViewPager;
import android.support.v7.app.ActionBarActivity;
import android.os.Bundle;
import android.util.Log;
import android.view.Menu;
import android.view.MenuItem;
import org.quidity.demo.R;
import org.quidity.demo.Session;
import org.quidity.demo.fragment.FeatureInfoFragment;
import org.quidity.demo.mapi.params.Layer;

public class FeatureInfoPagerActivity extends FragmentActivity {

    private ViewPager pager;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_feature_info_pager);

        FeaturePagerAdapter adapter = new FeaturePagerAdapter(getSupportFragmentManager());
        pager = (ViewPager)findViewById(R.id.pager);
        pager.setAdapter(adapter);

    }

    @Override
    public boolean onPrepareOptionsMenu(Menu menu) {
        MenuItem editMenu = menu.findItem(R.id.action_edit);
        Layer activeLayer = Session.getSession().getCurrentActiveLayer();
        boolean canEdit = false;
        if (activeLayer != null) {
            canEdit = activeLayer.isEditMetadata();
        }
        else {
            canEdit = false;
        }

        editMenu.setEnabled(canEdit);

        return super.onPrepareOptionsMenu(menu);
    }


    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        // Inflate the menu; this adds items to the action bar if it is present.
        getMenuInflater().inflate(R.menu.feature_info_pager, menu);
        return true;
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        int id = item.getItemId();
        if (id == R.id.action_edit) {
            showEditTemplateScreen();

            return true;
        }
        return super.onOptionsItemSelected(item);
    }

    private void showEditTemplateScreen() {

        Session.getSession().setEditMode(Session.EDIT_MODE_UPDATE);

        int currentIndex = pager.getCurrentItem();
        Session.getSession().setSelectedFeatureIndex(currentIndex);

        Intent intent = new Intent(this, EditTemplateActivity.class);
        startActivity(intent);
    }


    private class FeaturePagerAdapter extends FragmentStatePagerAdapter {



        private FeaturePagerAdapter(FragmentManager fm) {
            super(fm);

        }

        @Override
        public Fragment getItem(int i) {
            Fragment fragment = new FeatureInfoFragment();

            //set feature index
            Bundle args = new Bundle();
            args.putInt(FeatureInfoFragment.FEATURE_INDEX_ARG, i);
            fragment.setArguments(args);

            return fragment;
        }

        @Override
        public int getCount() {
            return Session.getSession().getSelectedFeatures().size();
        }

        @Override
        public CharSequence getPageTitle(int position) {
            return "Feature " + (position + 1);
        }
    }
}
