package org.quidity.demo.activity;

import android.app.Activity;
import android.app.DatePickerDialog;
import android.app.TimePickerDialog;
import android.content.Intent;
import android.graphics.Color;
import android.os.Bundle;
import android.text.InputFilter;
import android.text.InputType;
import android.util.Log;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.CheckBox;
import android.widget.DatePicker;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.Spinner;
import android.widget.TextView;
import android.widget.TimePicker;
import android.widget.Toast;

import com.google.zxing.integration.android.IntentIntegrator;
import com.google.zxing.integration.android.IntentResult;

import org.quidity.demo.R;
import org.quidity.demo.Session;
import org.quidity.demo.helper.FieldHelper;
import org.quidity.demo.mapi.attributes.AddAttributesRequest;
import org.quidity.demo.mapi.attributes.AddAttributesResponse;
import org.quidity.demo.mapi.attributes.AttributesService;
import org.quidity.demo.mapi.attributes.EditAttributesRequest;
import org.quidity.demo.mapi.attributes.EditAttributesResponse;
import org.quidity.demo.mapi.attributes.Feature;
import org.quidity.demo.mapi.attributes.Geometry;
import org.quidity.demo.mapi.params.EditTemplate;
import org.quidity.demo.mapi.params.EditTemplateField;
import org.quidity.demo.mapi.params.EditTemplateFieldsRequest;
import org.quidity.demo.mapi.params.EditTemplateFieldsResponse;
import org.quidity.demo.mapi.params.ParameterService;
import org.quidity.demo.mapi.spatial.SpatialService;
import org.quidity.demo.mapi.spatial.UpdateFeatureRequest;
import org.quidity.demo.mapi.spatial.UpdateFeatureResponse;
import org.quidity.demo.util.AppUtil;
import org.quidity.demo.util.GuiUtil;


import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class FeatureEditActivity extends Activity
        implements ParameterService.EditTemplateFieldsListener,
        DatePickerDialog.OnDateSetListener,
        TimePickerDialog.OnTimeSetListener,
        AttributesService.AddAttributesListener,
        AttributesService.EditAttributesListener,
        SpatialService.UpdateFeatureListener
{

    private List<EditTemplateField> fields;
    private ViewGroup formLayout;
    private Feature feature;
    private boolean isUpdateMode;

    private SimpleDateFormat sdfGeoDate;    //date format for Geoserver
    private SimpleDateFormat sdfGeoDateTime;    //date format for Geoserver
    private SimpleDateFormat sdfGeoDateTimeZone;  //date format for Geoserver with timezone
    private SimpleDateFormat sdfAppDate;   //date format used by this app for display purposes
    private SimpleDateFormat sdfAppDateTime;   //date format used by this app for display purposes

    //private Map<String, View> viewMap;
    private TextView currentTextView;
    private static List<FieldHelper> fieldHelpers;
    private FieldHelper currentFieldHelper;     //the field that is currently being edited

    private static final int REQUEST_PICK_COLOR = 100;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_feature_edit);

        AppUtil.initActivity(this);

        formLayout = (ViewGroup)findViewById(R.id.form_layout);

        sdfGeoDate = new SimpleDateFormat("yyyy-MM-dd");
        sdfGeoDateTime = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSSSSS");
        sdfGeoDateTimeZone = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSSSSSZ");
        sdfAppDate = new SimpleDateFormat("yyyy/MM/dd");
        sdfAppDateTime = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");

        isUpdateMode = Session.getSession().getEditMode().equalsIgnoreCase(Session.EDIT_MODE_UPDATE);
        if (isUpdateMode) {
            setTitle("Edit Object");

            int featureIndex = Session.getSession().getSelectedFeatureIndex();
            feature = Session.getSession().getSelectedFeatures().get(featureIndex);
        }
        else {
            setTitle("New Object");
            feature = new Feature();
        }

        getEditTemplateFields();
    }

    private void getEditTemplateFields() {
        ParameterService service = new ParameterService();
        long layerEditId = Session.getSession().getCurrentEditTemplate().getLayerEditId();
        EditTemplateFieldsRequest request = new EditTemplateFieldsRequest();
        service.editTemplateFields(layerEditId, request, this);
    }

    @Override
    public void editTemplateFieldsCompleted(EditTemplateFieldsResponse response) {
        fields = response.getEditTemplateFields();

        createForm();
    }

    private void createForm() {
        //viewMap = new HashMap<String, View>();
        fieldHelpers = new ArrayList<FieldHelper>();

        for (final EditTemplateField field : fields) {

            //skip this field if it is not visible
            if (!field.isVisible()) {
                continue;
            }

            final FieldHelper fieldHelper = new FieldHelper();
            fieldHelper.setTemplateField(field);

            TextView labelView = new TextView(this);
            labelView.setText(field.getFieldCaption() + ":");
            formLayout.addView(labelView);

            if (isTextField(field) || isNumericField(field) || isDecimalField(field) || isMoneyField(field) || isCharacterField(field)) {


                if (field.getLookupValues() != null && field.getLookupValues().length() > 0) {

                    Spinner spinner = createSpinner(field);

                    //set default value
                    selectSpinnerValue(spinner, field.getDefaultValue());

                    //set current value
                    if (isUpdateMode) {
                        selectSpinnerValue(spinner, getValueForField(field));
                    }

                    spinner.setEnabled(field.isEditable());

                    formLayout.addView(spinner);
                    fieldHelper.setValueView(spinner);
                }
                else {
                    EditText valueView = new EditText(this);

                    valueView.setHint("Enter value");

                    //set default value
                    String defaultValue = field.getDefaultValue();
                    if (field.getDefaultValue() != null) {
                        defaultValue = defaultValue.replaceAll(",", ".");   //replace commas with dots
                        valueView.setText(defaultValue);
                    }

                    //set current value
                    if (isUpdateMode) {
                        String value = getValueForField(field);
                        if (value != null && isMoneyField(field)) {
                            value = value.replaceAll(",", ".");                 //replace commas with dots
                            value = value.replaceAll("R", "");
                            value = value.replaceAll(" ", "");
                        }
                        valueView.setText(value);
                    }

                    //set correct input method (keyboard)
                    if (isTextField(field)) {
                        valueView.setInputType(InputType.TYPE_CLASS_TEXT | InputType.TYPE_TEXT_VARIATION_NORMAL);
                    }
                    else if (isNumericField(field)) {
                        valueView.setInputType(InputType.TYPE_CLASS_NUMBER | InputType.TYPE_NUMBER_VARIATION_NORMAL);
                    }
                    else if (isDecimalField(field) || isMoneyField(field)) {
                        valueView.setInputType(InputType.TYPE_CLASS_NUMBER | InputType.TYPE_NUMBER_FLAG_DECIMAL);
                    }
                    else if(isCharacterField(field)) {
                        valueView.setInputType(InputType.TYPE_CLASS_TEXT | InputType.TYPE_TEXT_VARIATION_NORMAL);
                    }

                    //limit number of characters
                    int maxLen = field.getFieldSize();
                    if (isCharacterField(field)) {
                        maxLen = 1;
                    }
                    if (maxLen > 0) {
                        InputFilter[] inputFilters = new InputFilter[1];
                        inputFilters[0] = new InputFilter.LengthFilter(maxLen);
                        valueView.setFilters(inputFilters);
                    }

                    valueView.setEnabled(field.isEditable());

                    formLayout.addView(valueView);
                    //viewMap.put(field.getFieldName(), valueView);
                    fieldHelper.setValueView(valueView);
                }

            }
            else if (isBooleanField(field)) {
                CheckBox cb = new CheckBox(this);

                //set default value
                cb.setChecked(boolFromStr(field.getDefaultValue()));

                //set current value
                if (isUpdateMode) {
                    cb.setChecked(boolFromStr(getValueForField(field)));
                }

                cb.setEnabled(field.isEditable());

                formLayout.addView(cb);
                //viewMap.put(field.getFieldName(), cb);
                fieldHelper.setValueView(cb);
            }
            else if(isBarcodeField(field)) {

                TextView valueView = new TextView(this);

                Button scanButton = new Button(this);
                scanButton.setText("Scan");
                scanButton.setEnabled(field.isEditable());
                scanButton.setOnClickListener(new View.OnClickListener() {
                    @Override
                    public void onClick(View view) {
                        currentFieldHelper = fieldHelper;

                        IntentIntegrator scanIntegrator = new IntentIntegrator(FeatureEditActivity.this);
                        scanIntegrator.initiateScan();
                    }
                });

                //set default value
                valueView.setText(field.getDefaultValue());

                //set current value
                if (isUpdateMode) {
                    valueView.setText(getValueForField(field));
                }


                formLayout.addView(valueView);
                formLayout.addView(scanButton);

                //viewMap.put(field.getFieldName(), cb);
                fieldHelper.setValueView(valueView);

            }
            else if (isColorField(field)) {
                Button button = new Button(this);
                button.setText("Choose Color");
                button.setEnabled(field.isEditable());

                TextView colorView = new TextView(this);
                colorView.setPadding(20,20,20,20);
                colorView.setLayoutParams(new ViewGroup.LayoutParams(ViewGroup.LayoutParams.WRAP_CONTENT, ViewGroup.LayoutParams.WRAP_CONTENT));
                fieldHelper.setValueView(colorView);

                if (isUpdateMode) {
                    String currentHexColor = getValueForField(field);
                    fieldHelper.setStringValue(currentHexColor);
                    updateDisplay(fieldHelper);
                }

                button.setOnClickListener(new View.OnClickListener() {
                    @Override
                    public void onClick(View view) {
                        currentFieldHelper = fieldHelper;

                        String hexColor = fieldHelper.getStringValue();
                        int intColor = 0;
                        if (hexColor != null && hexColor.length() >= 6) {
                            try {
                                intColor = Color.parseColor(hexColor);
                            }
                            catch (IllegalArgumentException e) {
                                //could not parse
                            }
                        }

                        Intent intent = new Intent(FeatureEditActivity.this, ColorPickerActivity.class);
                        if (isUpdateMode) {
                            intent.putExtra(ColorPickerActivity.CURRENT_COLOR, intColor);
                        }
                        startActivityForResult(intent, REQUEST_PICK_COLOR);
                    }
                });

                formLayout.addView(colorView);
                formLayout.addView(button);

            }
            else if(isDateField(field)) {
                /*
                LinearLayout layout = new LinearLayout(this);
                layout.setLayoutParams(new LinearLayout.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.WRAP_CONTENT));
                layout.setOrientation(LinearLayout.HORIZONTAL);
                */
                final TextView valueView = new TextView(this);
                //set default value
                valueView.setText(parseAndFormatDate(field.getDefaultValue(), false));
                if (isUpdateMode) {
                    valueView.setText(parseAndFormatDate(getValueForField(field), false));
                }
                formLayout.addView(valueView);
                //viewMap.put(field.getFieldName(), valueView);
                fieldHelper.setValueView(valueView);

                Button editButton = new Button(this);
                editButton.setText("Choose Date");
                editButton.setOnClickListener(new View.OnClickListener() {
                    @Override
                    public void onClick(View view) {
                        currentTextView = valueView;
                        currentFieldHelper = fieldHelper;
                        Date date = parseAppDate(valueView.getText().toString());
                        Calendar cal = Calendar.getInstance();
                        if (date != null) {
                            cal.setTime(date);
                        }
                        int year = cal.get(Calendar.YEAR);
                        int month = cal.get(Calendar.MONTH);
                        int day = cal.get(Calendar.DAY_OF_MONTH);
                        DatePickerDialog dialog = new DatePickerDialog(FeatureEditActivity.this, FeatureEditActivity.this, year, month, day);
                        dialog.show();
                    }
                });
                editButton.setEnabled(field.isEditable());
                formLayout.addView(editButton);

                //formLayout.addView(layout);
            }
            else if(isDateTimeField(field)) {

                LinearLayout buttonLayout = new LinearLayout(this);
                buttonLayout.setLayoutParams(new LinearLayout.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.WRAP_CONTENT));
                buttonLayout.setOrientation(LinearLayout.HORIZONTAL);

                final TextView valueView = new TextView(this);
                valueView.setText(parseAndFormatDate(field.getDefaultValue(), true));
                if (isUpdateMode) {
                    valueView.setText(parseAndFormatDate(getValueForField(field), true));
                }
                formLayout.addView(valueView);
                //viewMap.put(field.getFieldName(), valueView);
                fieldHelper.setValueView(valueView);

                Button editDateButton = new Button(this);
                editDateButton.setText("Choose Date");
                editDateButton.setOnClickListener(new View.OnClickListener() {
                    @Override
                    public void onClick(View view) {
                        currentFieldHelper = fieldHelper;
                        Date date = parseAppDateTime(valueView.getText().toString());
                        Calendar cal = Calendar.getInstance();
                        if (date != null) {
                            cal.setTime(date);
                        }
                        int year = cal.get(Calendar.YEAR);
                        int month = cal.get(Calendar.MONTH);
                        int day = cal.get(Calendar.DAY_OF_MONTH);
                        DatePickerDialog dialog = new DatePickerDialog(FeatureEditActivity.this, FeatureEditActivity.this, year, month, day);
                        dialog.show();
                    }
                });
                editDateButton.setEnabled(field.isEditable());
                buttonLayout.addView(editDateButton);

                Button editTimeButton = new Button(this);
                editTimeButton.setText("Choose Time");
                editTimeButton.setOnClickListener(new View.OnClickListener() {
                    @Override
                    public void onClick(View view) {
                        currentFieldHelper = fieldHelper;
                        Date date = parseAppDateTime(valueView.getText().toString());
                        Calendar cal = Calendar.getInstance();
                        if (date != null) {
                            cal.setTime(date);
                        }
                        int hour = cal.get(Calendar.HOUR_OF_DAY);
                        int minute = cal.get(Calendar.MINUTE);

                        TimePickerDialog dialog = new TimePickerDialog(FeatureEditActivity.this, FeatureEditActivity.this, hour, minute, true);
                        dialog.show();
                    }
                });
                editTimeButton.setEnabled(field.isEditable());
                buttonLayout.addView(editTimeButton);

                formLayout.addView(buttonLayout);
            }

            //add some whitespace between fields
            View space = new View(this);
            space.setLayoutParams(new ViewGroup.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, 20));
            formLayout.addView(space);

            fieldHelpers.add(fieldHelper);
        }
    }

    private String parseAndFormatDate(String dateStr, boolean dateAndTime) {
        String formatted = null;

        Date date = parseGeoDate(dateStr);

        if (date != null) {
            if (dateAndTime) {
                formatted = sdfAppDateTime.format(date);
            }
            else {
                formatted = sdfAppDate.format(date);
            }

        }

        return formatted;
    }

    private Date parseAppDate(String dateStr) {
        Date date = null;
        try {
            date = sdfAppDate.parse(dateStr);
        }
        catch (ParseException pe) {

        }
        return date;
    }

    private Date parseAppDateTime(String dateStr) {
        Date date = null;
        try {
            date = sdfAppDateTime.parse(dateStr);
        }
        catch (ParseException pe) {

        }
        return date;
    }


    private Date parseGeoDate(String dateStr) {
        Date date = null;

        try {
            date = sdfGeoDateTimeZone.parse(dateStr);
        }
        catch (ParseException pe) {

        }

        if (date == null) {
            try {
                date = sdfGeoDateTime.parse(dateStr);
            }
            catch (ParseException pe) {

            }
        }

        if (date == null) {
            try {
                date = sdfGeoDate.parse(dateStr);
            }
            catch (ParseException pe) {

            }
        }

        return date;
    }

    private void selectSpinnerValue(Spinner spinner, String value) {
        int position = -1;
        for (int c = 0;c<spinner.getCount();c++) {
            String itemValue = (String)spinner.getItemAtPosition(c);
            if (itemValue.equalsIgnoreCase(value)) {
                position = c;
                break;
            }
        }

        if (position != -1) {
            spinner.setSelection(position);
        }
    }

    private boolean boolFromStr(String value) {
        return (value.equalsIgnoreCase("t") || value.equalsIgnoreCase("true"));
    }


    private String getValueForField(EditTemplateField field) {
        return (String)feature.getProperties().get(field.getFieldName());
    }

    @Override
    public void onDateSet(DatePicker datePicker, int year, int monthOfYear, int dayOfMonth) {

        int currentHourOfDay = 0;
        int currentMinute = 0;
        Date currentDate = currentFieldHelper.getDateValue();
        if (currentDate != null) {
            Calendar currentCal = Calendar.getInstance();
            currentCal.setTime(currentDate);
            currentHourOfDay = currentCal.get(Calendar.HOUR_OF_DAY);
            currentMinute = currentCal.get(Calendar.MINUTE);
        }

        Calendar newCal = Calendar.getInstance();
        newCal.set(year, monthOfYear, dayOfMonth, currentHourOfDay, currentMinute, 0);
        Date newDate = newCal.getTime();
        currentFieldHelper.setDateValue(newDate);

        updateDisplay(currentFieldHelper);
    }

    @Override
    public void onTimeSet(TimePicker timePicker, int hourOfDay, int minute) {

        int currentYear = 0;
        int currentMonthOfYear = 0;
        int currentDayOfMonth = 0;
        Date currentDate = currentFieldHelper.getDateValue();
        if (currentDate != null) {
            Calendar currentCal = Calendar.getInstance();
            currentCal.setTime(currentDate);
            currentYear = currentCal.get(Calendar.YEAR);
            currentMonthOfYear = currentCal.get(Calendar.MONTH);
            currentDayOfMonth = currentCal.get(Calendar.DAY_OF_MONTH);
        }

        Calendar newCal = Calendar.getInstance();
        newCal.set(currentYear, currentMonthOfYear, currentDayOfMonth, hourOfDay, minute, 0);
        Date newDate = newCal.getTime();
        currentFieldHelper.setDateValue(newDate);

        updateDisplay(currentFieldHelper);
    }

    private void updateDisplay(FieldHelper helper) {
        String formattedValue = null;

        EditTemplateField templateField = helper.getTemplateField();
        if (isDateField(templateField)) {
            formattedValue = sdfAppDate.format(helper.getDateValue());

            TextView textView = (TextView)helper.getValueView();
            textView.setText(formattedValue);
        }
        else if(isDateTimeField(templateField)) {
            formattedValue = sdfAppDateTime.format(helper.getDateValue());

            TextView textView = (TextView)helper.getValueView();
            textView.setText(formattedValue);
        }
        else if(isColorField(templateField)) {
            String hexColor = helper.getStringValue();
            try {
                int intColor = Color.parseColor(hexColor);

                TextView colorView = (TextView)helper.getValueView();
                colorView.setBackgroundColor(intColor);
                colorView.setText(hexColor);
            }
            catch (Exception e) {
                //could not parse color, ignore
                Log.e(getClass().getCanonicalName(), e.getLocalizedMessage(), e);
            }

        }

    }

    private boolean isTextField(EditTemplateField field) {
        return field.getFieldType().equalsIgnoreCase("string") ||
                field.getFieldType().equalsIgnoreCase("java.lang.String");
    }

    private boolean isCharacterField(EditTemplateField field) {
        return field.getFieldType().equalsIgnoreCase("character") ||
                field.getFieldType().equalsIgnoreCase("char") ||
                field.getFieldType().equalsIgnoreCase("java.lang.Character");

    }


    private boolean isBarcodeField(EditTemplateField field) {
        return field.getFieldType().toLowerCase().startsWith("barcode") ||
                field.getFieldType().toLowerCase().startsWith("qrcode");
    }

    private boolean isNumericField(EditTemplateField field) {
        return field.getFieldType().equalsIgnoreCase("int") ||
                field.getFieldType().equalsIgnoreCase("integer") ||
                field.getFieldType().equalsIgnoreCase("short") ||
                field.getFieldType().equalsIgnoreCase("long") ||
                field.getFieldType().equalsIgnoreCase("java.lang.Integer") ||
                field.getFieldType().equalsIgnoreCase("java.lang.Long");
    }

    private boolean isDecimalField(EditTemplateField field) {
        return field.getFieldType().equalsIgnoreCase("decimal") ||
                field.getFieldType().equalsIgnoreCase("bigdecimal") ||
                field.getFieldType().equalsIgnoreCase("double") ||
                field.getFieldType().equalsIgnoreCase("java.lang.Double");
    }

    private boolean isMoneyField(EditTemplateField field) {
        return field.getFieldType().equalsIgnoreCase("money");
    }


    private boolean isBooleanField(EditTemplateField field) {
        return field.getFieldType().equalsIgnoreCase("boolean") ||
                field.getFieldType().equalsIgnoreCase("bool") ||
                field.getFieldType().equalsIgnoreCase("java.lang.Boolean");
    }

    private boolean isColorField(EditTemplateField field) {
        return field.getFieldType().equalsIgnoreCase("color");
    }

    private boolean isDateField(EditTemplateField field) {
        return field.getFieldType().equalsIgnoreCase("date");
    }

    private boolean isDateTimeField(EditTemplateField field) {
        return field.getFieldType().equalsIgnoreCase("dateTime") ||
                field.getFieldType().equalsIgnoreCase("timestamp");

    }

    private Spinner createSpinner(EditTemplateField field) {
        Spinner spinner = new Spinner(this);

        String[] items = field.getLookupValues().split(",");

        ArrayAdapter<String> adapter = new ArrayAdapter<String>(this, android.R.layout.simple_dropdown_item_1line, android.R.id.text1);
        //requires API level 11
        //adapter.addAll(items);
        for(String item : items) {
            adapter.add(item);
        }
        spinner.setAdapter(adapter);

        return spinner;
    }

    @Override
    public void editTemplateFieldsFailed(String reason) {
        GuiUtil.showError(this, reason);
    }

    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        // Inflate the menu; this adds items to the action bar if it is present.
        getMenuInflater().inflate(R.menu.feature_edit, menu);
        return true;
    }

    @Override
    public boolean onPrepareOptionsMenu(Menu menu) {
        MenuItem attachmentsItem = menu.findItem(R.id.action_attachments);

        attachmentsItem.setEnabled(isUpdateMode);

        return super.onPrepareOptionsMenu(menu);
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        int id = item.getItemId();
        if (id == R.id.action_attachments) {
            showAttachments();
            return true;
        }
        else if(id == R.id.action_save) {
            save();
            return true;
        }
        return super.onOptionsItemSelected(item);
    }

    private void showAttachments() {
        Intent intent = new Intent(this, AttachmentsActivity.class);
        startActivity(intent);
    }

    private void save() {
        if(fillFeatureValuesAndValidate()) {

            if (isUpdateMode) {
                updateExistingFeature();
            } else {
                saveNewFeature();
            }
        }
    }



    private boolean fillFeatureValuesAndValidate() {
        boolean isValid = true;
        Map<String, Object> properties = feature.getProperties();
        if (properties == null) {
            properties = new HashMap<String, Object>();
            feature.setProperties(properties);
        }

        for(FieldHelper helper : fieldHelpers) {
            EditTemplateField field = helper.getTemplateField();
            String fieldName = field.getFieldName();
            //View view = viewMap.get(fieldName);
            View view = helper.getValueView();
            if (view != null) {
                String value = null;

                if (isDateField(field)) {
                    Date date = helper.getDateValue();
                    if (date != null) {
                        value = sdfGeoDate.format(date);
                    }
                }
                else if (isDateTimeField(field)) {
                    Date date = helper.getDateValue();
                    if (date != null) {
                        value = sdfGeoDateTime.format(date);
                    }
                }
                else if (isMoneyField(field)) {
                    value = ((TextView)view).getText().toString();
                    value = value.replaceAll("\\.", ",");         //replace dots with commas
                }
                else if (isBooleanField(field)) {
                    CheckBox checkBox = (CheckBox)view;
                    value = checkBox.isChecked() ? "t" : "f";
                }
                else if (view instanceof TextView) {
                    value = ((TextView)view).getText().toString();
                }
                else if(view instanceof EditText) {
                    value = ((EditText)view).getText().toString();
                }
                else if(view instanceof Spinner) {
                    value = (String)((Spinner)view).getSelectedItem();
                }
                else {
                    Log.d(getClass().getCanonicalName(), "Unsupported view type " + view.getClass().getCanonicalName());
                }

                //validate required fields
                boolean hasValue = value != null && value.trim().length() > 0;
                if (!field.isNullable() && !hasValue) {
                    GuiUtil.showWarning(this, "Please provide a value for " + field.getFieldCaption());
                    isValid = false;
                }

                properties.put(fieldName, value);
            }
            else {
                Log.d(getClass().getCanonicalName(), "Now view for field " + fieldName);
            }
        }
        return isValid;
    }

    private void saveNewFeature() {
        AddAttributesRequest request = new AddAttributesRequest();
        long layerId = Session.getSession().getCurrentActiveLayer().getId();
        long layerEditId = Session.getSession().getCurrentEditTemplate().getLayerEditId();
        request.setLayerId(layerId);
        request.setEditId(layerEditId);

        AttributesService service = new AttributesService();
        service.addAttributes(request, feature, this);

    }

    private void updateExistingFeature() {
        EditAttributesRequest request = new EditAttributesRequest();
        long layerId = Session.getSession().getCurrentActiveLayer().getId();
        long layerEditId = Session.getSession().getCurrentEditTemplate().getLayerEditId();
        long primaryId = AppUtil.getPrimaryIdForSelectedFeature();
        request.setLayerId(layerId);
        request.setEditId(layerEditId);
        request.setPrimaryId(primaryId);

        AttributesService service = new AttributesService();
        service.editAttributes(request, feature, this);

    }

    private void saveGeometry(long primaryId) {

        UpdateFeatureRequest request = new UpdateFeatureRequest();
        long layerId = Session.getSession().getCurrentActiveLayer().getId();
        request.setLayerId(layerId);
        request.setPrimaryId(primaryId);

        Geometry geometry = new Geometry();
        geometry.setType("Point");
        double longitude = Session.getSession().getCurrentLongitude();
        double latitude = Session.getSession().getCurrentLatitude();
        double[] coordinates = new double[] {longitude, latitude};
        geometry.setCoordinates(coordinates);

        SpatialService service = new SpatialService();
        service.updateFeature(request, geometry, this);
    }

    @Override
    public void addAttributesCompleted(AddAttributesResponse response) {
        if (response.getMessage().equalsIgnoreCase("Success")) {
            long primaryId = response.getPrimaryId();
            saveGeometry(primaryId);
        }
        else {
            Toast.makeText(this, response.getMessage(), Toast.LENGTH_LONG).show();
        }
    }

    @Override
    public void addAttributesFailed(String reason) {
        GuiUtil.showError(this, reason);
    }

    @Override
    public void editAttributesCompleted(EditAttributesResponse response) {
        if (response.getMessage().equalsIgnoreCase("Success")) {
            Toast.makeText(this, "Object updated successfully.", Toast.LENGTH_SHORT).show();
            finish();
        }
        else {
            Toast.makeText(this, response.getMessage(), Toast.LENGTH_LONG).show();
        }

    }

    @Override
    public void editAttributesFailed(String reason) {
        GuiUtil.showError(this, reason);
    }


    @Override
    public void updateFeatureCompleted(UpdateFeatureResponse response) {
        if (response.getMessage().equalsIgnoreCase("Success")) {
            Toast.makeText(this, "New object created successfully.", Toast.LENGTH_SHORT).show();
            finish();
        }
        else {
            Toast.makeText(this, response.getMessage(), Toast.LENGTH_LONG).show();
        }

    }

    @Override
    public void updateFeatureFailed(String reason) {
        GuiUtil.showError(this, reason);
    }

    @Override
    protected void onActivityResult(int requestCode, int resultCode, Intent data) {

        if (requestCode == REQUEST_PICK_COLOR && resultCode == RESULT_OK) {
            int intColor = data.getIntExtra(ColorPickerActivity.SELECTED_COLOR, 0);
            String hexColor = null;
            if (intColor != 0) {
                hexColor = String.format("#%06X", (0xFFFFFF & intColor));
                Log.d(getClass().getCanonicalName(), "intColor " + "hexColor " + hexColor);
            }

            currentFieldHelper.setStringValue(hexColor);
            updateDisplay(currentFieldHelper);
        }
        else {
            //check if this is a barcode scan result
            IntentResult scanResult = IntentIntegrator.parseActivityResult(requestCode, resultCode, data);
            if (scanResult != null) {
                String barcode = scanResult.getContents();
                currentFieldHelper.setStringValue(barcode);

                TextView valueView = (TextView)currentFieldHelper.getValueView();
                valueView.setText(barcode);
            }
        }


    }
}
