package org.quidity.demo.activity;

import android.app.ListActivity;
import android.content.Intent;
import android.support.v7.app.ActionBarActivity;
import android.os.Bundle;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.widget.ArrayAdapter;
import android.widget.ListAdapter;
import android.widget.ListView;

import org.quidity.demo.R;
import org.quidity.demo.Session;
import org.quidity.demo.mapi.params.EditTemplate;
import org.quidity.demo.mapi.params.EditTemplatesRequest;
import org.quidity.demo.mapi.params.EditTemplatesResponse;
import org.quidity.demo.mapi.params.Layer;
import org.quidity.demo.mapi.params.ParameterService;
import org.quidity.demo.util.AppUtil;
import org.quidity.demo.util.GuiUtil;

import java.util.List;

public class EditTemplateActivity extends ListActivity implements ParameterService.EditTemplatesListener {

    private List<EditTemplate> editTemplates;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);

        AppUtil.initActivity(this);

        getEditTemplates();
    }

    private void getEditTemplates() {
        EditTemplatesRequest request = new EditTemplatesRequest();
        ParameterService service = new ParameterService();
        long layerId = Session.getSession().getCurrentActiveLayer().getId();
        service.editTemplates(layerId, request, this);
    }

    @Override
    public void editTemplatesCompleted(EditTemplatesResponse response) {
        editTemplates = response.getEditTemplates();

        ListAdapter adapter = new ArrayAdapter<EditTemplate>(this, android.R.layout.simple_list_item_single_choice, editTemplates);
        getListView().setAdapter(adapter);

        getListView().setChoiceMode(ListView.CHOICE_MODE_SINGLE);

        int defaultIndex = getDefaultTemplateIndex();
        getListView().setItemChecked(defaultIndex, true);

    }

    private int getDefaultTemplateIndex() {

        int defaultIndex = 0;

        for(int index = 0;index<editTemplates.size();index++) {
            EditTemplate template = editTemplates.get(index);
            if (template.isEditDefault()) {
                defaultIndex = index;
                break;
            }
        }

        return defaultIndex;
    }

    @Override
    public void editTemplatesFailed(String reason) {
        GuiUtil.showError(this, reason);
    }

    @Override
    protected void onListItemClick(ListView l, View v, int position, long id) {
        EditTemplate selectedTemplate = editTemplates.get(position);

        Session.getSession().setCurrentEditTemplate(selectedTemplate);

        Intent intent = new Intent(this, FeatureEditActivity.class);
        startActivity(intent);
    }
}
